/*
 * sync.c,v 2.0 1992/04/23 02:52:59 ware Exp
 * sync.c,v
 * Revision 2.0  1992/04/23  02:52:59  ware
 * First public release.
 *
 * Revision 1.4  1992/04/23  02:19:08  ware
 * Added several classes.  Worked on geometry management
 *
 * Revision 1.3  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.2  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.1  1991/07/19  00:58:43  pete
 * Initial revision
 *
 */

#include <X11/IntrinsicP.h>
#include <X11/Xo/XoP.h>

static Bool     check_event ();
XoProto (static Bool, check_event, (XEvent *event, int mask));
XoProto (static Bool, check_proc, (Display *display, XEvent *event, char *arg));

void
XoSync (gw, mask)
	Widget          gw;		/* Display to use */
	long            mask;		/* type of events to check for */
{
	XEvent          event;

	XSync (XtDisplay (gw), FALSE);
	while (XCheckIfEvent (XtDisplay (gw), &event, check_proc,
			      (char *) &mask))
	{
		XtDispatchEvent (&event);
	}
}

/*ARGSUSED*/
static          Bool
check_proc (display, event, arg)
	Display        *display;
	XEvent         *event;
	char           *arg;
{
	int             mask = *((int *) arg);
	int             indx;
	Bool            found = FALSE;

	for (indx = 0; indx < (sizeof (int) * 8) && found != TRUE; indx++)
	{
		if ((1L << (indx - 1)) & mask)
		{
			found = check_event (event, (1L << (indx - 1)));
		}
	}
	return found;
}

static          Bool
check_event (event, mask)
	XEvent         *event;
	int             mask;
{
	Bool            found = FALSE;

	switch (mask)
	{
	case NoEventMask:
		break;
	case KeyPressMask:
		if (event->type == KeyPress)
			found = TRUE;
		break;
	case KeyReleaseMask:
		if (event->type == KeyRelease)
			found = TRUE;
		break;
	case ButtonPressMask:
		if (event->type == ButtonPress)
			found = TRUE;
		break;
	case ButtonReleaseMask:
		if (event->type == ButtonRelease)
			found = TRUE;
		break;
	case EnterWindowMask:
		if (event->type == EnterNotify)
			found = TRUE;
		break;
	case LeaveWindowMask:
		if (event->type == LeaveNotify)
			found = TRUE;
		break;
	case PointerMotionMask:
		if (event->type == MotionNotify)
			found = TRUE;
		break;
	case PointerMotionHintMask:
		/* no corresponding event */
		break;
	case Button1MotionMask:
	case Button2MotionMask:
	case Button3MotionMask:
	case Button4MotionMask:
	case Button5MotionMask:
	case ButtonMotionMask:
		if (event->type == MotionNotify)
			found = TRUE;
		break;
	case KeymapStateMask:
		if (event->type == KeymapNotify)
			found = TRUE;
		break;
	case ExposureMask:
		if (event->type == Expose ||
		    event->type == GraphicsExpose ||
		    event->type == NoExpose)
			found = TRUE;
		break;
	case VisibilityChangeMask:
		if (event->type == VisibilityNotify)
			found = TRUE;
		break;
	case StructureNotifyMask:
		if (event->type == CirculateNotify ||
		    event->type == ConfigureNotify ||
		    event->type == DestroyNotify ||
		    event->type == GravityNotify ||
		    event->type == MapNotify ||
		    event->type == ReparentNotify ||
		    event->type == UnmapNotify)
			found = TRUE;
		break;
	case ResizeRedirectMask:
		if (event->type == ResizeRequest)
			found = TRUE;
		break;
	case SubstructureNotifyMask:
		if (event->type == CirculateNotify ||
		    event->type == ConfigureNotify ||
		    event->type == CreateNotify ||
		    event->type == DestroyNotify ||
		    event->type == GravityNotify ||
		    event->type == MapNotify ||
		    event->type == ReparentNotify ||
		    event->type == UnmapNotify)
			found = TRUE;
		break;
	case SubstructureRedirectMask:
		if (event->type == CirculateNotify ||
		    event->type == ConfigureRequest ||
		    event->type == MapRequest)
			found = TRUE;
		break;
	case FocusChangeMask:
		if (event->type == FocusIn || event->type == FocusOut)
			found = TRUE;
		break;
	case PropertyChangeMask:
		if (event->type == PropertyNotify)
			found = TRUE;
		break;
	case ColormapChangeMask:
		if (event->type == ColormapNotify)
			found = TRUE;
		break;
	case OwnerGrabButtonMask:
		/* none */
		break;
	}
	return found;
}
