/*
 * Interface between the external menu specification and
 * the applications functionallity.   The menu specification should
 * already have been created -- any source is possible these routines
 * only use an XoMenuList structure.
 *
 * The application should call XoMenuAddFunction() to map names to functions
 * that will create the appropriate object for display.  Two defaults are
 * provided: menu & separator.
 *
 * menu.c,v
 * Revision 2.1  1992/06/23  00:29:12  pete
 * Changed interface to _XoMenuNew and _XoMenuDone.
 *
 * Revision 2.0  1992/04/23  02:52:41  ware
 * First public release.
 *
 * Revision 1.12  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.11  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.10  1991/12/01  16:14:35  pete
 * Use XoProto().
 *
 * Revision 1.9  1991/08/30  17:39:59  pete
 * XtNbelow is obsolete.
 *
 * Revision 1.8  91/08/26  11:58:26  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.7  1991/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.6  1991/06/14  10:22:01  pete
 * Set the below resource to true for menus hanging off a menu bar button.
 *
 * Revision 1.5  91/06/14  04:48:15  pete
 * no changes.
 *
 * Revision 1.4  91/06/01  10:03:20  pete
 * Working on menubar
 *
 * Revision 1.3  91/05/29  14:42:16  pete
 * Working on getting the menubar to work.
 *
 * Revision 1.2  1991/05/25  11:03:03  pete
 * Adding external menus
 *
 * Revision 1.1  91/05/23  16:50:13  pete
 * Initial revision
 *
 * Revision 1.1  90/12/19  09:55:20  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xo/Menu.h>
#include <X11/Xo/MenuButton.h>
#include <X11/Xo/MenuBarB.h>
#include <X11/Xo/MenuShell.h>
#include <X11/Xo/Label.h>
#include <X11/Xo/menu.h>
#include <X11/Xo/ObjBorder.h>		/* needed for clearInverted resource */

typedef struct _XoMenuFunc
{
	char           *f_name;
	void            (*f_create) ();
} XoMenuFunc;

XoProto (static XoMenuFunc *, menu_lookup_func, (char *name));
XoProto (static void, create_exec, (XoMenuList * l, XoMenuFunc * func, XoMenuItem * item, Widget parent));
XoProto (static void, create_menu, (XoMenuList * l, XoMenuFunc * func, XoMenuItem * item, Widget parent));
XoProto (static void, create_separator, (XoMenuList * l, XoMenuFunc * func, XoMenuItem * item, Widget parent));
XoProto (static void, create_baritem, (XoMenuList * l, XoMenuFunc * func, XoMenuItem * item, Widget parent));

static XoMenuFunc default_functions[] =
{
	{"separator", create_separator},
	{"menu", create_menu},
	{"help", create_menu},
	{"exec", create_exec},
	{"bar", create_baritem},
	{NULL, NULL},
};

void
XoMenuCreate (l, name, parent)
	XoMenuList     *l;
	char           *name;
	Widget          parent;		/* parent for this widget */
{
	XoMenuData     *m;
	XoMenuItem     *item;
	int             i;
	XoMenuFunc     *func;

	m = XoMenuFind (l, name);
	if (!m)
	{
		return;
	}
	for (i = 0; i < m->m_numitems; i++)
	{
		item = m->m_list[i];
		if (!item)
			continue;
		if (!item->i_function)
			continue;
		func = menu_lookup_func (item->i_function);
		if (!func || !func->f_create)
			continue;
		(*func->f_create) (l, func, item, parent);
	}
}

static XoMenuFunc *
menu_lookup_func (name)
	char           *name;
{
	XoMenuFunc     *f;

	if (!name)
		return ((XoMenuFunc *) NULL);
	for (f = default_functions; f && f->f_name; f++)
	{
		if (strcmp (f->f_name, name) == 0)
			break;
	}
	if (!f || !f->f_name)
		return ((XoMenuFunc *) NULL);
	else
		return f;
}

static void
create_separator (l, func, item, parent)
	XoMenuList     *l;
	XoMenuFunc     *func;
	XoMenuItem     *item;
	Widget          parent;
{
	Cardinal        cnt;
	Arg             args[10];
	Widget          gw;

	cnt = 0;
	gw = XtCreateManagedWidget (item->i_label,
				    xoLabelWidgetClass,
				    parent, args, cnt);
}

static void
create_menu (l, func, item, parent)
	XoMenuList     *l;
	XoMenuFunc     *func;
	XoMenuItem     *item;
	Widget          parent;
{
	Cardinal        cnt;
	Arg             args[10];
	Widget          gw;
	Widget          popup;
	Widget          menu;
	char            name[128];

	cnt = 0;
	XtSetArg (args[cnt], XtNclearInverted, True);
	++cnt;
	gw = XtCreateManagedWidget (item->i_label, xoMenuButtonWidgetClass,
				    parent, args, cnt);
	cnt = 0;
	popup = XoMenuMakeUtil (item->i_label, parent, args, cnt);

	cnt = 0;
	sprintf (name, "menu-%s", item->i_label);
	menu = XtCreateWidget (name, xoMenuWidgetClass, popup,
			       args, cnt);
	cnt = 0;
	XtSetArg (args[cnt], XtNsubMenu, menu);
	++cnt;
	XtSetValues (gw, args, cnt);
	XoMenuCreate (l, item->i_argv[0], menu);
}

static void
exec_callback (gw, client_data, call_data)
	Widget          gw;
	caddr_t         client_data;
	caddr_t         call_data;
{
}


static void
create_exec (l, func, item, parent)
	XoMenuList     *l;
	XoMenuFunc     *func;
	XoMenuItem     *item;
	Widget          parent;
{
	Cardinal        cnt;
	Arg             args[10];
	Widget          gw;

	cnt = 0;
	XtSetArg (args[cnt], XtNclearInverted, True);
	++cnt;
	gw = XtCreateManagedWidget (item->i_label, xoMenuButtonWidgetClass,
				    parent, args, cnt);
	XtAddCallback (gw, XtNcallback, exec_callback, (XtPointer) item);
}

static void
create_baritem (l, func, item, parent)
	XoMenuList     *l;
	XoMenuFunc     *func;
	XoMenuItem     *item;
	Widget          parent;
{
	Cardinal        cnt;
	Arg             args[10];
	Widget          gw;
	Widget          popup;
	Widget          menu;
	char            name[128];

	cnt = 0;
	XtSetArg (args[cnt], XtNclearInverted, True);
	++cnt;
	gw = XtCreateManagedWidget (item->i_label, xoMenuBarButtonWidgetClass,
				    parent, args, cnt);
	cnt = 0;
	XtSetArg (args[cnt], XtNstart, True);
	++cnt;
	popup = XoMenuMakeUtil (item->i_label, parent, args, cnt);

	cnt = 0;
	sprintf (name, "menu-%s", item->i_label);
	menu = XtCreateWidget (name, xoMenuWidgetClass, popup,
			       args, cnt);
	cnt = 0;
	XtSetArg (args[cnt], XtNsubMenu, menu);
	++cnt;
	XtSetValues (gw, args, cnt);
	XoMenuCreate (l, item->i_argv[0], menu);
}
