/*
 * ObjArrow.c,v 2.2 1992/08/11 00:16:57 pete Exp
 * ObjArrow.c,v
 * Revision 2.2  1992/08/11  00:16:57  pete
 * Update GC if foreground changes.
 *
 * Revision 2.1  1992/06/23  00:29:03  pete
 * Changed interface to _XoMenuNew and _XoMenuDone.
 *
 * Revision 2.0  1992/04/23  02:51:39  ware
 * First public release.
 *
 * Revision 1.1  1992/04/23  02:20:17  ware
 * Part of the Xo widget set
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/ObjArrowP.h>
#include <X11/Xo/dbug.h>

#include <X11/Xo/ObjARec.h>

XoProto (static void, CalcGC, (Widget gw));

/*
 *----------------------------------------------------------------------
 * RectObj Class Methods
 *----------------------------------------------------------------------
 */

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{
	XoObjArrowWidget   w = (XoObjArrowWidget) new;

	w->obj_arrow.gc = NULL;
	CalcGC (new);
#define DEFAULT_SIZE 10

	if (w->rectangle.width == 0)
		w->rectangle.width = DEFAULT_SIZE;
	if (w->rectangle.height == 0)
		w->rectangle.height = DEFAULT_SIZE;
}

static void
Destroy (gw)
	Widget          gw;
{
	XoObjArrowWidget w = (XoObjArrowWidget) gw;

	if (w->obj_arrow.gc)
	{
		XtReleaseGC (gw, w->obj_arrow.gc);
		w->obj_arrow.gc = NULL;
	}
}

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoObjArrowWidget w = (XoObjArrowWidget) new;
	XoObjArrowWidget cur = (XoObjArrowWidget) current;
	Boolean         redisplay = False;

	if (w->obj_draw.fg != cur->obj_draw.fg ||
	    w->rectangle.border_width != cur->rectangle.border_width)
	{
		redisplay = True;
		CalcGC (new);
	}
	if (w->obj_arrow.direction != cur->obj_arrow.direction)
		redisplay = True;
	return redisplay;
}

/*
 * Redraw the arrow.
 */

static void
Redisplay (gw, event, region)
	Widget          gw;		/* should be subclassof ObjDraw */
	XEvent         *event;		/* the exposure event */
	Region          region;		/* the uncovered region */
{
	XoObjArrowWidget w = (XoObjArrowWidget) gw;
	XPoint		point[4];

	DBUG_ENTER ("ObjArrow.Redisplay");
	if (w->obj_draw.no_draw)
	{
		DBUG_VOID_RETURN;
	}
	switch (w->obj_arrow.direction)
	{
	case XoLEFT:
		/* start at lower right, go to apex then upper right */
		point[0].x = _XoObjDrawRight (w);
		point[0].y = _XoObjDrawBottom (w);
		point[1].x = _XoObjDrawLeft (w);
		point[1].y = _XoObjDrawTop (w) +
			(_XoObjDrawBottom (w) - _XoObjDrawTop (w))/2;
		point[2].x = _XoObjDrawRight (w);
		point[2].y = _XoObjDrawTop (w);
		break;
	case XoRIGHT:
		/* start at lower left, go to apex then upper left */
		point[0].x = _XoObjDrawLeft (w);
		point[0].y = _XoObjDrawBottom (w);
		point[1].x = _XoObjDrawRight (w);
		point[1].y = _XoObjDrawTop (w) +
			(_XoObjDrawBottom(w) - _XoObjDrawTop(w))/2;
		point[2].x = _XoObjDrawLeft (w);
		point[2].y = _XoObjDrawTop (w);
		break;
	case XoUP:
		/* start at lower left, go to apex, then lower right */
		point[0].x = _XoObjDrawLeft (w);
		point[0].y = _XoObjDrawBottom (w);
		point[1].x = _XoObjDrawLeft(w) +
			(_XoObjDrawRight(w) - _XoObjDrawLeft(w))/2;
		point[1].y = _XoObjDrawTop (w);
		point[2].x = _XoObjDrawRight (w);
		point[2].y = _XoObjDrawBottom (w);
		break;
	case XoDOWN:
		/* start at upper left, go to apex, then upper right */
		point[0].x = _XoObjDrawLeft (w);
		point[0].y = _XoObjDrawTop (w);
		point[1].x = _XoObjDrawLeft (w) +
			(_XoObjDrawRight(w) - _XoObjDrawLeft(w))/2;
		point[1].y = _XoObjDrawBottom (w);
		point[2].x = _XoObjDrawRight (w);
		point[2].y = _XoObjDrawTop (w);
		break;
	}
	point[3] = point[0];
	DBUG_PRINT ("arrow", ("Drawing %s: (%d,%d)(%d,%d)(%d,%d)(%d,%d)",
			      XoGetStringFromPointing (w->obj_arrow.direction),
			      point[0].x, point[0].y,
			      point[1].x, point[1].y,
			      point[2].x, point[2].y,
			      point[3].x, point[3].y));
	XDrawLines (XtDisplayOfObject (gw), XtWindowOfObject (gw),
		       w->obj_arrow.gc,
		       point, 4, CoordModeOrigin);
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * ObjDraw class methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * ObjArrow class methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Private functions
 *----------------------------------------------------------------------
 */

static void
CalcGC (gw)
	Widget	gw;
{
	XoObjArrowWidget	w = (XoObjArrowWidget) gw;
	XtGCMask	mask;
	XGCValues       values;		/* filled in for gc values */

	if (w->obj_arrow.gc)
		XtReleaseGC (gw, w->obj_arrow.gc);
	values.foreground = w->obj_draw.fg;
	values.line_width = w->rectangle.border_width;
	mask = GCForeground|GCLineWidth;
	w->obj_arrow.gc = XtGetGC (gw, mask, &values);
}
