/*
 * Obj2dBorder.c,v 2.0 1992/04/23 02:51:32 ware Exp
 * Obj2dBorder.c,v
 * Revision 2.0  1992/04/23  02:51:32  ware
 * First public release.
 *
 * Revision 1.5  1992/03/05  01:13:29  ware
 * Cast width and height to (unsigned) when calling XDrawRectangle()
 *
 * Revision 1.4  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.3  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.2  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.1  1991/11/30  15:51:19  pete
 * Cleaned up some nitpicky compile time warnings.
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/Obj2dBP.h>
#include <X11/Xo/dbug.h>

#include <X11/Xo/Obj2dBRec.h>

XoProto (static void, GetGC, (Widget gw));

/*
 *----------------------------------------------------------------------
 * RectObj Class Methods
 *----------------------------------------------------------------------
 */

/*
 * Redraw the border.
 */

static void
Redisplay (gw, event, region)
	Widget          gw;		/* should be subclassof ObjDraw */
	XEvent         *event;		/* the exposure event */
	Region          region;		/* the uncovered region */
{
	XoObj2dBorderWidget w = (XoObj2dBorderWidget) gw;
	int             offset;

	DBUG_ENTER ("Obj2dBorder.Redisplay");
	if (w->obj_draw.no_draw)
	{
		DBUG_VOID_RETURN;
	}
	if (w->obj_border.clear_inverted)
	{
		if (w->obj_border.inverted)
		{
			DBUG_VOID_RETURN;
		}
	}
	else if (!w->obj_border.inverted)
	{
		DBUG_VOID_RETURN;
	}

	DBUG_PRINT ("inverted", ("Drawing rectangle on %s",
				 XoName (XtParent (gw))));
	offset = w->obj_2d_border.part_width / 2;
	XDrawRectangle (XtDisplayOfObject (gw), XtWindowOfObject (gw),
			w->obj_2d_border.gc,
			(int) (w->rectangle.x + offset),
			(int) (w->rectangle.y + offset),
			(unsigned int) w->rectangle.width - w->obj_2d_border.part_width,
			(unsigned int) w->rectangle.height - w->obj_2d_border.part_width);
	DBUG_VOID_RETURN;
}

/*
 * Initialize an instance of this object.  We allocate the GC needed
 * to draw the border.
 */
static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* args passed to create */
	Cardinal       *num_args;	/* number of arguments */
{
	XoObj2dBorderWidget w = (XoObj2dBorderWidget) new;
	Cardinal        cnt;
	Arg             args[10];

	if (XtClass (new) == xoObj2dBorderWidgetClass)
		_XoInheritedGet (XtParent (new), new);
	cnt = 0;
	if (w->obj_border.clear_inverted)
		XtSetArg (args[cnt], XtNborderWidth, 0);
	else
		XtSetArg (args[cnt], XtNborderWidth, w->obj_2d_border.part_width);
	++cnt;
	XtSetValues (XtParent (new), args, cnt);
	w->obj_2d_border.gc = NULL;
	GetGC (new);
}


static void
Destroy (gw)
	Widget          gw;
{
	XoObj2dBorderWidget w = (XoObj2dBorderWidget) gw;

	if (w->obj_2d_border.gc)
		XtReleaseGC ((Widget) w, w->obj_2d_border.gc);
}

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoObj2dBorderWidget w = (XoObj2dBorderWidget) new;
	XoObj2dBorderWidget cur = (XoObj2dBorderWidget) current;
	Boolean         redisplay = False;
	Boolean         calc_gc = False;
	Arg             localargs[10];
	Cardinal        cnt;

	DBUG_ENTER ("Obj2dBorder.SetValues");

	if (w->rectangle.border_width != cur->rectangle.border_width)
	{
		calc_gc = True;
	}
	if (w->obj_2d_border.part_width != cur->obj_2d_border.part_width)
		calc_gc = True;
	if (w->obj_border.inverted != cur->obj_border.inverted)
	{
		DBUG_PRINT ("inverted", ("%s inverted = %s",
		      XoName (new), w->obj_border.inverted ? "yes" : "no"));
		calc_gc = True;
		redisplay = True;
	}
	if (w->obj_border.clear_inverted != cur->obj_border.clear_inverted)
	{
		redisplay = True;
		cnt = 0;
		if (w->obj_border.clear_inverted)
		{
			XtSetArg (localargs[cnt], XtNborderWidth, 0);
		}
		else
		{
			XtSetArg (localargs[cnt], XtNborderWidth,
				  cur->obj_2d_border.part_width);
		}
		++cnt;
		XtSetValues (XtParent (new), localargs, cnt);
	}
	if (calc_gc)
	{
		GetGC (new);
		if (XtIsRealized (new) && !redisplay)
			_XoObjRedraw (new, (XEvent *) NULL, (Region) NULL);
		else
			redisplay = True;
	}
	DBUG_RETURN (redisplay);
}

/*
 *----------------------------------------------------------------------
 * Private procedures
 *----------------------------------------------------------------------
 */


static void
GetGC (gw)
	Widget          gw;		/* the widget to calc gc for */
{
	XoObj2dBorderWidget w = (XoObj2dBorderWidget) gw;
	XGCValues       values;		/* filled in for gc values */

	DBUG_ENTER ("Obj2dBorder.GetGC");
	if (w->obj_2d_border.gc)
		XtReleaseGC ((Widget) w, w->obj_2d_border.gc);
	values.foreground = w->obj_draw.fg;
	values.line_width = w->obj_2d_border.part_width;
	DBUG_PRINT ("inverted", ("Setting to drawing width of %s to %d",
				 XoName (XtParent (gw)), values.line_width));
	w->obj_2d_border.gc = XtGetGC ((Widget) w, GCForeground | GCLineWidth,
				       &values);
	DBUG_VOID_RETURN;
}
