/*
 * List.c,v 2.1 1992/07/11 20:00:01 pete Exp
 * List.c,v
 * Revision 2.1  1992/07/11  20:00:01  pete
 * Removed composite extension since it is now initialized in ConsBase.c.
 *
 * Revision 2.0  1992/04/23  02:51:05  ware
 * First public release.
 *
 * Revision 1.1  1992/04/23  02:20:20  ware
 * Part of the Xo widget set
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/ListP.h>
#include <X11/Xo/dbug.h>
 
#include <X11/Xo/ListRec.h>

XoProto (static void, SetWidget, (Widget gw, int flag));

/*
 *----------------------------------------------------------------------
 * Core Class Methods
 *----------------------------------------------------------------------
 */

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{
	XoListWidget   w = (XoListWidget) new;

	w->list.current = NULL;
}

static void
Destroy (gw)
	Widget          gw;
{
	/*XoListWidget w = (XoListWidget) gw;*/

}

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoListWidget w = (XoListWidget) new;
	XoListWidget cur = (XoListWidget) current;
	Boolean         redisplay = False;

	if (w->list.current != cur->list.current)
	{
		SetWidget (cur->list.current, False);
		SetWidget (w->list.current, True);
	}
	return redisplay;
}

static void
Redisplay (gw, event, region)
	Widget          gw;		/* should be subclassof ObjDraw */
	XEvent         *event;		/* the exposure event */
	Region          region;		/* the uncovered region */
{
	XoListWidget w = (XoListWidget) gw;
	int		i;

	DBUG_ENTER ("List.Redisplay");
	for (i = 0; i < w->composite.num_children; i++)
	{
		if (XtIsRectObj (w->composite.children[i]) &&
		    XtIsManaged (w->composite.children[i]))
		{
			_XoObjRedraw (w->composite.children[i], event, region);
		}
	}
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * Composite class methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Constraint class methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * ConsBase class methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Column class methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * List class methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Actions
 *----------------------------------------------------------------------
 */

static void
Notify (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoListWidget  w = (XoListWidget) gw;

	DBUG_ENTER ("List.Notify");
	if (w->list.current)
		XtCallCallbackList (gw, w->list.callbacks,
				    (XtPointer) w->list.which);
	DBUG_VOID_RETURN;
}

static void
CurrentClear (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoListWidget  w = (XoListWidget) gw;

	DBUG_ENTER ("List.CurrentClear");
	SetWidget (w->list.current, False);
	w->list.current = NULL;
	DBUG_VOID_RETURN;
}

static void
CurrentLocate (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoListWidget  w = (XoListWidget) gw;
	Position	x, y;
	int		i;
	Boolean		found = False;

	DBUG_ENTER ("List.CurrentLocate");
	XoEventLocation (event, &x, &y);
	for (i = 0; i < w->composite.num_children; i++)
	{
		if (!XtIsManaged (w->composite.children[i]))
			continue;
		if (_XoObjPointIn (w->composite.children[i], x, y))
		{
			found = True;
			break;
		}
	}
	if (found)
		w->list.which = i;
	else
		w->list.which = -1;
	DBUG_VOID_RETURN;
}

static void
CurrentSet (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoListWidget  w = (XoListWidget) gw;

	DBUG_ENTER ("List.CurrentSet");
	if (w->list.which < 0)
		DBUG_VOID_RETURN;
	if (w->list.which >= w->composite.num_children)
	{
		_XoWarn (gw, "BadValue", "No such widget",
			 "The currently selected widget is incorrectly set");
		DBUG_VOID_RETURN;
	}
	w->list.current = w->composite.children[w->list.which];
	SetWidget (w->list.current, True);
}


/*
 *----------------------------------------------------------------------
 * Private functions
 *----------------------------------------------------------------------
 */

static void
SetWidget (gw, flag)
	Widget		gw;
	int		flag;
{
	DBUG_ENTER ("List.SetWidget");
	DBUG_PRINT ("listtest", ("Setting %s to %d", XoName (gw), flag));
		
#ifdef notdef
	Arg		args[10];
	Cardinal	cnt;

	if (!gw)
		return;
	XtSetArg (args[cnt], XtNset, flag); ++cnt;
	XtSetValues (gw, args, cnt);
#endif
	DBUG_VOID_RETURN;
}

