c Program to generate test data for vrend.
c The program generates an aarray of size n, which is filled with two
c overlapping spherical density distributions.
c
c the size parameters in DATACOM2.COPY should be set to 32.
c
	parameter (n = 32)
	dimension v(n,n,n)
	cy = n/2	
	cz = n/2
	cx1 = n/4 + .5
	cx2 = 3*n/4 + .5
c
	do 100 i=1,n
	do 100 j=1,n
	do 100 k=1,n
	   dx1 = (cx1 - i)**2
	   dx2 = (cx2 - i)**2
	   dy  = (cy - j)**2
	   dz  = (cz - k)**2
	   v(i,j,k) = 1/sqrt(dx1+dy+dz) + 1/sqrt(dx2+dy+dz)
100	continue
c
	open (10, file='test.data', form='unformatted')
	write(10) v
	close (10) 
	end
