/**********************************************************************/
/*                                                                    */
/* menu.c : menu routines                                             */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          *
/**********************************************************************/
#include <stdio.h>
#include <gl/gl.h>
#include <fmclient.h>
#include <string.h>
#define IRIS4D 1
#include "geo.h"
#include "walk.h"
#include "auto.h"

char *MFILENAME = "anim.log";

extern Matrix viewmat;
extern void DoHelp();
extern void DoExit();
extern void DrawScene();
extern void Save_Screen_Image();
extern void Show_Image();
extern char *meshfilename;

/**********************************************************************/
/* Set name of log file for storing movements (not used)              */
/**********************************************************************/
static void SetLogFilename()
{
  char *tmp = "                                                       ";
  
  fprintf(stdout,"Log file name [anim.log]:");
  scanf("%s\n", tmp);
  if (strcmp(tmp,"") == 0) 
    MFILENAME = "anim.log";
  else
    MFILENAME = tmp;
}

/**********************************************************************/
/* Read orientations from file. If not currenly logging */
/**********************************************************************/
static void AnimateLog()
{
  if (Option.log == DOLOG) {
    printf("Cannot read movements from file while logging\n");
    printf("Stop logging first !\n");
  } else {
    Option.mode = PREORIENT;
    ClearOrientLog();
    movefilename = MFILENAME;
    moves_logged = ReadMoves(movefilename, &Autoview);
    if (Option.debug) 
      printf("\nRunning %d moves read for orientation...Please wait\n", 
	     moves_logged);
    Update_Scene();
    ClearOrientLog();
    Option.log = NOLOG;
  }
}


/**********************************************************************/
/* Start to log movements, record absolute position */ 
/**********************************************************************/
static void StartLogMode()
{
  AbsMovement *amove;
  AbsMovement tmp;
  Matrix invobjmat;
  Matrix invvwmat;
  Matrix curmat;

  /* Find and record absolute position if not already started logging */
  if (Option.log == NOLOG) {
    amove = CreateAbsMove(Viewer);
    getmatrix(curmat);
    if (invert_matrix(objmat,invobjmat) &&
	invert_matrix(viewmat,invvwmat)) {
      pushmatrix(); {
	loadmatrix(invvwmat);
	multmatrix(invobjmat);
	multmatrix(viewmat);
	getmatrix(curmat);
      } popmatrix();
      amove->lookFrom = vtransform(Viewer.lookFrom, curmat);
      amove->lookAt = vtransform(Viewer.lookAt, curmat);
      amove->lookUp = vtransform(Viewer.lookUp, curmat); 
      LogAbsMove(amove, &Autoview, MOVEABS);
    } else {
      fprintf(stderr,"StartLogMode(): non-invertible object matrix !\n");
      exit(1);
    }
  }
  Option.log = DOLOG;
}


/**********************************************************************/
/* Stop logging movements. */
/**********************************************************************/
static void StopLogMode() 
{ Option.log == NOLOG; }


/**********************************************************************/
/* Only because only 1 arg per menu function */
/**********************************************************************/
void MenuWriteMoves()
{
  movefilename = MFILENAME;
  WriteMoves(movefilename, Autoview, moves_logged);
  Option.log = NOLOG;
}


/**********************************************************************/
/* Set whether logging or not */
/**********************************************************************/
static void SetDebugMode()
{  Option.debug = !(Option.debug); }


char image_filename[200];
int img_number = 1;
/**********************************************************************/
/* Store current image in window */
/**********************************************************************/
static void StoreImageRGB()
{
  long xsize, ysize;

  /* Store image same size as window size */
  getsize(&xsize, &ysize);
  sprintf(image_filename, "");
  sprintf(image_filename, "%s.%s.%d", meshfilename, "RGB", img_number++);
  printf("\tStoring RGB image to %s. Please wait...\n", image_filename);
  Save_Screen_Image(xsize, ysize, 3, image_filename);
  printf("\tStorage finished\n");
}

static void StoreImageGrey()
{
  long xsize, ysize;

  /* Store image same size as window size */
  getsize(&xsize, &ysize);
  sprintf(image_filename, "");
  sprintf(image_filename, "%s.%s.%d", meshfilename, "GREY", img_number++);
  printf("\tStoring gray-scale image to %s. Please wait...\n", image_filename);
  Save_Screen_Image(xsize, ysize, 1, image_filename);
  printf("\tStorage finished\n");
}

/**********************************************************************/
/* Store current image in window */
/**********************************************************************/
static void DisplayImage()
{
  Show_Image(image_filename);
}

/**********************************************************************/
/* Set shade model */
/**********************************************************************/
static void SetShadeModel()
{ 
  if (Option.shademodel == FLAT)
    Option.shademodel = GOURAUD;
  else if (Option.shademodel == GOURAUD)
    Option.shademodel = FLAT;
  Draw_Scene();                    /* Redraw scene on change of model */
}

/**********************************************************************/
/* Set shading primitive */
/**********************************************************************/
static void SetShadePrim()
{ 
  if (Option.shadeprim == SHADE_QUAD) {
    Option.shadeprim = SHADE_TRIA;
  } else if (Option.shadeprim == SHADE_TRIA) {
    Option.shadeprim = NO_SHADE;
  } else if (Option.shadeprim == NO_SHADE) {
    Option.shadeprim = SHADE_QUAD;
    gconfig();
  }
  Draw_Scene();           /* Redraw scene on change of shading mode */
}

/**********************************************************************/
/* Set usage of Abuffer (not used) */
/**********************************************************************/
/* static void SetUseAccBuf()
   { 
   printf("** Abuffer option not installed **\n");
   System.UseAccBuf = !System.UseAccBuf; 
   }
*/

double dscale = 0.1;
/**********************************************************************/
/* Change intensity scale                                             */
/**********************************************************************/
void IncScale() 
{ 
  Option.RGBscale += dscale; 
  Draw_Scene();                
}
void DecScale() 
{ 
  Option.RGBscale -= dscale; 
  Draw_Scene();                
}

/**********************************************************************/
/* Build image menu                                                   */
/**********************************************************************/
static int BuildImageMenu()
{
  static long menu = -1;

  if (menu != -1) freepup(menu);
  menu = defpup("Image %t");

  addtopup(menu, "Store Colour Image %f", StoreImageRGB);
  addtopup(menu, "Store Grey-Scale Image %f", StoreImageGrey);
  addtopup(menu, "Display Image %f", DisplayImage);
  return menu;
}

/**********************************************************************/
/* Build scene menu                                                   */
/**********************************************************************/
static int BuildSceneMenu()
{
  static long menu = -1;

  if (menu != -1) freepup(menu);
  menu = defpup("Scene %t");
  
  addtopup(menu, "Store Image %m", BuildImageMenu());

  if (Option.shademodel == GOURAUD)
    addtopup(menu, "Flat shade %f", SetShadeModel);
  else if (Option.shademodel == FLAT)
    addtopup(menu, "Gouraud shade %f", SetShadeModel);

  if (Option.shadeprim == SHADE_QUAD)
    addtopup(menu, "Triangle patches %f", SetShadePrim);
  else if (Option.shadeprim == SHADE_TRIA)
    addtopup(menu, "Mesh for patches %f", SetShadePrim);
  else if (Option.shadeprim == NO_SHADE)
    addtopup(menu, "Quadrelateral patches %f", SetShadePrim);
  
  addtopup(menu, "Increase scale %f", IncScale);
  addtopup(menu, "Decrease scale %f", DecScale);

  return menu;
}


/**********************************************************************/
/* Build log menu */
/**********************************************************************/
static int BuildLogMenu()
{
  static long menu = -1;

  if (menu != -1) freepup(menu);
  menu = defpup("Logs %t");

  if (Option.log == DOLOG)
    addtopup(menu, "Stop log %f", StopLogMode);
  else if (Option.log == NOLOG)
    addtopup(menu, "Start log %f", StartLogMode);
  addtopup(menu, "Store log %f", MenuWriteMoves);
  addtopup(menu, "Animate log %f", AnimateLog); 
  /* addtopup(menu, "Set logfilename %f", SetLogFilename);  */

  return menu;
}

/**********************************************************************/
/* Build main menu */
/**********************************************************************/
void BuildMainMenu()
{
  char str[200];

  if (Menu != -1) freepup(Menu);
  sprintf(str,"%s %%t", ProgName);
  Menu = defpup(str);

  addtopup(Menu, "Help %f", DoHelp);
  if (Option.debug == NODEBUG)
    addtopup(Menu, "Debug %f", SetDebugMode);
  else if (Option.debug == DEBUG)
    addtopup(Menu, "No debug %f", SetDebugMode);
  addtopup(Menu, "Scene %m", BuildSceneMenu());
  addtopup(Menu, "Logs %m", BuildLogMenu());
}
