/**********************************************************************/
/*                                                                    */
/* ray.h : Types for ray tracing                                      */
/*                                                                    */
/* Parts modified from Optik v(1.2e) (C) 1987 John Amanatides &       */
/* Andrew Woo                                                         */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef RAY_HH
#define RAY_HH

#if IRS
#define MIN_DISTANCE (5e-5)
#define double float
#else
#define MIN_DISTANCE (1e-5)
#endif

#define maxlevel 5;                 /* maximum ray tree depth         */
#define minweight .01;              /* minimum ray weight             */
#define rayeps 1e-7;                /* roundoff error tolerance       */

/* types of anti-aliasing */
#define ADAPTIVE	1            /* adaptive sampling             */
#define SUPER		2            /* super sampling                */

typedef struct {        /* Ray data                                   */
  long	rayID;		/* for stats/etc                              */
  Vector origin;	/* origin of ray                              */
  Vector dir;		/* direction of ray (unit vector)             */
  double visible;	/* visibility                                 */
  int generation;	/* how many times ray has bounced around      */
  int shadow;		/* set to TRUE if it is a shadow (form factor) ray */
  Transmit *transmissivity;/* allow for absorption by air, materials  */
} Ray;

typedef struct {        /* Ray intersection data                     */
  Objectt *obj;		/* object that is visible                    */
  Polygon *poly;        /* polygon that is visible                   */
  Mesh *mesh;           /* mesh that is visible                      */
  double distance;	/* the distance to the intersection          */
  Vector intersect;	/* intersection point                        */
  Vector texture;	/* texture coordinate                        */
  Vector normal;	/* the surface normal at the intersection    */
} HitData;

typedef struct {     /* Ray statistics                                */
  long currentRayID; /* Current ray id                                */
  long numRays;      /* Total number of rays shot                     */
  long intRay;       /* Number of ray intersections                   */
  long intRayID;     /* Number of ray intersections with grid         */
  long rayCone;      /* Number of ray intersections with cones        */
  long intCone;      /* Number of ray intersections with cones        */
  long rayCube;      /* Number of ray intersections with cubes        */
  long intCube;      /* Number of ray intersections with cubes        */
  long raySphere;    /* Number of ray intersections with spheres      */
  long intSphere;    /* Number of ray intersections with spheres      */
  long rayCylinder;  /* Number of ray intersections with cylinders    */
  long intCylinder;  /* Number of ray intersections with cylinders    */
  long rayMesh;      /* Number of ray intersections with meshes       */
  long rayPoly;      /* Number of ray tests with polygons             */
  long intPoly;      /* Number of ray intersections with polygons     */
  long rayBox;       /* Number of rays shot at bounding volumes       */
  long intBox;       /* Number of rays hit bounding volumes           */
} RayStats_Type;

/**********************************************************************/
/* Prototypes                                                         */
/**********************************************************************/
extern int RayBox();                /* bounding box */
extern int BoxEnter();
extern int BoxNormal();
extern void RayCube();              /* cube */
extern RaySphere();                 /* sphere */
extern void RayCylinder();          /* cyl */
extern void RayCone();              /* cone */
extern void get_uv();               
extern int Inside_Polygon();
extern BoundingBoxType BoxPoly();
extern int RayPoly_Edge();
extern int RayPlane();              /* plane */
extern int RayPolygon();            /* poly */
#ifndef RAY_HITC
extern void Store_HitInter();       /* hits */
extern void Reset_Hit();
extern Store_HitNorm();
#endif /* RAY_HITC */

#endif /* RAY_H */
