/**********************************************************************/
/* rad.h                                                              */
/*                                                                    */
/* Radiosity structures                                               */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef RAD_H
#define RAD_H

#define kBackgroundItem 0xffffff  /* Background colour for item buffer*/
#ifndef RAND_MAX                  /* Random float generator           */
#define RAND_MAX 32767
#endif 
#define RandomFloat ((float) (rand()) / (float)RAND_MAX)

/* Interpolation types */
#define INTERP_VTX_FROM_PATCH 0   /* Patches to vertices             */
#define INTERP_VTX_FROM_VTX 1     /* Vertices to vertices            */

#define RAD_THRESHOLD  (0.001)/* Stopping threshold                  */
#define RAD_ITERATIONS (100)  /* Stopping # of iterations            */

typedef struct {              /* Camera                              */
  Vector lookfrom;            /* Position looking from               */
  Vector lookat;              /* Position looking at                 */
  Vector lookup;              /* Direction up                        */
  int fovx, fovy;             /* Field of view in x,y                */
  double near, far;           /* Near / far clipping planes          */
  short xRes, yRes;           /* Resolution of viewing plane         */
  unsigned long *buffer;      /* Buffer for item buffering           */
  double bank;                /* Bank angle                          */
} Camera;

typedef struct Elist {        /* List of elements for calc. ffs       */
  Polygon *element;           /* Potential receiver element           */
  struct Elist *next;         /* Next element in list                 */
  double ff;                  /* form factor for element              */
  double vtx_ff[MAX_PATCH_VTX]; /* form factor for element vertices   */
  int is_receiver;            /* Is a receiver for current source     */
  int is_subdivided;          /* Has been subdivided in current iter. */
} Elist;

typedef struct {              /* Radiosity parameters                 */
  int log;                    /* Log reading of objects               */
  int objcount;               /* Number of objects read               */
  int meshcount;              /* Number of meshes read                */
  int polycount;              /* Number of polygons per mesh          */
  int totpoly;                /* Total number of polygons read        */
  int totmesh;                /* Total number of meshes read          */
  int num_objects;            /* Total number of objects read         */
  int num_textures;           /* Total number of textures read        */

  int num_elements;           /* Current number of elements in scene  */
  int num_receivers;          /* Number of receivers for cur. source  */
  Elist *elements;            /* Current set of elements in scene     */
  Elist *eltail;

  double threshold;           /* convergence threshold 
				 (fraction of total emitted energy)   */
  int max_iterations;         /* Maximum number of allowed iterations */
  int forming_links;          /* if TRUE, Forming patch linkages.     */
  double intensityScale;      /* Used to scale intensity for display  */
  short hemicubeRes;          /* Hemicube resolution                  */
  int writerad;               /* Output radiosity solution            */
  double worldSize;           /* Bounding sphere radius of the world  */
  BoundingBoxType worldbox;   /* Bounding box of the world            */

  Camera displayView;         /* View to examine PR with              */
  double totalEnergy;         /* Total emitted energy; used for 
				 convergence checking                 */
  double totalEnergyLeft;     /* Total energy left in scene at iter.  */
  double totalArea;           /* Total area in the scene              */
  Spectra ptotalArea;         /* Summed p * are for all patches       */
  Spectra ambient_term;       /* Ambient term (for display only !)    */
} RadParams;

typedef struct {              /* Hemicube                             */
  Camera view;                /* Viewing parameters                   */
  double *topFactors;         /* Form factors for top plane           */
  double *sideFactors;        /* Form factors for side planes         */
  int buffersize;             /* Size of item buffer                  */
} Hemicube;

#endif /* RAD_H */


