/*LINTLIBRARY*/

/*  @(#)nulldev.c 1.3 92/04/16
 *
 *  Popi device driver for a null device.
 *  written by Stephen Frede, Softway Pty Ltd.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include "popi.h"

/*  These are the exportable routines used by the popi program.
 *
 *  disp_init(argc, argv)    - called from main at the start.
 *  disp_finish()            - called from main prior to exit.
 *  disp_imgstart(w,h,c,l)   - called prior to drawing an image.
 *  disp_imgend()            - called after drawing an image.
 *  disp_putline(l,y,w,c)    - to draw an image scanline triple.
 *  disp_getchar()           - to get the next character typed.
 *  disp_prompt()            - display popi prompt and clear input buffer.
 *  disp_error(errtype)      - display error message.
 *  disp_percentdone(n)      - display percentage value of conversion.
 *  disp_resize(w,h)         - resize popi image window (width, height).
 *  disp_colormap(n,r,g,b)   - load new colormap.
 */

/*ARGSUSED*/
void
disp_init(argc,argv)           /* called from main at the atart. */
int argc;
char *argv[];
{
}


void
disp_finish()                  /* called from main prior to exit. */
{
}


/* Called prior to drawing an image. */

void
disp_imgstart(width, height, ncolors, len)
int width, height, ncolors, len ;
{
}


void
disp_imgend()                  /* called after drawing an image. */
{
}


void
disp_putline(lines, y, width, ncolors)    /* draw image scanline y. */
pixel_t **lines;
int y, width, ncolors;
{
}


int
disp_getchar()                 /* get next user typed character. */
{
    return(getchar());
}


int
disp_prompt()                  /* display popi prompt. */
{
    static char	prompt[] = "-> ";

    PRINTF(prompt);
    return sizeof prompt - 1;
}


void
disp_error(errtype, pos)            /* display error message. */
int	errtype,
	pos;
{
    extern int  errno;
    extern char *sys_errlist[];

    if (errtype & ERR_PARSE)
    {
        int     i;
 
        for (i=1; i < pos; ++i)
            PUTC('-', stderr);
        PUTC('^', stderr);
        PUTC('\n', stderr);
    }
 
    FPRINTF(stderr, "%s\n", ErrBuf);
    /* we assume errno hasn't been reset by the preceding output */
    if (errtype & ERR_SYS)
        FPRINTF(stderr, "\t(%s)\n", sys_errlist[errno]);
}

void
disp_percentdone(percent)
int	percent;
{
    static int	lastpercent = 100;

    if (!Verbose)
	return;
    if (percent == 100)
    {
	printf("\r    \n");
	return;
    }
    if (percent != lastpercent && percent % 5 == 0)
    {
	printf("\r%2d%% ", percent);
	fflush(stdout);
	lastpercent = percent;
    }
}


void
disp_resize(width, height)    /* Resize popi image window. */
int width, height ;
{
}


void
disp_colormap(n, red, green, blue)      /* Load new colormap. */
int n ;
unsigned char *red, *green, *blue ;
{
}
