/*ScianEvents.h
  Eric Pepke
  Stuff for events
*/

/*Supplementary keys*/
#define KUPARROW	256
#define KDOWNARROW	257
#define KLEFTARROW	258
#define KRIGHTARROW	259
#define K_UPARROW	256
#define K_DOWNARROW	257
#define K_LEFTARROW	258
#define K_RIGHTARROW	259
#define K_SAVESCREEN	260

#define CLICK2TIME (HZ * 3 / 4)         /*Ticks between a double click */
#define CLICK2DIST 5                    /*Pixels between a double click*/
#define MAXMOVETIME (HZ / 10)		/*Maximum moving time allowed*/
#define MINROTTIME 0.20		/*Minimum rotation time*/

extern ObjPtr dropObject;		/*Object to drop in window*/
extern ObjPtr dropSource;		/*Source for the dropping*/
extern int dropX, dropY;		/*Global coordinates of dropX and y*/
extern Bool interactiveMoving;		/*true iff moving interactively*/
extern Bool contextHelp;		/*True iff context sensitive help*/
extern long inputWindow;		/*Current input window*/
extern int NTSCOn;			/*True iff NTSC is on*/

typedef void (*TaskType)();
extern int globalEventFlags;
extern FILE *curScript;

#ifdef PROTO
void QueueDevices(void);
void UnqueueDevices(void);
void MainLoop(void);
void DoQuit(void);
Bool OneEvent(Bool);
void SetNTSC(void);
void Set60(void);
void LongOperation(void);
void DoTask(TaskType);
void DoUniqueTask(TaskType);
void SetContextSensitiveHelp(void);
void InitEvents(void);
void KillEvents(void);
void DeferMessage(ObjPtr, int);
void FlushKeystrokes(void);
Bool AltDown(void);
#else
void QueueDevices();
void UnqueueDevices();
void MainLoop();
void DoQuit();
Bool OneEvent();
void SetNTSC();
void Set60();
void LongOperation();
void DoTask();
void DoUniqueTask();
void SetContextSensitiveHelp();
void InitEvents();
void KillEvents();
void DeferMessage();
void FlushKeystrokes();
Bool AltDown();
#endif

#define MINCONSTRAINT	2		/*Number of pixels minimum for constraint*/

/*Event flags*/
#define F_DOUBLECLICK	1		/*Click is potentially a double click*/
#define F_SHIFTDOWN	2		/*Shift key is held down*/
#define F_OPTIONDOWN	4		/*Option key is down*/
#define F_COMMANDDOWN	8		/*Command key is down*/
#define T_PRESS		0x1000		/*Press tool*/
#define T_ROTATE	0x2000		/*Rotate tool*/
#define T_HELP		0x3000		/*Context sensitive help*/
#define TOOLBITS	0xF000		/*Bits for the tool*/
#define TOOL(f)		((f) & TOOLBITS)/*Macro to get tool*/
