/*rots.c
  Eric Pepke

  Emits a script segment containing a series of rotations about an axis 
  and snaps to standard output

  Usage:
    rots axis step nSteps
	axis is the axis about which to rotate (x, y, or z)
  Example:
    rots x 0.5 30 > rot30

  puts 30 rotations by 0.5 degree around the x axis with snaps into rot30
*/

#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
{
    double step;
    int nSteps;
    int k;
    if (argc != 4)
    {
        fprintf(stderr, "usage: %s axis step nSteps\n", argv[0]);
	exit(-1);
    }
    if (1 != sscanf(argv[2], "%lg", &step))
    {
        fprintf(stderr, "usage: %s axis step nSteps\n", argv[0]);
	exit(-1);
    }
    if (1 != sscanf(argv[3], "%d", &nSteps))
    {
        fprintf(stderr, "usage: %s axis step nSteps\n", argv[0]);
	exit(-1);
    }
    for (k = 1; k <= nSteps; ++k)
    {
	printf("rotate %c %lg\n", argv[1][0], step);
	printf("snap\n");
    }
}
