/*machine.h
  Eric Pepke
  May 29, 1991

  Defines some machine-specific stuff
*/

#ifndef _H_L_MACHINE
#define _H_L_MACHINE

/*Names of libraries*/
#define LIBMALLOC	"malloc"	/*Faster MALLOC library*/
#define LIBHDF		"df"		/*NCSA HDF library*/

/*Supported machine types*/
#define IRIS4D          1               /*Silicon Graphics IRIS 4D*/
#define RS6000          2               /*IBM RS-6000*/
#define CRAYYMP		3		/*Cray Y/MP (computation only)*/
#define CONVEX		4		/*Convex*/

/*Attempt to guess the machine type based on built-in processor directives*/
#ifdef sgi
#define MACHINE         IRIS4D          /*4D cpp defines sgi*/
#else
#ifdef __sgi
#define MACHINE		IRIS4D		/*-ansi cpp defines sgi*/
#else
#define MACHINE         RS6000          /*Must be a 6000*/
#endif
#endif

/*If this machine cannot be guessed, put in a #define MACHINE here*/

/*Depending on the machine, define (or don't) the following flags:
        GL4D            GL library as defined on the IRIS4D is present
        FMATH           math routines have float as well as double versions
	MATHF		math routines have float with f at end
        FONTS4D         fonts as defined on the IRIS4D are present
        CURSORS4D       cursors as defined on the IRIS4D are present
	MENUS4D		menus are defined as on the IRIS4D
	WINDOWS4D	windows are defined as on the IRIS4D
        IRISNTSC        NTSC functions as defined on the IRIS4D are present
        IRIS            the machine is some kind of IRIS, 4D or not
        PROTO           use ANSI C prototypes (never been tested without)
        DIRENT          Directory is struct dirent else it is struct direct
	FORTRAN_	FORTRAN routines need an underscore after the name
	SOCKETS		sockets are available and are to be used
	STDLIB		stdlib.h is present
	INTERWINDRAG	can drag between windows
	WINNOCLOSE	never actually close windows, just hide 'em	
	GETPWNAM	use getpwnam call to determine ~name
	MENUSFROM0	menus items are defined starting from 0 instead of 1 	
	NOHIDEFRAME	cannot hide window frames
	GRAPHICS	version has graphics at all
	INTERACTIVE	version has interactive functions at all
	TERMIO		machine has terminal IO, needed for some recorders
	SELNEWWINDOWS	select new windows when they are created
	BIGFONTSOK	big bit-mapped fonts are OK
	GETGDESCAFTER	must do all "getgdesc" after config, bug in IBM GL
	NEEDSGAMMA	machine doesn't do gamma correction, needs it.
	IBMORTHO	ortho and ortho2, funny for IBM
	MAKEOBJ		use makeobj and callobj for speedup
	DONTCLIP	don't try to clip windows to draw minimum possible
	CHANGECURSOR	change cursor when it moves from window to window

			The following variables are set by ScianPreInstall
			in machine.*.h
	HDFDEF		HDF library is defined
	HDF31		HDF version 3.1 or earlier is present
        MALLOCH         there is a malloc.h available and we're using the lib
	FORTRAN		we want to compile with FORTRAN
*/

#if MACHINE == IRIS4D

#define GL4D
#define MATHF
#define FONTS4D
#define CURSORS4D
#define IRISNTSC
#define IRIS
#define PROTO
#define SOCKETS
#define FORTRAN_
#define STDLIB
#define INTERWINDRAG
#define GETPWNAM
#define MENUS4D
#define WINDOWS4D
#define GRAPHICS
#define INTERACTIVE
#define TERMIO
#define BIGFONTSOK
#define MAKEOBJ

#else
#if MACHINE == RS6000

#define GL4D
#define PROTO
#define GETPWNAM
#define NOHIDEFRAME
#define INTERWINDRAG
#define MENUS4D
#define WINDOWS4D
#define GRAPHICS
#define INTERACTIVE
#define TERMIO
#define STDLIB
#define SELNEWWINDOWS
#define GETGDESCAFTER
#define NEEDSGAMMA
#define IBMORTHO
#define MAKEOBJ
#define DONTCLIP
#define SOCKETS

/* Insert a #define MENUSFROM0 for version 3.1.5 */

#undef _ANSI_C_SOURCE			/*Gotta do this; I don't know why.*/
#define DIRENT

#else
#if MACHINE == CONVEX

#define PROTO
#define FORTRAN_
#define MATHF
#define SOCKETS
#define STDLIB
#define COMPONLY

#else

Hey!  No machine is defined!
#endif
#endif
#endif

#endif

/*Include stuff for FORTRAN*/
#include "machine.fortran.h"

/*Include stuff for hdf library*/
#include "machine.hdf.h"

/*Include stuff for malloc library*/
#include "machine.malloc.h"

/*Release version.  Don't change this.*/
#if 1
#define RELEASE
#endif
