/*ScianTemplates.c
  Template routines for SciAn controls
  Maintained by tl command
  Eric Pepke
  August 10, 1992
*/

#include "Scian.h"
#include "ScianIDs.h"
#include "ScianTypes.h"
#include "ScianControls.h"
#include "ScianButtons.h"
#include "ScianSliders.h"
#include "ScianTextBoxes.h"
#include "ScianTitleBoxes.h"
#include "ScianTemplates.h"
#include "ScianTemplateLib.h"
#include "ScianPerspec.h"
#include "ScianColors.h"
#include "ScianWindows.h"
#include "ScianObjFunctions.h"
#include "ScianStyle.h"
#include "ScianScales.h"
#include "ScianTrackControls.h"

#ifdef PROTO
Bool GetTemplateBounds(TemplatePtr template, char *name, int *l, int *r, int *b, int *t)
#else
Bool GetTemplateBounds(template, name, l, r, b, t)
TemplatePtr template;
char *name;
int *l, *r, *b, *t;
#endif
/*Gets the bounds of the given template, returns true if there.*/
{
    int k;
    for (k = 0; ; ++k)
    {
	if (template[k] . name[0] == 0)
	{
	    /*End of the line*/
	    return false;
	}
	if (0 == strcmp2(template[k] . name, name))
	{
	    /*Bingo*/
	    *l = template[k] . l;
	    *r = template[k] . r;
	    *b = template[k] . b;
	    *t = template[k] . t;
	    return true;
	}
    }
}

#ifdef PROTO
ObjPtr TemplateSlider(TemplatePtr template, char *name, int style)
#else
ObjPtr TemplateSlider(template, name, style)
TemplatePtr template;
char *name;
int style;
#endif
/*Returns a templated slider*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewSlider(l, r, b, t, style, name);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateSlider", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateTrackControl(TemplatePtr template, char *name, real low, real high)
#else
ObjPtr TemplateTrackControl(template, name, low, high)
TemplatePtr template;
char *name;
real low, high;
#endif
/*Returns a templated track control*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewTrackControl(l, r, b, t, name, low, high);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateTrackControl", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateScale(TemplatePtr template, char *name, int orientation, Bool adj)
#else
ObjPtr TemplateScale(template, name, orientation, adj)
TemplatePtr template;
char *name;
int orientation;
Bool adj;
#endif
/*Returns a templated scale*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewScale(l, r, b, t, orientation, adj, name);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateSlider", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateIconButton(TemplatePtr template, char *name, int whichIcon, int hiColor, int style)
#else
ObjPtr TemplateIconButton(template, name, whichIcon, hiColor, style)
TemplatePtr template;
char *name;
int whichIcon, hiColor, style;
#endif
/*Returns a templated icon button*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewIconButton(l, r, b, t, whichIcon, hiColor, name, style);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateIconButton", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateIconCorral(TemplatePtr template, char *name, ObjPtr superClass, int flags)
#else
ObjPtr TemplateIconCorral(template, name, superClass, flags)
TemplatePtr template;
char *name;
int flags;
ObjPtr superClass;
#endif
/*Returns a templated icon corral*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
    if (flags & BARRIGHT)
    {
	r += BARWIDTH + CORRALBARBORDER;
    }
    if (flags & BARLEFT)
    {
	l -= BARWIDTH + CORRALBARBORDER;
    }

    if (flags & BARBOTTOM)
    {
	b -= BARWIDTH + CORRALBARBORDER;
    }

	retVal = NewIconCorral(superClass, l, r, b, t, flags);
	SetVar(retVal, NAME, NewString(name));
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateIconCorral", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateControlField(TemplatePtr template, char *name, int flags)
#else
ObjPtr TemplateControlField(template, name, flags)
TemplatePtr template;
char *name;
int flags;
#endif
/*Returns a templated icon corral*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
    if (flags & BARRIGHT)
    {
	r += BARWIDTH + CORRALBARBORDER;
    }
    if (flags & BARLEFT)
    {
	l -= BARWIDTH + CORRALBARBORDER;
    }

    if (flags & BARBOTTOM)
    {
	b -= BARWIDTH + CORRALBARBORDER;
    }

	retVal = NewControlField(l, r, b, t, name, flags);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateControlField", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateColorWheel(TemplatePtr template, char *name)
#else
ObjPtr TemplateColorWheel(template, name)
TemplatePtr template;
char *name;
#endif
/*Returns a templated color wheel*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewColorWheel(l, r, b, t, name);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateSlider", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateTitleBox(TemplatePtr template, char *name)
#else
ObjPtr TemplateTitleBox(template, name)
TemplatePtr template;
char *name;
#endif
/*Returns a templated title box*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewTitleBox(l, r, b, t, name);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateTitleBox", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateColorBar(TemplatePtr template, char *name)
#else
ObjPtr TemplateColorBar(template, name)
TemplatePtr template;
char *name;
#endif
/*Returns a templated color bar*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewColorBar(l, r, b, t, name);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateColorBar", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateRadioButton(TemplatePtr template, char *name)
#else
ObjPtr TemplateRadioButton(template, name)
TemplatePtr template;
char *name;
#endif
/*Returns a templated radio button*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewRadioButton(l, r, b, t, name);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateRadioButton", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateButton(TemplatePtr template, char *name)
#else
ObjPtr TemplateButton(template, name)
TemplatePtr template;
char *name;
#endif
/*Returns a templated button*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewButton(l, r, b, t, name);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateButton", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplatePerspecControl(TemplatePtr template, char *name)
#else
ObjPtr TemplatePerspecControl(template, name)
TemplatePtr template;
char *name;
#endif
/*Returns a templated PerspecControl*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewPerspecControl(l, r, b, t, name);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplatePerspecControl", errStr);
    }
}


#ifdef PROTO
ObjPtr TemplateCheckBox(TemplatePtr template, char *name, Bool value)
#else
ObjPtr TemplateCheckBox(template, name, value)
TemplatePtr template;
char *name;
Bool value;
#endif
/*Returns a templated check box*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewCheckBox(l, r, b, t, name, value);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateCheckBox", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplateTextBox(TemplatePtr template, char *name, int style, char *value)
#else
ObjPtr TemplateTextBox(template, name, style, value)
TemplatePtr template;
char *name;
int style;
char *value;
#endif
/*Returns a templated text box*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewTextBox(l, r, b, t, style, name, value);
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateTextBox", errStr);
    }
}

#ifdef PROTO
ObjPtr TemplatePanel(TemplatePtr template, char *name)
#else
ObjPtr TemplatePanel(template, name)
TemplatePtr template;
char *name;
#endif
/*Returns a templated panel*/
{
    ObjPtr retVal;
    int l, r, b, t;
    if (GetTemplateBounds(template, name, &l, &r, &b, &t))
    {
	retVal = NewPanel(greyPanelClass, l, r, b, t);
	SetVar(retVal, NAME, NewString(name));
	return retVal;
    }
    else
    {
	char errStr[256];
	sprintf(errStr, "Template '%s' not found", name);
	ReportError("TemplateTextBox", errStr);
    }
}

