/*ScianSciences.h
  Eric Pepke
  Septembet 27, 1992
  Includes for ScianSciences.c
*/

#define N_ATOMS		103		/*Number of atoms in internal table.*/

/*Information on an atom*/
typedef struct
    {
	char *shortName;		/*Periodic table name*/
	char *longName;			/*Spelled-out name*/
	real weight;			/*Weight of most common isotope*/
	real radius;			/*Radius for display purposes*/
	short color[3];			/*Components of base color*/
    } AtomInfo;

extern AtomInfo atomInfo[N_ATOMS];

#ifdef PROTO
void InitSciences(void);
void KillSciences(void);
int AtomNameToNumber(char *name);
ObjPtr UnitsNameToPalette(char *name, real min, real max);
#else
void InitSciences();
void KillSciences();
int AtomNameToNumber();
ObjPtr UnitsNameToPalette();
#endif
