/* ScianNames.h John R. Murray
 */

typedef struct	NameNodeStr {
		char			*stringPtr;
		NameTyp			id;
		struct NameNodeStr	*left;
		struct NameNodeStr	*right;
} NameNode,*NameNodePtr;

#define		MAXIDNUM	5000
#define		MAXPREDEFIDNUM	1000



typedef struct {
	char	*str;		/* string name of something */
	ThingPtr	thing;	/* id number of the same something */
} IDArrayStruct;

extern IDArrayStruct IDArray[MAXIDNUM];

extern NameNodePtr IDsTree;

/* GetID returns the ID of an object */
#define GetID(obj)	(((ObjPtr) obj)->name)

#ifdef PROTO
void		InitNames();
void		KillNames();
NameTyp		GetNewID();
NameNodePtr	NewNameNode(char *str,NameTyp id);
NameTyp		NameToID(char namestr[]);
char		*IDToName(NameTyp id);
void		DefineName(char *namestr,NameTyp id);
void		PrintNameNode(NameNodePtr node, int depth);
void		PrintNameTree();
void		PrintIDTree();
ThingPtr	FindIDValue(NameTyp id);
NameTyp		GetInternalID(char *);
char		*GetInternalString(NameTyp);
void		DefineID(char *, NameTyp);
#else
void		InitNames();
void		KillNames();
NameTyp		GetNewID();
NameNodePtr	NewNameNode();
NameTyp		NameToID();
char		*IDToName();
void		DefineName();
void		PrintNameNode();
void		PrintNameTree();
void		PrintIDTree();
ThingPtr	FindIDValue();
NameTyp		GetInternalID();
char		*GetInternalString();
void		DefineId();
#endif
