/*Object IDs and variable IDs
  Eric Pepke
  March 28, 1990
*/

/*Variables and methods*/
#define DATA		1	/*Data variable*/
#define DATAFORM	2	/*Data form*/
#define COLORS		3	/*Colors for field dots*/
#define DIMENSIONS	4	/*Dimensions of something*/
#define BOUNDS		5	/*Bounds of an object*/
#define ICONLOC		6	/*Icon location*/
#define REPOBJ		7	/*Object this object represents*/
#define NAME		8	/*Name of this object*/
#define DRAW		9	/*Draw yerself.*/
#define CONTENTS	10	/*Contents of this panel, corral, or whatever*/
#define WHICHICON	11	/*The number of the icon*/
#define PRESS		12	/*Press method*/
#define SELECTED	13	/*Selected variable*/
#define HIGHLIGHTED	14	/*Highlighted variable.*/
#define BASECOLOR	15	/*Base color of an object*/
#define MARKERTYPE	16	/*Type of marker*/
#define CHANGEDVALUE	17	/*Changedvalue method for buttons & controls*/
#define ADDCONTROLS	18	/*Gives visualization a chance to add controls*/
#define DRAWCONTENTS	19	/*Method to draw the contents of something*/
#define PRESSCONTENTS	20	/*Method to press in the contents of something*/
#define BACKGROUND	21	/*Background color of something*/
#define STYLE		22      /*Style of anything*/
#define LOVALUE         23      /*Lower limit of slider value*/
#define HIVALUE         24      /*Upper limit of slider value*/
#define STEPVALUE       25      /*Step value of slider*/
#define VALUE           26      /*Current value of slider*/
#define GETVAL		27	/*Get value method*/
#define DEFAULTICON	28	/*Default icon for a visualization object*/
#define NEWCTLWINDOW	29	/*New control window method*/
#define SPECVAL		30	/*Specular value*/
#define SHINVAL		31	/*Shininess value*/
#define CLEANUP		32	/*Clean up object message*/
#define CLOSE		33	/*Close (a window) message*/
#define STICKINESS	34	/*Stickiness of an object, flag bits*/
#define RESHAPE		35	/*Reshape a window*/
#define INITIALIZE	36	/*Initialize an object*/
#define HILITESEGMENT	37	/*Variable containing hilite segment*/
#define SURFACE		38	/*Variable containing a surface*/
#define DELTAS		39	/*Variable containing deltas in a field*/
#define ISTRANSPARENT	40	/*True iff surface is transparent*/
#define BRIGHTNESS	41	/*Brightness of a surface*/
#define ISOVAL		42	/*Isosurface value*/
#define ROLL		43	/*Roll of the eye*/
#define PITCH		44	/*Pitch of the eye*/
#define KEYDOWN		45	/*KeyDown method*/
#define AIRSPEED	46	/*Airspeed of eye*/
#define CONNECT		47	/*Connect something, maybe a recorder*/
#define DISCONNECT	48	/*Disconnect something*/
#define PORTNUMBER	49	/*Port number for a recorder*/
#define PREPARETORECORD	50	/*Prepare to record some frames*/
#define STOPRECORDING	51	/*Stop recording*/
#define SNAPONEFRAME	52	/*Snap a single frame shot*/
#define SELECT		53	/*Select an icon or something*/
#define CONTROLICON	54	/*Icon for controlling stuff*/
#define PANEL		55	/*Var holding control panel for an icon or space*/
#define PANELCONTENTS	56	/*Contents for a control panel for an icon*/
#define REPICON		57	/*Icon that represents this field*/
#define MULTIDRAW	58	/*True iff all classes of objects are to be drawn*/
#define BBFLAGS		59	/*Flags for bounding box*/
#define WHICHFLAG	60	/*Which flag a check box controls*/
#define SETVAL		61	/*Method to set a value*/
#define LILSTEP		62	/*Little step in a scale*/
#define BIGSTEP		63	/*Big step in a scale*/
#define FORMAT		64	/*Format of numbers*/
#define TRACKNOT	65	/*Variable to inhibit tracking*/
#define SPACE		66	/*Space to which this object belongs*/
#define PARENT		67	/*Parent of object in window*/
#define PORTIONSHOWN	68	/*Portion of a scrolled window that's shown*/
#define TIMESTEPS	69	/*Array of time steps*/
#define TIMEDATA	70	/*Data corresponding to the time steps*/
#define OWNERWINDOW	71	/*Window that owns this space*/
#define WAKEUP		72	/*Wakeup call*/
#define CLOCK		73	/*The clock in this space*/
#define TIME		74	/*Time of this space*/
#define TIMEBOUNDS	75	/*Bounds of the time, array[2] of real*/
#define FOCUSDIST	76	/*Distance of focus, relates FOCUSPOINT to EYEPOSN*/
#define SMOOTH		77	/*Boolean value of smoothness of curve*/
#define ALIGNMENT	78	/*Alignment*/
#define WHICHDIALOG	79	/*Identifier for dialog*/
#define DTIME		80	/*Delta time per second*/
#define MARKTIME	81	/*Mark time in a time-dependant field*/
#define ANCHOR		82	/*Anchor for a slider*/
#define COLOR		83	/*Color of a something*/
#define BUTTONPRESSED	84	/*Method when a button has been pressed*/
#define CURRENT		85	/*Current object in window clicked*/
#define KEYSTRING	86	/*String so far in a slider from keypress*/
#define READOUT		87	/*Slider readout*/
#define MAKEDRAWN	88	/*Method to make something drawn if not already*/
#define MARK		89	/*Mark method*/
#define INHIBITDRAWING	90	/*Flag to inhibit drawing.  DrawObject looks at it*/
#define XSCALE		91	/*Scale along X dimension*/
#define YSCALE		92	/*Scale along Y dimension*/
#define ZSCALE		93	/*Scale along Z dimension*/
#define DOUBLECLICK	94	/*Double click method*/
#define NCELLS		95	/*Number of cells in a switch*/
#define OUTCELL		96	/*Which cell is the output*/
#define ISTRANSLUCENT	97	/*True iff translucent*/
#define OTHERSWITCH	98	/*Another switch*/
#define MINMAX		99	/*Minimum and maximum*/
#define CPALETTE	100	/*Variable to store palette*/
#define COLOROBJ	101	/*Object waiting to be color*/
#define DROPOBJECTS	102	/*Method to drop some objects*/
#define DROPINCONTENTS	103	/*Drop in contents of something like a corral*/
#define HSCROLL		104	/*Horizontal scroll bar*/
#define VSCROLL		105	/*Vertical scroll bar*/
#define RECALCSCROLL	106	/*Recalculate scroll bars*/
#define LABEL		107	/*Label of button*/
#define HANDLEMISSING	108	/*Integer specifying how to handle missing data*/
#define EDGES		109	/*Edges for an unstructured grid*/
#define CELLS		110	/*Cells for an unstructured grid*/
#define TEXTFONT	111	/*Text font*/
#define TEXTSIZE	112	/*Text size, as if you couldn't guess.*/
#define LINESPACE	113	/*Line spacing for text boxes*/
#define SPACES		114	/*List of spaces*/
#define FRONTPANEL	115	/*Front space panel*/
#define BACKPANEL	116	/*Back space panel*/
#define BINDTOSPACE	117	/*Method to bind a controller to a space*/
#define OBSERVER	118	/*Observer of this space.  That's YOU!*/
#define ERRORLIST	119	/*List of errors waiting*/
#define ERRORNUMBER	120	/*Currently displayed error*/
#define ALWAYSCHANGE	121	/*Always do a changed value*/
#define RANGE		122	/*Range of a whatever*/
#define FILETYPE	123	/*File type*/
#define MARQUEE		124	/*Marquee around icons*/
#define LOCATION	125	/*Location of an object, usually in 3-space*/
#define LIGHTS		126	/*Individual lights in a lights class*/
#define CYCLECLOCK	127	/*Clock cycle predicate*/
#define PANELHIDDEN	128	/*True iff the panel is hidden*/
#define ENCLOSELOW	129	/*True iff enclosing low values in isosurface*/
#define FINDOBJECT	130	/*Finds an object*/
#define INTERPOLATEP	131	/*True iff we're to interpolate*/
#define PREFVIS		132	/*Preferred visualization*/
#define TRANSLUCENTCNT	133	/*Translucent control, if already made*/
#define TRANSPARENTCNT	134	/*Transparent control, if already made*/
#define COLORSHADING	135	/*Color shading value*/
#define LIGHTSHADING	136	/*Light shading value*/
#define PICCOLORED	137	/*Dummy dependency variable for picture colored*/
#define MAINDATASET	138	/*The main data set which sets up the time*/
#define SETMAINDATASET	139	/*Method for a vis object to accept a main field*/
#define UNSTRUCTURED	140	/*Boolean that tells if a data form is unstructured*/
#define VIEWBYWHAT	141	/*View by icon or name*/
#define VIRTUALBOUNDS	142	/*Virtual bounds of a scrolled field*/
#define BGNSEL		143	/* index of first char of text selection */
#define ENDSEL		144	/* index of last char of text selection */
#define SELECTALL	145	/* method to select all text in a textbox */
#define CALLBACK	146	/* callback method for a dialog */
#define	FILELIST	147	/* list of file lists by type */
#define SELECTOR	148	/* selector bits for file types */
#define PATH		149	/* path name to file window's directory */
#define OKMETHOD	150	/* method to call when OK button pressed */
#define SHOWFILES	151	/* method to show files in a corral */
#define REGISTERFIELD	152	/*Method to register a field*/
#define HIDDEN		153	/*True iff a visualization object is hidden*/
#define ICONGREYED	154	/*Greyed (an icon*)*/
#define WHICHPREF	155	/*Which preference a control deals with*/
#define HIGHLIGHTCOLOR	156	/*Color of a highlight*/
#define HIDE		157	/*Hide method*/
#define CLONE		158	/*Clone yourself method*/
#define ACTIVATED	159	/*Object is activated*/
#define ICONEXTRADRAW	160	/*Method to draw extra stuff for an icon*/
#define RENDERER	161	/*Renderer for a space*/
#define RENDERTYPE	162	/*Type of renderer*/
#define FILTERTYPE	163	/*Type of image filter*/
#define ENTERMETHOD	164	/*Method to call when enter key pressed in object*/
#define DELETEICON	165	/*Message to send an icon to delete its repobj before deleting*/
#define CORRAL		166	/*Corral assoc with a space or window*/
#define TIMEPERPIXEL	167	/*Time per pixel on screen in time control*/
#define PREFIXDATASETS	168	/*Method to have a vis object prefix datasets it uses*/
#define DATASETS	169	/*Datasets of a clock*/
#define DISPLAYSTEP	170	/*Step for displaying time*/
#define DISPLAYTICS	171	/*Number of tics per time step*/
#define AUTOSCROLL	172	/*Autoscroll message*/
#define REINIT		173	/*Reinitialize controller*/
#define TIMEFORMAT	174	/*Format of time associated with dataset*/
#define CUT		175	/*Method to cut from something*/
#define COPY		176	/*Method to copy from something*/
#define PASTE		177	/*Method to paste on something*/
#define LASTINTERP	178	/*Last value of interpolate*/
#define VALUESET	179	/*Predicate, means new set value has been registered once*/
#define ROTATING	180	/*Of a space, predicate saying we are rotating*/
#define MOVING		181	/*Of a space, true iff moving*/
#define HELPSTRING	182	/*The help string of an object for the default help system*/ 
#define BORDERTYPE	183	/*Type of border, on a panel*/
#define HELPCONTENTS	184	/*Array of contents for help*/
#define HELPRADIO	185	/*Radio button in a help dialog*/
#define TYPESTRING	186	/*type string*/
#define	MAKE1HELPSTRING	187	/*Makes the help string*/
#define SINGLECORRAL	188	/*True iff corral can only hold one icon*/
#define REGISTERCOMP	189	/*Method to register a component*/
#define XFIELD		190	/*Field for X of trace*/
#define YFIELD		191	/*Field for Y of trace*/
#define ZFIELD		192	/*Field for Z of trace*/
#define XTOPDIM		193	/*Topological dimension for X*/
#define YTOPDIM		194	/*Topological dimension for Y*/
#define ZTOPDIM		195	/*Topological dimension for Z*/
#define ORTHO		196	/*Predicate to see if a perspec control is ortho*/
#define NCOMPONENTS	197	/*Number of components for a vector dataset or null for scalar*/
#define INDICES		198	/*Indices for array*/
#define COLORCELLS	199	/*What kind of color cells*/
#define PARENTS		200	/*List of parents*/
#define SLIDER		201	/*A slider a text box represents*/
#define CHANGED		202	/*Dummy variable used sometimes to indicate data changed*/
#define PALETTESET	203	/*Set if a color palette is set in a dataset*/
#define COLORWHEEL	204	/*Color control*/
#define KEPTPALETTE	205	/*The kept palette*/
#define COLORBAR	206	/*A color bar with which a slider or colorwheel works*/
#define BUTTON		207	/*A random button*/
#define TEMPPALETTE	208	/*Temporary palette*/
#define INITVALUE	209	/*Initial value of something*/
#define KEEPBUTTON	210	/*Keep button*/
#define REVERTBUTTON	211	/*Revert button*/
#define PALETTEFUNC	212	/*Palette function*/
#define FULLCOMPBUTTONS	213	/*List of buttons to activate or deactivate on full and components*/
#define COMPBUTTONS	214	/*List of buttons to activate or deactivate on components*/
#define EDITMODE	215	/*The edit mode, esp. of a color bar*/
#define TOOLGROUP	216	/*Group of tools*/
#define FUNCTIONBOX	217	/*Box that controls a function*/
#define FREEFORMBUTTON	218	/*Button for free form tool*/
#define HALTHELP	219	/*Halt help search predicate*/
#define REGISTERFORM	220	/*Register data form*/
#define JUSTCOLORCHANGE	221	/*Just the colors changed*/
#define GETTOPDIM	222	/*Get topological dimension*/
#define INITFILTER	223	/*Initialize filter*/
#define GETSPATIALDIM	224	/*Get spatial dimension*/
#define GETDATASETINFO	225	/*Get dataset info*/
#define SETRGBMESSAGE	226	/*Message to set to RGB*/
#define DIMVALUES	227	/*Array of dimension values*/
#define GETFORMDIMS	228	/*Method to get form dimensions*/
#define TOPDOWN		229	/*Predicate of field, true iff top down*/
#define VIEWTYPE	230	/*Type of view*/
#define OLDVALUE	231	/*Old value for something*/
#define INTERPCOLORS	232	/*True iff interp colors*/
#define DRAWSURFACE	233	/*Draw the surface*/
#define DRAWWIREFRAME	234	/*Draw the wire frame*/
#define VECTORFACTOR	235	/*Factor for vector displays*/
#define SHAFTWIDTH	236	/*Width of an arrow's shaft*/
#define	HEADWIDTH	237	/*Width of an arrow's head*/
#define HEADLENGTH	238	/*Length of an arrow's head*/
#define GETLONGNAME	239	/*Returns long name of an object*/
#define WHICHVAR	240	/*Which var for numeric text*/
#define TEMPLATEP	241	/*True iff the object is a template*/
#define ALLFILTERS	242	/*Method to get all filters*/
#define DISPOSE		243	/*Dispose method for a window*/
#define READALL		244	/*Read all of a file method*/
#define OLDREAD		245	/*Old style file read routine, NOT method style*/
#define EXTENSION	246	/*Extension for file reader*/
#define TIMEDDATASETS	247	/*Timed datasets flags*/
#define OUTOFBOUNDS	248	/*Integer specifying how to handle out of bounds*/
#define TICDENSITY	249	/*Tic mark density*/
#define TICLENGTH	250	/*Length of tic marks*/
#define SPHERESUBDIV	251	/*Sphere subdivisions*/
#define FRUSTUMSUBDIV	252	/*Subdivision of a frustum*/
#define CAPENDSP	253	/*Cap ends predicate*/
#define ETERNALPART	254	/*Eternal portion of a picture*/
#define YOURENOTCURRENT	255	/*You're not current anymore message*/
#define HIDEPANEL	256	/*True iff window has panel to hide*/
#define MINMAJORSTEP	257	/*Number of pixels minimum in major step*/
#define COLORBYFIELD	258	/*Color text by field*/
#define SHOWOVERUNDER	259	/*Show over and under*/
#define SHOWMISSING	260	/*Show missing data*/
#define NUMBERSONLY	261	/*Numbers only*/
#define SHOWMINORTICS	262	/*Show minor tics*/
#define ROTAXIS		263	/*Axis of rotation*/
#define ROTSPEED	264	/*Rotation speed*/
#define FLYING		265	/*F L Y I N ---- G predicate*/
#define DEFORMOBJ	266	/*Deformation object*/
#define DEFCONSTANT	267	/*Constant deformation*/
#define DEFOFFSET	268	/*Offset of deformation*/
#define DEFFACTOR	269	/*Factor of deformation*/
#define DEFORMSWITCH	270	/*Value of deform switch*/
#define REVERSESENSE	271	/*Reverse order of contour*/
#define COLORMODEL	272	/*Color model for palette*/
#define FILENAME	273	/*Name of file where a dataset was found*/
#define DIRECTORY	274	/*Name of directory where a dataset was found*/
#define SAVECPANEL	275	/*Method to save the controls of an object*/
#define SAVEALLCONTROLS	276	/*Method to save all the indiv. controls of an object*/
#define CONTOURLINES	277	/*List of contour lines in an object*/
#define STARTVALUE	278	/*Starting value of a contour line*/
#define PICDEFORMED	279	/*Dummy variable for deformed picture*/
#define CONNECTIONSTATE 280	/*State of a connection*/
#define INHIBITLOGGING	281	/*Control predicate, inhibits logging*/
#define TIMEOUT		282	/*Timeout message*/
#define CURCMD		283	/*Current command being assembled*/
#define CMDPROCNAME	284	/*Command process name*/
#define ALLPROCESSES	285	/*All processes in a connection*/
#define OBJPANEL	286	/*A space's object panel*/
#define TOOLPANEL	287	/*A space's tool panel*/
#define ESCAPED		288	/*Connection is escaped*/
#define EDITTOOL	289	/*Edit tool*/
#define LINEWIDTH	290	/*Line width*/
#define STARTPOINT	291	/*Starting location (for a line)*/
#define ENDPOINT	292	/*Ending location (for a line)*/
#define ARROWHEAD	293	/*Of a line, are there arrowheads at each side*/
#define READER		294	/* reader for a file */
#define FIELD		295	/* control field */
#define OPEN		296	/* open message */
#define CLASSID		297	/*ID of a class*/
#define ONEONLY		298	/*One only predicate, of a controller in a space*/
#define TWOSIDEDSURFACE	299	/*Two-sided surface predicate*/
#define CONTROLLERP	300	/*True iff it's a controller*/
#define SHOWGRID	301	/*True iff show grid*/
#define FUNCTIONBUTTONS 302	/*List of function buttons in a window*/
#define SHOWCONTROLS	303	/*Show controls method of an object*/
#define VISUALIZE	304	/*Visualize an object*/
#define VISUALIZEAS	305	/*Visualize an object as...*/
#define MODIFY		306	/*Modify datasets*/
#define DELETE		307	/*Delete yourself from current window*/
#define SHOW		308	/*Show an object, opposite of hide*/
#define DUPLICATE	309	/*Duplicate an object*/
#define LOCALCOPY	310	/*Make local copy*/
#define PICKUP		311	/*Pick up an object*/
#define COLLECT		312	/*Collect object into a list*/
#define FORALLOBJECTS	313	/*For all objects method*/
#define APPEARANCE	314	/*Appearance of an object*/
#define BEVELED		315	/*Beveled style predicate*/
#define SHADOW		316	/*Shadow int variable*/
#define BINOCULARITY	317	/*Binocular distance*/
#define BRINGTOTOP	318	/*Bring object to top*/
#define PUSHTOBOTTOM	319	/*Push object to bottom*/
#define MOVETOBACKPANEL	320	/*Move to back panel*/
#define MOVETOFRONTPANEL 321	/*Move to front panel*/
#define CONTOURCENTER	322	/*Center value of contour*/
#define CONTOURSTEP	323	/*Step of contour*/
#define CONTOURMAX	324	/*Maximum value of contour*/
#define CONTOURDIV	325	/*Divisions of contour*/
#define CONTOURMIN	326	/*Minimum value of contour*/
#define XNAME		327	/*Name of X axis*/
#define YNAME		328	/*Name of Y axis*/
#define ZNAME		329	/*Name of Z axis*/
#define READVECTOR	330	/*Read vector data*/
#define DTIMEPER	331	/*Delta time per second*/
#define RUNSPEED	332	/*Control integer for running*/
#define RUNCONTROL	333	/*Running radio button*/
#define DTIMEUNITS	334	/*Units for delta time*/
#define DTIMEPERUNITS	335	/*Units for delta time per*/
#define SHOWPANEL 	336	/*Show a panel*/
#define CONNECTIONKIND	337	/*Kind of connection*/
#define CONNECTTOPROCESS 338	/*Connect to a process*/
#define OUTPUTQUEUE	339	/*Output queue for a connection*/
#define OWNERCONNECTION	340	/*The connection of a process*/
#define CMDPROCSOCKET	341	/*Socket for a proc*/
#define ALLOBJECTS	342	/*All objects of a proc*/
#define SOCKETID	343	/*Socket a process wants to connect*/
#define OBJECTID	344	/*ID of object*/
#define ADVERTISED	345	/*Of an object, true iff advertised*/
#define ADVERTISE	346	/*Advertise obj function*/
#define UNADVERTISE	347	/*Unadvertise obj function*/
#define OLDCONNSTATE	348	/*Old connection state*/
#define OWNERPROCESS	349	/*Process that owns this connection*/
#define READNUMBERONE	350
#define READNUMBERTWO	351
#define READNUMBERTHREE	352
#define RECEIVEEXTRA	353
#define NETWORKID	354
#define TRANSMITEXTRA	355
#define ALLADVERTISED	356	/*Advertised objects of a process*/
#define TARGETOBJECT	357	/*Target for an incoming object*/
#define TARGETVAR	358
#define NEWREMOTEOBJ	359	/*New remote object method*/
#define BOUNDSINVALID	360	/*Bounds invalid method*/
#define SHOWBOUNDS	361	/*Show bounds predicate*/
#define INNERSOFTMARGIN	362	/*Inner soft margin*/
#define OUTERSOFTMARGIN	363	/*Outer soft margin*/
#define SHOWROTGUIDES	364	/*Show rotation guides*/
#define SHOWMOTGUIDES	365	/*Show motion guides*/
#define SHOWFRAME	366	/*Of a window, show the frame*/
#define HIDEFRAME	367	/*Of a window, hide the frame*/
#define SPACEWINDOW	368	/*Space window of this window if any*/
#define SETTORGBMODE	369	/*Message to set a window to RGB mode*/
#define SETTOCMAPMODE	370	/*Message to set a window to CMAP mode*/
#define CHANGEDBOUNDS	371	/*Bounds which have been changed*/
#define BUFFER0		372	/*State of window buffer 0*/
#define BUFFER1		373	/*State of window buffer 1*/
#define WHICHBUFFER	374	/*Which buffer pointed to*/
#define SUBWINDOWS	375	/*Sub windows*/
#define SUPERWINDOW	376	/*Super window of this window*/
#define SUBWINDOWMARGIN	377	/*Margin for a subwindw*/
#define OPAQUE		378	/*Opaque predicate of object within panel*/
#define BACKNOTNEEDED	379	/*Drawing of background not needed*/
#define TEMPOBSCURED	380	/*Temporary obscuring for interaction*/
#define READNUMBERFOUR	381
#define VIEWFIELD	382	/*Field of view for an observer*/
#define VIEWCLIP	383	/*Two clipping planes for an observer*/
#define UPVECTOR	384	/*Up vector of an observer*/
#define FORWARDVECTOR	385	/*Forward vector of an observer*/
#define IMINVALID	386	/*Message for non-standard iminvalid*/
#define SPACEORIGIN	387	/*Origin in space*/
#define SPACESCALE	388	/*Scale of space*/
#define REMOTECHCOUNT	389	/*Remote change count*/
#define SIZEOBJ		390	/*Size object*/
#define SIZECONSTANT	391	/*Constant sizing*/
#define SIZEOFFSET	392	/*Offset of sizing*/
#define SIZEFACTOR	393	/*Factor of sizing*/
#define SIZESWITCH	394	/*Value of size switch*/
#define ALLCONNECTIONS	395	/*All connections an object's been sent to*/
#define NOTES		396	/*List of notes*/
#define POINTSTYLE	397	/*Style flags for points visualization*/
#define OPENMANUALLY	398	/*Message to ask to open an iconified window manually*/
#define DRAWINGTIME	399	/*Time to draw object or space*/
#define FASTSOCKET	400
#define NETWAITINGOBJECTS 401
#define DEPTHCUELINES	402	/*Use depth cueing on lines*/
#define UNITSNAME	403	/*Units name*/
#define UNITSPALETTE	404	/*Method to create a units palette*/
#define ANTIALIASLINES	405	/*Anti-alias lines*/
#define SHMSEMAPHORE	406	/*Semaphore for shared memory*/
#define SHMADDRESS	407	/*Address for shared memory*/
#define DRAWDOTS	408	/*Draw the dots of an object*/
#define DEPTHCUEDOTS	409	/*Use depth cueing on dots*/
#define ANTIALIASDOTS	410	/*Anti-alias dots*/
#define BIGGERDOTS	411	/*True iff use bigger dots*/
#define DROPPEDINSPACE	412	/*Alert an object that it's been dropped in a space*/
#define REPOBJONLY	413	/*Object only serves for its repobj*/
#define ABORTCONTROLS	414	/*Abort controls predicate*/
#define PICKPOINT	415	/*Picks a number of points in the object*/	
#define IDLECURSOR	416	/*Idles a cursor within a window*/
#define ENTERCURSOR	417	/*Message when cursor enters a window*/
#define LEAVECURSOR	418	/*Message when cursor leaves a window*/
#define RESIDUES	419	/*Residues*/
#define SHOWATOMSHOW	420	/*Show atoms how?*/
#define STUFFSELPOINT	421	/*Stuff a selection point*/
#define BEGINSTUFFING	422	/*Begin stuffing some selection points*/
#define SELECTSELPOINT	423	/*Method to select a single selection point*/
#define PORTIONSELECTED	424	/*Portion that's selected*/
#define ALLSENTLIST	425	/*List of all sent, whatever that means*/
#define HOROFFSET	426	/*Horizontal offset for text box*/
#define SNAPVARS	427	/*Variables of an object for snapshot*/
#define OLDSNAPSHOTS	428	/*Old snapshots of an undo*/
#define UNDOTYPE	429	/*Type of undo*/
#define LASTKEY		430	/*Last type of key pressed in text box*/
#define SELECTION	431	/*Selection within a complex control*/
#define RANDOMJITTER	432	/*Random jitter for points*/
#define CHANGEDSELECTION 433	/*Changed selection*/
#define SETSELECTION	434	/*Set a selection*/
#define TITLETEXT	435	/*Text box for title of window*/
#define VISASFIELD	436	/*Field of buttons for vis as*/
#define NORMALSOBJ	437	/*Normals field*/
#define WRAPPOLAR	438	/*Wrap polar*/
#define ISLEFTHANDED	439	/*True of a dataset if it has a left-handed coord sys*/
#define THESCALE	440	/* the scale associated with a control */
#define ORIENTATION	441	/* orientation of, eg, a scale [0-3] */
#define TEXTCOLOR	442	/*Color of text in a scale*/
#define STEPPIXELS	443	/* min pixels per step in a scale */
#define ROTQUAT		444	/*Rotation quaternion*/
#define MISSINGSUBST	445	/*Value to substitute for missing data*/
#define EDITPALETTE	446	/*Edit a palette*/
#define CONTROLFLAGS	447	/*Flags for the control*/
#define RANGEALERT	448	/*Message for range alert*/
#define WHICHINDEX	449	/*Which index of a control*/
#define OLDVAR		450	/*Old variable, saved by a control*/
#define DIMCHANGES	451	/*Changes to dimensions*/
#define LASTDIMCHANGED	452	/*Last value of dimension changed*/
#define CONTROLSADDED	453	/*Bool flag; controls added for this button*/
#define AUTOADJUST	454	/*Autoadjust origin and scaling to space*/
#define EXTRAAPPEARANCE	455	/*Extra appearance setting method*/
#define USESPACECOORDS	456	/*True iff use space coords on observer*/
#define CTABLE		457	/*Compression table in an array*/
#define COMPRESSDATA	458	/*Compress data on read*/
#define LASTTIME	459	/*Last time sampled*/
#define MAKEISOSURFACE	460	/*Deferred message for making isosurface*/
#define ISOLEVEL	461	/*Level of isosurface*/
#define LASTIJKVERTICES	462	/*Last level of i, j, k, vertices*/
#define NEXTIJKVERTICES	463	/*Next level of i, j, k, vertices*/
#define LASTDATA	464	/*Last data plane*/
#define NEXTDATA	465	/*Next data plane*/
#define NORMALSFROM	466	/*Integer specifying where to get normals*/
#define BRANDNAME	467	/*Brand name (of a recorder driver)*/
#define PORTDEV		468	/*Port device for a recorder*/
#define BAUDRATE	469	/*Baud rate for a recorder*/
#define CANSAVESETTINGS	470	/*True iff can save settings*/
#define REPCLASSID	471	/*Representative class for snapshot*/
#define SAVEEXTENSION	472	/*Extension for saving this object*/
#define FRAMERATE	473	/*Frame rate*/
#define ACTIVATEOBJECT	474	/*Activate this object*/
#define NCOLORS		475	/*# of colors*/
#define BEGCOLOR	476	/*Beginning color in color table for palette*/
#define COLORCOMP	477	/*Color components*/
#define COLORNAMES	478	/*Names of colors*/
#define FRAMEWIDTH	479	/*Width of video frame*/
#define FRAMEHEIGHT	480	/*Height of video frame*/
#define COLORBYSELF	481	/*Color by self*/
#define BOTHERWITHAXES	482	/*True iff bother with axes*/
#define USER1		483	/*User variable*/
#define USER2		484	/*User variable*/
#define USER3		485	/*User variable*/
#define USER4		486	/*User variable*/
#define USER5		487	/*User variable*/
#define USER6		488	/*User variable*/
#define USER7		489	/*User variable*/
#define USER8		490	/*User variable*/
#define USER9		491	/*User variable*/
#define USER10		492	/*User variable*/
#define ELEVATIONSKIP	493	/*Variables for WhisselFiles*/
#define RADIALSKIP	494
#define GATESKIP        495
#define DOREFDATASETS   496
#define DOVELDATASETS	497
#define LEFTSIDEWIDTH	498	/*Width of the left side*/
#define XSCROLLVALUE	499	/*X scroll value*/
#define YSCROLLVALUE	500	/*Y scroll value*/
#define TRACKHEIGHT	501	/*Height of a track in a track control*/
#define DRAWNAME	502	/*Draw the name portion of a track*/
#define DRAWTRACK	503	/*Draw the track portion of a track*/
#define TRACKS		504	/*Tracks within sequence*/
#define PRESSNAME	505	/*Press in the name portion*/
#define EXPANDEDP	506	/*True iff a track is expanded*/
#define SUBTRACKS	507	/*The subtracks in a track*/
#define RECORDING	508	/*Recording predicate in a sequence*/
#define INHIBITRECORDING 509	/*Inhibit recording this control*/
#define READOUT2	510	/*A second readout*/
#define DENSERBUTTON	511	/*The denser button*/
#define SPARSERBUTTON	512	/*The sparser button*/
#define SCROLLBOUNDS	513	/*Bounds for scrolling*/


