/*ScianGeometry.h
  Eric Pepke
*/

typedef union
    {
	long intVal;
	real realVal;
    } GeoItem;

typedef struct
    {
	Thing thing;		/*The thing part*/
	long nAlloc;		/*Number of items in the geometry*/
	long nWritten;		/*Index of the last item word*/
	GeoItem *items;		/*The items*/
    } Geometry, *GeoPtr;

#define GEOCHUNK	5000	/*Chunk size for geometry*/

/*Item types*/
#define IT_POLYGON	1	/*Polygon item*/

#ifdef PROTO
void InitGeometry(void);
void KillGeometry(void);
ObjPtr NewGeometry(void);
ObjPtr ConvertDatasetToPicture(ObjPtr, ObjPtr);
void AppendPolygonToGeometry(ObjPtr, long, long*);
#else
void InitGeometry();
void KillGeometry();
ObjPtr NewGeometry();
ObjPtr ConvertDatasetToPicture();
void AppendPolygonToGeometry();
#endif
