/*****************************************************************************
* 
*			  NCSA HDF Vset beta 1.0
*				March , 1990
*
* NCSA HDF Vset beta 1.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************
*  Likkai Ng 31-MAR-90 NCSA
* 
* vg.h
* Part of HDF VSet interface
*
* defines symbols and structures used in all v*.c files    
*
* NOTES:
* This include file depends on the basic HDF *.h files dfi.h and df.h.
* An 'S' in the comment means that that data field is saved in the HDF file.
*
******************************************************************************/


#include "df.h"

#define PUBLIC		
#define PRIVATE	static


/* 
* interlacing supported by the vertex-set. 
*/

#define FULL_INTERLACE	0
#define NO_INTERLACE		1

/* 
* some max lengths 
*/

#define VSFIELDMAX		20  			/* max no of fields per velt */
#define FIELDNAMELENMAX	8				/* attr name: 5 chars max */
#define VSNAMELENMAX		64				/* vs name : 64 chars max */	
#define VGNAMELENMAX		64				/* vg name : 64 chars max */	


/*
* definition of the 2 data elements of the vertex-set.
*/

typedef struct vgroup_desc     	VGROUP;
typedef struct vdata_desc			VDATA;


/*
* -----------------------------------------------------------------
* structures that are part of the VDATA structure
* -----------------------------------------------------------------
*/

typedef struct symdef_struct {
	char* name;						/* symbol name */
	int	type;						/* whether int, char, float etc */
	int	isize;					/* as stored in HDF */
	int	order;					/* order of field */
	} SYMDEF;

typedef struct write_struct	{
	int32	n;							/* S actual # fields in vertex */
	int	ivsize;					/* S size of vertex as stored in HDF */
 	char 	name[VSFIELDMAX][FIELDNAMELENMAX];
										/* S name of each field */
	int	len[VSFIELDMAX]; 		/* S length of fieldname */
	int	type[VSFIELDMAX];		/* S type */
  	int	off[VSFIELDMAX];		/* S offset of field with vertex in HDF file */
  	int 	isize[VSFIELDMAX];	/* S internal (HDF) size [incl order] */
  	int	order[VSFIELDMAX];	/* S order of field */
  	int	esize[VSFIELDMAX];	/*  external (local machine) size [incl order] */
	int	(*toIEEEfn  [VSFIELDMAX] )();
	int	(*fromIEEEfn[VSFIELDMAX] )();
  	}		 VWRITELIST;

typedef struct read_struct	{
	int	n; 						/* # fields to read */
	int	item[VSFIELDMAX]; 	/* index into vftable_struct */
	} VREADLIST;

/* 
*  ----------------------------------------------- 
        V G R O U P     definition     
*  ----------------------------------------------- 
*/

#define MAXNVELT  36				/* max no of velts in a vgroup */

struct vgroup_desc{ 
	int    otag, oref;			/* tag-ref of this vgroup */
  	DF		 *f;	 	     			/* HDF file ptr */
	int 	 nvelt; 					/* S no of velt */
	int	 tag[MAXNVELT];		/* S tag of velt */
	int	 ref[MAXNVELT];		/* S ref of velt */
 	char	 vgname[VGNAMELENMAX];/* S name of this vgroup */
	VDATA* velt[MAXNVELT];	 	/* pts to a velt if opened; or else NULL */
	};									/* VGROUP */

/*
*  ----------------------------------------------- 
*         V S U B G R O U P    definition   
*  ----------------------------------------------- 
*/

#define USYMMAX 36				/* max user-defined symbols allowed */

struct vdata_desc{ 
  	int	otag, oref; 			/* of this vdata */
  	DF		*f;	 	     			/* HDF file ptr */
  	int	access;					/* 'r' or 'w' */
 	char	vsname[VSNAMELENMAX];/* S name of this vdata */
  	int	interlace;				/* S  interlace as in file */
  	int	nvertices;				/* S  #vertices in this vdata */
	int	vpos;    				/* cur position (in terms of elements) */
	VWRITELIST	wlist;
  	VREADLIST	rlist;
	int  			nusym;
	SYMDEF 		usym[USYMMAX];
  	};  								/* VDATA */ 


/* -------------- H D F  vertex  tags  ------------------------------- */

#define VGDESCTAG  	61820		/* tag for a vgroup d*/ 
#define VSDESCTAG 	61821		/* tag for a vdata descriptor */
#define VSDATATAG 	61822		/* tag for actual vdata data */ 

/*
* Actual sizes of data types stored in HDF file, and are IEEE-defined. 
*/

#define IEEE_UNTYPEDSIZE   0
#define IEEE_CHARSIZE      1
#define IEEE_INT16SIZE     2
#define IEEE_FLOATSIZE     4

/*
* types used in defining a new field vis a call to VSfdefine
*/

#define LOCAL_NOTYPE			0
#define LOCAL_CHARTYPE  	1
#define LOCAL_INTTYPE 	 	2
#define LOCAL_FLOATTYPE		3

/*
* actual LOCAL MACHINE sizes of the above types
*/

#define LOCAL_UNTYPEDSIZE  0
#define LOCAL_CHARSIZE  	sizeof(unsigned char)
#define LOCAL_INTSIZE  		sizeof(int)
#define LOCAL_FLOATSIZE 	sizeof(float)

/* ------------------------------------------------------------------ */
/* 2 GLOBAL VARIABLES (int vjv and char sj[]) provide a simple
* debugging scheme. Debugging is turned on and off via calls to 
* setjj and setnojj. These globals and functions are found in vgp.c.
*/
extern int 		vjv; /* debugger switch */
extern char 	sjs[]; /* contains the debug/error message */
#define zj 		fprintf(stderr,"%s",sjs) 
/* ------------------------------------------------------------------ */
