#       internic2ripe - generate RIPE database objects from the InterNIC
#                       database dump files
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: internic2ripe.pl,v 2.3 1998/07/15 18:01:32 joao Exp $
#
#	$RCSfile: internic2ripe.pl,v $
#	$Revision: 2.3 $
#	$Author: joao $
#	$Date: 1998/07/15 18:01:32 $

require "getopts.pl";

require "defines.pl";
require "rconf.pl";
require "misc.pl";
require "net2net.pl";


&Getopts('t:');

if ((@ARGV) || (!$opt_t)) {
    
   print <<"EOF";

Usage: $PROGRAMNAME -t objecttype

Program converts InterNIC database dumps from (ftp://ftp.internic.net/netinfo)
to (split) RIPE database object files.

objecttype might be one of:

aut-num:

  STDIN  asn.txt
  STDOUT split RIPE database aut-num file


inetnum:

  STDIN  ip_network_dump.*
  (also uses networks.txt & network-contacts.txt.Z)

  STDOUT split RIPE database inetnum file
  STDERR split RIPE database person file

EOF
	exit(0);
}


local($conffile) = $ENV{"RIPEDBCNF"};
$conffile = $RIPEConfig{DEFCONFIG} unless $conffile;

&rconf($conffile);

local($networksfile)="networks.txt";
local($networkcontactsfile)="network-contacts.txt.Z";

local($value, $network, $netname, $firstname, $lastname, $contact, $email, $code, $day, $month);

local(%month2number)=("jan", "01",
                      "feb", "02",
                      "mar", "03",
                      "apr", "04",
                      "may", "05",
                      "jun", "06",
                      "jul", "07",
                      "aug", "08",
                      "sep", "09",
                      "sept", "09",
                      "oct", "10",
                      "nov", "11",
                      "dec", "12");

#
# standard texts
                      
local($trailer)="
*ch: ripe-dbm\@ripe.net $DATE
*so: INTERNIC\n\n";

local($conversiontext)=" is assigned by the InterNIC
*rm: and converted to RIPE database format.
*rm: please query whois.internic.net for more information.
*ch: hostmaster\@internic.net";

#
# inetnum texts

local($inremarks)="
*rm: this network ".$conversiontext;

#
# as texts

local($asremarks)="
*rm: this asnumber ".$conversiontext."\n".$trailer;

#
# person texts

local($pnremarks)="
*rm: this person object is converted from the InterNIC database
*rm: please query whois.internic.net for more information
*ch: hostmaster\@internic.net\n".$trailer;

#
# main program

&printrights(STDOUT);

if ($ATTR{$opt_t} eq "in") {

   #
   # find netnames if possible
   
   local(%netnames)=();
   
   open($networksfile, "<$networksfile");
   while (<$networksfile>) {
      
      if (/\:\s*(\d+\.\d+\.\d+\.\d+)\s*\:\s*(\S+)\s/) {
         
         $netnames{$1}=$2;         
         
      }
      
   }
   close($networksfile);
   
   #
   # find contact information and netnames, generate person objects
   
   local(@contact)=();
   local(%contacts)=();
   local(%alreadydone)=();

   open($networkcontactsfile, "uncompress -c $networkcontactsfile|");
   while (<$networkcontactsfile>) {
      
      if (/(\d+\.\d+\.\d+\.\d+)\s*[RGECD]\s+(\S\S+)\s/) {
         
         $network=$1;
         
         #
         # remember netname
         
         $netnames{$network}=$2;
         
         if (scalar(<$networkcontactsfile>)=~ /^\s*([^\,\s]+)\,\s*(\S.*)\(\s*([a-zA-Z\-]+\d*)\s*\)\s*(\S+)\s/) {
            
            #
            # remember contact info
               
            $contacts{$network}=$3;
            
            #
            # skip if already done
            
            if ($alreadydone{$3}) {

               scalar(<$networkcontactsfile>);
               scalar(<$networkcontactsfile>);

            }   
            else {   
               
               $alreadydone{$3}=1;
            
               #
               # remove spaces
               
               @contact=($1, $2, $3, $4, scalar(<$networkcontactsfile>));
               grep((s/^\s+//) && (s/\s+$//), @contact);
               ($lastname, $firstname, $nichandle, $email, $phone)=@contact; 
               
               #
               # create person object
               
               push(@output,   "*pn: ", $firstname, " ", $lastname);
               push(@output, "\n*ph: ", $phone) if ($phone);
               push(@output, "\n*em: ", $email,
                             "\n*nh: ", $nichandle, $pnremarks);
               
               scalar(<$networkcontactsfile>);
               
            }
            
            if (scalar(@output)>$MAXLISTLENGTH) {
            
               print STDERR @output;
            
               @output=();
            
            }
            
         }
         
      }
      
   }
   print STDERR @output;
   @output=();
   close(STDERR);
   close($networkcontactsfile);
   undef %alreadydone;
   
   #
   # use the stats file and generate inetnum objects
   
   while (<STDIN>) {
       
      next if (/^\-\-\-\-/);
        
      if (/\s(\d+\.\d+\.\d+\.\d+\/\d+)\s/) {
      
         ($value, $code)=&normalizerange($1, "in");
      
         next if ($code!=$O_OK);
     
         ($network)=$value=~ /^(\S+)\s/;
     
         push(@output,   "*in: ", $value);
         push(@output, "\n*na: ", $netname) if ($netname=delete($netnames{$network}));
         push(@output, "\n*ac: ", $contact,
                       "\n*tc: ", $contact) if ($contact=delete($contacts{$network}));
         
         if (scalar(<STDIN>)=~ /date\:\s+(\d+)\-([a-zA-Z]+)\-(\d+)\s/i) {
         
            $day=$1;
            $day="0".$day if ($day<10);
            ($month=$2)=~ tr/A-Z/a-z/;
         
            push(@output, $inremarks, " ", $3, $month2number{$month}, $day, $trailer);

         }
         else {
         
            push(@output, $inremarks, $trailer);
         
         }
         
         if (scalar(@output)>$MAXLISTLENGTH) {
            
            print STDOUT @output;
         
            @output=();
            
         }
      
      }
     
   }
   
   #
   # convert remaining netname entries
   
   while (($network, $netname)=each %netnames) {
      
      push(@output,   "*in: ", $network);
      push(@output, "\n*na: ", $netname) if ($netname=delete($netnames{$network}));
      push(@output, "\n*ac: ", $contact,
                    "\n*tc: ", $contact) if ($contact=delete($contacts{$network}));
      push(@output, $inremarks, $trailer);   
      
      if (scalar(@output)>$MAXLISTLENGTH) {
            
         print STDOUT @output;
         
         @output=();
            
      }
      
   }
            
   print STDOUT @output;
   
}
elsif ($ATTR{$opt_t} eq "an") {

   while (<STDIN>) {
   
      if (/^\s*(\d+)(\s*\-\s*\d+)?\s+([^\-\s]\S*)\s+\[?\s*([^\[\]\s]+)?\s*\]?\s/) {
         
         next if ($3=~ /IANA/);
         next if ($3=~ /RIPE/);
         next if ($3=~ /APNIC/);
         next if ($3=~ /CANET/);
         
         if ($2) {
            
            for ($2 .. $3) {
                
                push(@output,   "\*an: AS", $_, 
                              "\n\*aa: ", $3, 
                               "\n*ac: ", $4,
                               "\n*tc: ", $5, $asremarks); 
                
            }
            
         }
         else {
         
            push(@output,   "\*an: AS", $1, 
                          "\n\*aa: ", $3, 
                           "\n*ac: ", $4, 
                           "\n*tc: ", $5, $asremarks); 

         }
         
         if (scalar(@output)>$MAXLISTLENGTH) {
            
            print STDOUT @output;
            
            @output=();   
            
         }
         
      }
      
   }
   
   print STDOUT @output;

}      
elsif (0) { # $ATTR{$opt_t} eq "dn") {

   while (<STDIN>) {
   
      if (1) {
      
      }
      
      if (scalar(@output)>$MAXLISTLENGTH) {
            
         print STDOUT @output;
             
         @output=();   
        
      }
      
   }
   
}
else {
   print STDERR "Don't know how to build \'", $opt_t, "\' database file\n";
}            


# end of program
