/* ttymode.c - ttysave, ttyrestore */

#include <stdio.h>

#include "local.h"

extern int	errno;
extern char	*sys_errlist[];

/*------------------------------------------------------------------------
 * ttysave - get and save tty parameters and special characters
 *------------------------------------------------------------------------
 */
int
ttysave(pts)
struct ttystate	*pts;
{
	if (ioctl(0, TIOCGETP, (char *)&pts->ts_sgttyb))
		errexit("can't get tty modes: %s\n", sys_errlist[errno]);
	if (ioctl(0, TIOCGETC, (char *)&pts->ts_tchars))
		errexit("can't get tty chars: %s\n", sys_errlist[errno]);
	if (ioctl(0, TIOCGLTC, (char *)&pts->ts_ltchars))
		errexit("can't get tty chars: %s\n", sys_errlist[errno]);
}

/*------------------------------------------------------------------------
 * ttyrestore - set tty characters and special characters
 *------------------------------------------------------------------------
 */
int
ttyrestore(pts)
struct ttystate	*pts;
{
	if (ioctl(0, TIOCSETP, (char *)&pts->ts_sgttyb))
		errexit("can't set tty modes: %s\n", sys_errlist[errno]);
	if (ioctl(0, TIOCSETC, (char *)&pts->ts_tchars))
		errexit("can't set tty chars: %s\n", sys_errlist[errno]);
	if (ioctl(0, TIOCSLTC, (char *)&pts->ts_ltchars))
		errexit("can't set tty chars: %s\n", sys_errlist[errno]);
}
