/* sofsm.c */

#include <sys/types.h>

#include <stdio.h>

#include "telnet.h"
#include "tnfsm.h"

/* Special chars: */
char	t_flushc, t_intrc, t_quitc, sg_erase, sg_kill;

extern int	soputc(), scrinit(), scrgetc(), scrwrap(), unscript(),
		dcon(), suspend(), status(), sonotsup(), abort(),
		no_op();

struct fsm_trans sostab[] = {
        /* State        Input           Next State      Action  */
        /* ------       ------          -----------     ------- */
/* Data Input */
	{ KSREMOTE,	KCESCAPE,	KSLOCAL,	no_op		},
	{ KSREMOTE,	KCANY,		KSREMOTE,	soputc		},
/* Local Escape Commands */
	{ KSLOCAL,	KCSCRIPT,	KSCOLLECT,	scrinit		},
	{ KSLOCAL,	KCUNSCRIPT,	KSREMOTE,	unscript	},
	{ KSLOCAL,	KCESCAPE,	KSREMOTE,	soputc		},
	{ KSLOCAL,	KCDCON,		KSREMOTE,	dcon		},
	{ KSLOCAL,	KCSUSP,		KSREMOTE,	suspend		},
	{ KSLOCAL,	KCSTATUS,	KSREMOTE,	status		},
	{ KSLOCAL,	KCANY,		KSREMOTE,	sonotsup	},
/* Script Filename Gathering */
	{ KSCOLLECT,	KCNL,		KSREMOTE,	scrwrap		},
	{ KSCOLLECT,	KCANY,		KSCOLLECT,	scrgetc		},

	{ FSINVALID,	KCANY,		FSINVALID,	abort		},
};

#define	NTRANS	(sizeof(sostab)/sizeof(sostab[0]))

int	sostate;
u_char	sofsm[NKSTATES][NCHRS];
