#include "fs.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port

mig_external void init_fs
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_port_t rep_port)
#else
	(rep_port)
	mach_port_t rep_port;
#endif
{
#ifdef	lint
	rep_port++;
#endif
}

/* Routine file_exec */
mig_external kern_return_t file_exec
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t exec_file,
	task_t exec_task,
	args_t argv,
	mach_msg_type_number_t argvCnt,
	args_t envp,
	mach_msg_type_number_t envpCnt,
	fd_mask_t fds_active,
	fd_array_t fds,
	mach_msg_type_number_t fdsCnt,
	mach_port_t cwdir,
	mach_port_t crdir,
	int honor_setuid
)
#else
	(exec_file, exec_task, argv, argvCnt, envp, envpCnt, fds_active, fds, fdsCnt, cwdir, crdir, honor_setuid)
	file_t exec_file;
	task_t exec_task;
	args_t argv;
	mach_msg_type_number_t argvCnt;
	args_t envp;
	mach_msg_type_number_t envpCnt;
	fd_mask_t fds_active;
	fd_array_t fds;
	mach_msg_type_number_t fdsCnt;
	mach_port_t cwdir;
	mach_port_t crdir;
	int honor_setuid;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t exec_taskType;
		task_t exec_task;
		mach_msg_type_long_t argvType;
		args_t argv;
		mach_msg_type_long_t envpType;
		args_t envp;
		mach_msg_type_t fds_activeType;
		fd_mask_t fds_active;
		mach_msg_type_t fdsType;
		mach_port_t fds[64];
		mach_msg_type_t cwdirType;
		mach_port_t cwdir;
		mach_msg_type_t crdirType;
		mach_port_t crdir;
		mach_msg_type_t honor_setuidType;
		int honor_setuid;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 104;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t exec_taskType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t argvType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		FALSE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t envpType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		FALSE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t fds_activeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		2,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t fdsType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		64,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t cwdirType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t crdirType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t honor_setuidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->exec_taskType = exec_taskType;
#else	UseStaticMsgType
	InP->exec_taskType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->exec_taskType.msgt_size = 32;
	InP->exec_taskType.msgt_number = 1;
	InP->exec_taskType.msgt_inline = TRUE;
	InP->exec_taskType.msgt_longform = FALSE;
	InP->exec_taskType.msgt_deallocate = FALSE;
	InP->exec_taskType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->exec_task /* exec_task */ = /* exec_task */ exec_task;

#if	UseStaticMsgType
	InP->argvType = argvType;
#else	UseStaticMsgType
	InP->argvType.msgtl_name = MACH_MSG_TYPE_CHAR;
	InP->argvType.msgtl_size = 8;
	InP->argvType.msgtl_header.msgt_name = 0;
	InP->argvType.msgtl_header.msgt_size = 0;
	InP->argvType.msgtl_header.msgt_number = 0;
	InP->argvType.msgtl_header.msgt_inline = FALSE;
	InP->argvType.msgtl_header.msgt_longform = TRUE;
	InP->argvType.msgtl_header.msgt_deallocate = FALSE;
	InP->argvType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->argv /* argv */ = /* argv */ argv;

	InP->argvType.msgtl_number /* argvCnt */ = /* argvType.msgtl_number */ argvCnt;

#if	UseStaticMsgType
	InP->envpType = envpType;
#else	UseStaticMsgType
	InP->envpType.msgtl_name = MACH_MSG_TYPE_CHAR;
	InP->envpType.msgtl_size = 8;
	InP->envpType.msgtl_header.msgt_name = 0;
	InP->envpType.msgtl_header.msgt_size = 0;
	InP->envpType.msgtl_header.msgt_number = 0;
	InP->envpType.msgtl_header.msgt_inline = FALSE;
	InP->envpType.msgtl_header.msgt_longform = TRUE;
	InP->envpType.msgtl_header.msgt_deallocate = FALSE;
	InP->envpType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->envp /* envp */ = /* envp */ envp;

	InP->envpType.msgtl_number /* envpCnt */ = /* envpType.msgtl_number */ envpCnt;

#if	UseStaticMsgType
	InP->fds_activeType = fds_activeType;
#else	UseStaticMsgType
	InP->fds_activeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->fds_activeType.msgt_size = 32;
	InP->fds_activeType.msgt_number = 2;
	InP->fds_activeType.msgt_inline = TRUE;
	InP->fds_activeType.msgt_longform = FALSE;
	InP->fds_activeType.msgt_deallocate = FALSE;
	InP->fds_activeType.msgt_unused = 0;
#endif	UseStaticMsgType

	{ typedef struct { char data[8]; } *sp; * (sp) InP->fds_active /* fds_active */ = * (sp) /* fds_active */ fds_active; }

#if	UseStaticMsgType
	InP->fdsType = fdsType;
#else	UseStaticMsgType
	InP->fdsType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->fdsType.msgt_size = 32;
	InP->fdsType.msgt_inline = TRUE;
	InP->fdsType.msgt_longform = FALSE;
	InP->fdsType.msgt_deallocate = FALSE;
	InP->fdsType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (fdsCnt > 64)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) fds, (char *) InP->fds, 4 * fdsCnt);

	InP->fdsType.msgt_number /* fdsCnt */ = /* fdsType.msgt_number */ fdsCnt;

	msgh_size_delta = (4 * fdsCnt);
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 256);

#if	UseStaticMsgType
	InP->cwdirType = cwdirType;
#else	UseStaticMsgType
	InP->cwdirType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->cwdirType.msgt_size = 32;
	InP->cwdirType.msgt_number = 1;
	InP->cwdirType.msgt_inline = TRUE;
	InP->cwdirType.msgt_longform = FALSE;
	InP->cwdirType.msgt_deallocate = FALSE;
	InP->cwdirType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->cwdir /* cwdir */ = /* cwdir */ cwdir;

#if	UseStaticMsgType
	InP->crdirType = crdirType;
#else	UseStaticMsgType
	InP->crdirType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->crdirType.msgt_size = 32;
	InP->crdirType.msgt_number = 1;
	InP->crdirType.msgt_inline = TRUE;
	InP->crdirType.msgt_longform = FALSE;
	InP->crdirType.msgt_deallocate = FALSE;
	InP->crdirType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->crdir /* crdir */ = /* crdir */ crdir;

#if	UseStaticMsgType
	InP->honor_setuidType = honor_setuidType;
#else	UseStaticMsgType
	InP->honor_setuidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->honor_setuidType.msgt_size = 32;
	InP->honor_setuidType.msgt_number = 1;
	InP->honor_setuidType.msgt_inline = TRUE;
	InP->honor_setuidType.msgt_longform = FALSE;
	InP->honor_setuidType.msgt_deallocate = FALSE;
	InP->honor_setuidType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->honor_setuid /* honor_setuid */ = /* honor_setuid */ honor_setuid;

	InP = &Mess.In;
	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = exec_file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20000;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20100)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine file_chown */
mig_external kern_return_t file_chown
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chown_file,
	uid_t new_owner,
	gid_t new_group
)
#else
	(chown_file, new_owner, new_group)
	file_t chown_file;
	uid_t new_owner;
	gid_t new_group;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_ownerType;
		uid_t new_owner;
		char new_ownerPad[2];
		mach_msg_type_t new_groupType;
		gid_t new_group;
		char new_groupPad[2];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 40;

#if	UseStaticMsgType
	static mach_msg_type_t new_ownerType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_16,
		/* msgt_size = */		16,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t new_groupType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_16,
		/* msgt_size = */		16,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->new_ownerType = new_ownerType;
#else	UseStaticMsgType
	InP->new_ownerType.msgt_name = MACH_MSG_TYPE_INTEGER_16;
	InP->new_ownerType.msgt_size = 16;
	InP->new_ownerType.msgt_number = 1;
	InP->new_ownerType.msgt_inline = TRUE;
	InP->new_ownerType.msgt_longform = FALSE;
	InP->new_ownerType.msgt_deallocate = FALSE;
	InP->new_ownerType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->new_owner /* new_owner */ = /* new_owner */ new_owner;

#if	UseStaticMsgType
	InP->new_groupType = new_groupType;
#else	UseStaticMsgType
	InP->new_groupType.msgt_name = MACH_MSG_TYPE_INTEGER_16;
	InP->new_groupType.msgt_size = 16;
	InP->new_groupType.msgt_number = 1;
	InP->new_groupType.msgt_inline = TRUE;
	InP->new_groupType.msgt_longform = FALSE;
	InP->new_groupType.msgt_deallocate = FALSE;
	InP->new_groupType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->new_group /* new_group */ = /* new_group */ new_group;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = chown_file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20001;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20101)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine file_chauthor */
mig_external kern_return_t file_chauthor
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chauth_file,
	uid_t new_author
)
#else
	(chauth_file, new_author)
	file_t chauth_file;
	uid_t new_author;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_authorType;
		uid_t new_author;
		char new_authorPad[2];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 32;

#if	UseStaticMsgType
	static mach_msg_type_t new_authorType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_16,
		/* msgt_size = */		16,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->new_authorType = new_authorType;
#else	UseStaticMsgType
	InP->new_authorType.msgt_name = MACH_MSG_TYPE_INTEGER_16;
	InP->new_authorType.msgt_size = 16;
	InP->new_authorType.msgt_number = 1;
	InP->new_authorType.msgt_inline = TRUE;
	InP->new_authorType.msgt_longform = FALSE;
	InP->new_authorType.msgt_deallocate = FALSE;
	InP->new_authorType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->new_author /* new_author */ = /* new_author */ new_author;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = chauth_file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20002;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20102)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine file_chmod */
mig_external kern_return_t file_chmod
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chmod_file,
	mode_t new_mode
)
#else
	(chmod_file, new_mode)
	file_t chmod_file;
	mode_t new_mode;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_modeType;
		mode_t new_mode;
		char new_modePad[2];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 32;

#if	UseStaticMsgType
	static mach_msg_type_t new_modeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_16,
		/* msgt_size = */		16,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->new_modeType = new_modeType;
#else	UseStaticMsgType
	InP->new_modeType.msgt_name = MACH_MSG_TYPE_INTEGER_16;
	InP->new_modeType.msgt_size = 16;
	InP->new_modeType.msgt_number = 1;
	InP->new_modeType.msgt_inline = TRUE;
	InP->new_modeType.msgt_longform = FALSE;
	InP->new_modeType.msgt_deallocate = FALSE;
	InP->new_modeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->new_mode /* new_mode */ = /* new_mode */ new_mode;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = chmod_file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20003;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20103)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine file_utimes */
mig_external kern_return_t file_utimes
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t utimes_file,
	time_value_t new_atime,
	time_value_t new_mtime
)
#else
	(utimes_file, new_atime, new_mtime)
	file_t utimes_file;
	time_value_t new_atime;
	time_value_t new_mtime;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_atimeType;
		time_value_t new_atime;
		mach_msg_type_t new_mtimeType;
		time_value_t new_mtime;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 48;

#if	UseStaticMsgType
	static mach_msg_type_t new_atimeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		2,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t new_mtimeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		2,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->new_atimeType = new_atimeType;
#else	UseStaticMsgType
	InP->new_atimeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->new_atimeType.msgt_size = 32;
	InP->new_atimeType.msgt_number = 2;
	InP->new_atimeType.msgt_inline = TRUE;
	InP->new_atimeType.msgt_longform = FALSE;
	InP->new_atimeType.msgt_deallocate = FALSE;
	InP->new_atimeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->new_atime /* new_atime */ = /* new_atime */ new_atime;

#if	UseStaticMsgType
	InP->new_mtimeType = new_mtimeType;
#else	UseStaticMsgType
	InP->new_mtimeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->new_mtimeType.msgt_size = 32;
	InP->new_mtimeType.msgt_number = 2;
	InP->new_mtimeType.msgt_inline = TRUE;
	InP->new_mtimeType.msgt_longform = FALSE;
	InP->new_mtimeType.msgt_deallocate = FALSE;
	InP->new_mtimeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->new_mtime /* new_mtime */ = /* new_mtime */ new_mtime;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = utimes_file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20004;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20104)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine file_seek */
mig_external kern_return_t file_seek
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t seek_file,
	int offset,
	int whence,
	int *newp
)
#else
	(seek_file, offset, whence, newp)
	file_t seek_file;
	int offset;
	int whence;
	int *newp;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		int offset;
		mach_msg_type_t whenceType;
		int whence;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t newpType;
		int newp;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 40;

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t whenceType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newpCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset /* offset */ = /* offset */ offset;

#if	UseStaticMsgType
	InP->whenceType = whenceType;
#else	UseStaticMsgType
	InP->whenceType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->whenceType.msgt_size = 32;
	InP->whenceType.msgt_number = 1;
	InP->whenceType.msgt_inline = TRUE;
	InP->whenceType.msgt_longform = FALSE;
	InP->whenceType.msgt_deallocate = FALSE;
	InP->whenceType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->whence /* whence */ = /* whence */ whence;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = seek_file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20005;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20105)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 40) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->newpType != * (int *) &newpCheck)
#else	UseStaticMsgType
	if ((OutP->newpType.msgt_inline != TRUE) ||
	    (OutP->newpType.msgt_longform != FALSE) ||
	    (OutP->newpType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->newpType.msgt_number != 1) ||
	    (OutP->newpType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*newp /* newp */ = /* *newp */ OutP->newp;

	return OutP->RetCode;
}

/* Routine file_truncate */
mig_external kern_return_t file_truncate
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t trunc_file,
	int new_size
)
#else
	(trunc_file, new_size)
	file_t trunc_file;
	int new_size;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_sizeType;
		int new_size;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 32;

#if	UseStaticMsgType
	static mach_msg_type_t new_sizeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->new_sizeType = new_sizeType;
#else	UseStaticMsgType
	InP->new_sizeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->new_sizeType.msgt_size = 32;
	InP->new_sizeType.msgt_number = 1;
	InP->new_sizeType.msgt_inline = TRUE;
	InP->new_sizeType.msgt_longform = FALSE;
	InP->new_sizeType.msgt_deallocate = FALSE;
	InP->new_sizeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->new_size /* new_size */ = /* new_size */ new_size;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = trunc_file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20006;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20106)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine file_lock */
mig_external kern_return_t file_lock
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t lock_file,
	int flags
)
#else
	(lock_file, flags)
	file_t lock_file;
	int flags;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flagsType;
		int flags;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 32;

#if	UseStaticMsgType
	static mach_msg_type_t flagsType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->flagsType = flagsType;
#else	UseStaticMsgType
	InP->flagsType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->flagsType.msgt_size = 32;
	InP->flagsType.msgt_number = 1;
	InP->flagsType.msgt_inline = TRUE;
	InP->flagsType.msgt_longform = FALSE;
	InP->flagsType.msgt_deallocate = FALSE;
	InP->flagsType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->flags /* flags */ = /* flags */ flags;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = lock_file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20007;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20107)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine file_getdev */
mig_external kern_return_t file_getdev
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t dev_file,
	device_t *device
)
#else
	(dev_file, device)
	file_t dev_file;
	device_t *device;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t deviceType;
		device_t device;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 24;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t deviceCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = dev_file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20008;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20108)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 40) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->deviceType != * (int *) &deviceCheck)
#else	UseStaticMsgType
	if ((OutP->deviceType.msgt_inline != TRUE) ||
	    (OutP->deviceType.msgt_longform != FALSE) ||
	    (OutP->deviceType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->deviceType.msgt_number != 1) ||
	    (OutP->deviceType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*device /* device */ = /* *device */ OutP->device;

	return OutP->RetCode;
}

/* Routine file_getcontrol */
mig_external kern_return_t file_getcontrol
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	mach_port_t *control
)
#else
	(file, control)
	file_t file;
	mach_port_t *control;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t controlType;
		mach_port_t control;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 24;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t controlCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20009;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20109)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 40) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->controlType != * (int *) &controlCheck)
#else	UseStaticMsgType
	if ((OutP->controlType.msgt_inline != TRUE) ||
	    (OutP->controlType.msgt_longform != FALSE) ||
	    (OutP->controlType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->controlType.msgt_number != 1) ||
	    (OutP->controlType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*control /* control */ = /* *control */ OutP->control;

	return OutP->RetCode;
}

/* Routine file_statfs */
mig_external kern_return_t file_statfs
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	fsys_statfsbuf_t *info
)
#else
	(file, info)
	file_t file;
	fsys_statfsbuf_t *info;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t infoType;
		fsys_statfsbuf_t info;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 24;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t infoCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		19,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20010;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20110)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 112) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->infoType != * (int *) &infoCheck)
#else	UseStaticMsgType
	if ((OutP->infoType.msgt_inline != TRUE) ||
	    (OutP->infoType.msgt_longform != FALSE) ||
	    (OutP->infoType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->infoType.msgt_number != 19) ||
	    (OutP->infoType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*info /* info */ = /* *info */ OutP->info;

	return OutP->RetCode;
}

/* Routine file_sync */
mig_external kern_return_t file_sync
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	int wait
)
#else
	(file, wait)
	file_t file;
	int wait;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t waitType;
		int wait;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 32;

#if	UseStaticMsgType
	static mach_msg_type_t waitType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->waitType = waitType;
#else	UseStaticMsgType
	InP->waitType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->waitType.msgt_size = 32;
	InP->waitType.msgt_number = 1;
	InP->waitType.msgt_inline = TRUE;
	InP->waitType.msgt_longform = FALSE;
	InP->waitType.msgt_deallocate = FALSE;
	InP->waitType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->wait /* wait */ = /* wait */ wait;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20011;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20111)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine file_syncfs */
mig_external kern_return_t file_syncfs
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	int wait,
	int do_children
)
#else
	(file, wait, do_children)
	file_t file;
	int wait;
	int do_children;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t waitType;
		int wait;
		mach_msg_type_t do_childrenType;
		int do_children;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 40;

#if	UseStaticMsgType
	static mach_msg_type_t waitType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t do_childrenType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->waitType = waitType;
#else	UseStaticMsgType
	InP->waitType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->waitType.msgt_size = 32;
	InP->waitType.msgt_number = 1;
	InP->waitType.msgt_inline = TRUE;
	InP->waitType.msgt_longform = FALSE;
	InP->waitType.msgt_deallocate = FALSE;
	InP->waitType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->wait /* wait */ = /* wait */ wait;

#if	UseStaticMsgType
	InP->do_childrenType = do_childrenType;
#else	UseStaticMsgType
	InP->do_childrenType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->do_childrenType.msgt_size = 32;
	InP->do_childrenType.msgt_number = 1;
	InP->do_childrenType.msgt_inline = TRUE;
	InP->do_childrenType.msgt_longform = FALSE;
	InP->do_childrenType.msgt_deallocate = FALSE;
	InP->do_childrenType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->do_children /* do_children */ = /* do_children */ do_children;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20012;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20112)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine file_pathconf */
mig_external kern_return_t file_pathconf
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	pathconf_t *pathconf
)
#else
	(file, pathconf)
	file_t file;
	pathconf_t *pathconf;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t pathconfType;
		pathconf_t pathconf;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 24;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pathconfCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		9,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = file;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20013;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20113)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 72) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->pathconfType != * (int *) &pathconfCheck)
#else	UseStaticMsgType
	if ((OutP->pathconfType.msgt_inline != TRUE) ||
	    (OutP->pathconfType.msgt_longform != FALSE) ||
	    (OutP->pathconfType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->pathconfType.msgt_number != 9) ||
	    (OutP->pathconfType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*pathconf /* pathconf */ = /* *pathconf */ OutP->pathconf;

	return OutP->RetCode;
}

/* Routine dir_pathtrans */
mig_external kern_return_t dir_pathtrans
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t start_dir,
	filename_t pathname,
	mach_msg_type_number_t pathnameCnt,
	int flags,
	mode_t mode,
	retry_type *do_retry,
	filename_t retry_name,
	mach_msg_type_number_t *retry_nameCnt,
	file_t *result
)
#else
	(start_dir, pathname, pathnameCnt, flags, mode, do_retry, retry_name, retry_nameCnt, result)
	file_t start_dir;
	filename_t pathname;
	mach_msg_type_number_t pathnameCnt;
	int flags;
	mode_t mode;
	retry_type *do_retry;
	filename_t retry_name;
	mach_msg_type_number_t *retry_nameCnt;
	file_t *result;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pathnameType;
		char pathname[1024];
		mach_msg_type_t flagsType;
		int flags;
		mach_msg_type_t modeType;
		mode_t mode;
		char modePad[2];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t do_retryType;
		retry_type do_retry;
		mach_msg_type_t retry_nameType;
		char retry_name[1024];
		mach_msg_type_t resultType;
		file_t result;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 44;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t pathnameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t flagsType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t modeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_16,
		/* msgt_size = */		16,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t do_retryCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t resultCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->pathnameType = pathnameType;
#else	UseStaticMsgType
	InP->pathnameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->pathnameType.msgt_size = 8;
	InP->pathnameType.msgt_inline = TRUE;
	InP->pathnameType.msgt_longform = FALSE;
	InP->pathnameType.msgt_deallocate = FALSE;
	InP->pathnameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (pathnameCnt > 1024)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) pathname, (char *) InP->pathname, 1 * pathnameCnt);

	InP->pathnameType.msgt_number /* pathnameCnt */ = /* pathnameType.msgt_number */ pathnameCnt;

	msgh_size_delta = (1 * pathnameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 1024);

#if	UseStaticMsgType
	InP->flagsType = flagsType;
#else	UseStaticMsgType
	InP->flagsType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->flagsType.msgt_size = 32;
	InP->flagsType.msgt_number = 1;
	InP->flagsType.msgt_inline = TRUE;
	InP->flagsType.msgt_longform = FALSE;
	InP->flagsType.msgt_deallocate = FALSE;
	InP->flagsType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->flags /* flags */ = /* flags */ flags;

#if	UseStaticMsgType
	InP->modeType = modeType;
#else	UseStaticMsgType
	InP->modeType.msgt_name = MACH_MSG_TYPE_INTEGER_16;
	InP->modeType.msgt_size = 16;
	InP->modeType.msgt_number = 1;
	InP->modeType.msgt_inline = TRUE;
	InP->modeType.msgt_longform = FALSE;
	InP->modeType.msgt_deallocate = FALSE;
	InP->modeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->mode /* mode */ = /* mode */ mode;

	InP = &Mess.In;
	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = start_dir;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20014;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20114)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size < 52) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->do_retryType != * (int *) &do_retryCheck)
#else	UseStaticMsgType
	if ((OutP->do_retryType.msgt_inline != TRUE) ||
	    (OutP->do_retryType.msgt_longform != FALSE) ||
	    (OutP->do_retryType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->do_retryType.msgt_number != 1) ||
	    (OutP->do_retryType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*do_retry /* do_retry */ = /* *do_retry */ OutP->do_retry;

#if	TypeCheck
	if ((OutP->retry_nameType.msgt_inline != TRUE) ||
	    (OutP->retry_nameType.msgt_longform != FALSE) ||
	    (OutP->retry_nameType.msgt_name != MACH_MSG_TYPE_CHAR) ||
	    (OutP->retry_nameType.msgt_size != 8))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	msgh_size_delta = (1 * OutP->retry_nameType.msgt_number)+3 &~ 3;
#if	TypeCheck
	if (msgh_size != 52 + msgh_size_delta)
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->retry_nameType.msgt_number / 1 > *retry_nameCnt) {
		bcopy((char *) OutP->retry_name, (char *) retry_name, 1 * *retry_nameCnt);
		*retry_nameCnt /* retry_nameType.msgt_number 1 */ = /* *retry_nameCnt */ OutP->retry_nameType.msgt_number / 1;
		return MIG_ARRAY_TOO_LARGE;
	}
	bcopy((char *) OutP->retry_name, (char *) retry_name, 1 * OutP->retry_nameType.msgt_number);

	*retry_nameCnt /* retry_nameType.msgt_number */ = /* *retry_nameCnt */ OutP->retry_nameType.msgt_number;

	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 1024);

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->resultType != * (int *) &resultCheck)
#else	UseStaticMsgType
	if ((OutP->resultType.msgt_inline != TRUE) ||
	    (OutP->resultType.msgt_longform != FALSE) ||
	    (OutP->resultType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->resultType.msgt_number != 1) ||
	    (OutP->resultType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*result /* result */ = /* *result */ OutP->result;

	OutP = &Mess.Out;
	return OutP->RetCode;
}

/* Routine dir_setsys */
mig_external kern_return_t dir_setsys
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt
)
#else
	(directory, name, nameCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 28;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20015;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20115)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_lstat */
mig_external kern_return_t dir_lstat
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	io_statbuf_t *stat_info
)
#else
	(directory, name, nameCnt, stat_info)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	io_statbuf_t *stat_info;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t stat_infoType;
		io_statbuf_t stat_info;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 28;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t stat_infoCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		28,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20016;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20116)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 148) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->stat_infoType != * (int *) &stat_infoCheck)
#else	UseStaticMsgType
	if ((OutP->stat_infoType.msgt_inline != TRUE) ||
	    (OutP->stat_infoType.msgt_longform != FALSE) ||
	    (OutP->stat_infoType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->stat_infoType.msgt_number != 28) ||
	    (OutP->stat_infoType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*stat_info /* stat_info */ = /* *stat_info */ OutP->stat_info;

	return OutP->RetCode;
}

/* Routine dir_mkdir */
mig_external kern_return_t dir_mkdir
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	int mode
)
#else
	(directory, name, nameCnt, mode)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	int mode;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
		mach_msg_type_t modeType;
		int mode;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 36;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t modeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 512);

#if	UseStaticMsgType
	InP->modeType = modeType;
#else	UseStaticMsgType
	InP->modeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->modeType.msgt_size = 32;
	InP->modeType.msgt_number = 1;
	InP->modeType.msgt_inline = TRUE;
	InP->modeType.msgt_longform = FALSE;
	InP->modeType.msgt_deallocate = FALSE;
	InP->modeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->mode /* mode */ = /* mode */ mode;

	InP = &Mess.In;
	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20017;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20117)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_rmdir */
mig_external kern_return_t dir_rmdir
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt
)
#else
	(directory, name, nameCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 28;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20018;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20118)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_mknod */
mig_external kern_return_t dir_mknod
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	mode_t mode,
	dev_t device
)
#else
	(directory, name, nameCnt, mode, device)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	mode_t mode;
	dev_t device;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
		mach_msg_type_t modeType;
		mode_t mode;
		char modePad[2];
		mach_msg_type_t deviceType;
		dev_t device;
		char devicePad[2];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 44;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t modeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_16,
		/* msgt_size = */		16,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t deviceType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_16,
		/* msgt_size = */		16,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 512);

#if	UseStaticMsgType
	InP->modeType = modeType;
#else	UseStaticMsgType
	InP->modeType.msgt_name = MACH_MSG_TYPE_INTEGER_16;
	InP->modeType.msgt_size = 16;
	InP->modeType.msgt_number = 1;
	InP->modeType.msgt_inline = TRUE;
	InP->modeType.msgt_longform = FALSE;
	InP->modeType.msgt_deallocate = FALSE;
	InP->modeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->mode /* mode */ = /* mode */ mode;

#if	UseStaticMsgType
	InP->deviceType = deviceType;
#else	UseStaticMsgType
	InP->deviceType.msgt_name = MACH_MSG_TYPE_INTEGER_16;
	InP->deviceType.msgt_size = 16;
	InP->deviceType.msgt_number = 1;
	InP->deviceType.msgt_inline = TRUE;
	InP->deviceType.msgt_longform = FALSE;
	InP->deviceType.msgt_deallocate = FALSE;
	InP->deviceType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->device /* device */ = /* device */ device;

	InP = &Mess.In;
	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20019;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20119)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_unlink */
mig_external kern_return_t dir_unlink
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt
)
#else
	(directory, name, nameCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 28;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20020;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20120)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_link */
mig_external kern_return_t dir_link
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t oldfile,
	file_t newdirectory,
	filecomp_t newname,
	mach_msg_type_number_t newnameCnt
)
#else
	(oldfile, newdirectory, newname, newnameCnt)
	file_t oldfile;
	file_t newdirectory;
	filecomp_t newname;
	mach_msg_type_number_t newnameCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t newdirectoryType;
		file_t newdirectory;
		mach_msg_type_t newnameType;
		char newname[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 36;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t newdirectoryType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newnameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->newdirectoryType = newdirectoryType;
#else	UseStaticMsgType
	InP->newdirectoryType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->newdirectoryType.msgt_size = 32;
	InP->newdirectoryType.msgt_number = 1;
	InP->newdirectoryType.msgt_inline = TRUE;
	InP->newdirectoryType.msgt_longform = FALSE;
	InP->newdirectoryType.msgt_deallocate = FALSE;
	InP->newdirectoryType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->newdirectory /* newdirectory */ = /* newdirectory */ newdirectory;

#if	UseStaticMsgType
	InP->newnameType = newnameType;
#else	UseStaticMsgType
	InP->newnameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->newnameType.msgt_size = 8;
	InP->newnameType.msgt_inline = TRUE;
	InP->newnameType.msgt_longform = FALSE;
	InP->newnameType.msgt_deallocate = FALSE;
	InP->newnameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (newnameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) newname, (char *) InP->newname, 1 * newnameCnt);

	InP->newnameType.msgt_number /* newnameCnt */ = /* newnameType.msgt_number */ newnameCnt;

	msgh_size_delta = (1 * newnameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = oldfile;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20021;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20121)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_symlink */
mig_external kern_return_t dir_symlink
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	filename_t linktarget,
	mach_msg_type_number_t linktargetCnt
)
#else
	(directory, name, nameCnt, linktarget, linktargetCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	filename_t linktarget;
	mach_msg_type_number_t linktargetCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
		mach_msg_type_t linktargetType;
		char linktarget[1024];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 32;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t linktargetType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 512);

#if	UseStaticMsgType
	InP->linktargetType = linktargetType;
#else	UseStaticMsgType
	InP->linktargetType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->linktargetType.msgt_size = 8;
	InP->linktargetType.msgt_inline = TRUE;
	InP->linktargetType.msgt_longform = FALSE;
	InP->linktargetType.msgt_deallocate = FALSE;
	InP->linktargetType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (linktargetCnt > 1024)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) linktarget, (char *) InP->linktarget, 1 * linktargetCnt);

	InP->linktargetType.msgt_number /* linktargetCnt */ = /* linktargetType.msgt_number */ linktargetCnt;

	msgh_size_delta = (1 * linktargetCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP = &Mess.In;
	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20022;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20122)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_readlink */
mig_external kern_return_t dir_readlink
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	filename_t contents,
	mach_msg_type_number_t *contentsCnt
)
#else
	(directory, name, nameCnt, contents, contentsCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	filename_t contents;
	mach_msg_type_number_t *contentsCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t contentsType;
		char contents[1024];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 28;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20023;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20123)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size < 36) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->contentsType.msgt_inline != TRUE) ||
	    (OutP->contentsType.msgt_longform != FALSE) ||
	    (OutP->contentsType.msgt_name != MACH_MSG_TYPE_CHAR) ||
	    (OutP->contentsType.msgt_size != 8))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	msgh_size_delta = (1 * OutP->contentsType.msgt_number)+3 &~ 3;
	if (msgh_size != 36 + msgh_size_delta)
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->contentsType.msgt_number / 1 > *contentsCnt) {
		bcopy((char *) OutP->contents, (char *) contents, 1 * *contentsCnt);
		*contentsCnt /* contentsType.msgt_number 1 */ = /* *contentsCnt */ OutP->contentsType.msgt_number / 1;
		return MIG_ARRAY_TOO_LARGE;
	}
	bcopy((char *) OutP->contents, (char *) contents, 1 * OutP->contentsType.msgt_number);

	*contentsCnt /* contentsType.msgt_number */ = /* *contentsCnt */ OutP->contentsType.msgt_number;

	OutP = &Mess.Out;
	return OutP->RetCode;
}

/* Routine dir_rename */
mig_external kern_return_t dir_rename
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t olddirectory,
	filecomp_t oldname,
	mach_msg_type_number_t oldnameCnt,
	file_t newdirectory,
	filecomp_t newname,
	mach_msg_type_number_t newnameCnt
)
#else
	(olddirectory, oldname, oldnameCnt, newdirectory, newname, newnameCnt)
	file_t olddirectory;
	filecomp_t oldname;
	mach_msg_type_number_t oldnameCnt;
	file_t newdirectory;
	filecomp_t newname;
	mach_msg_type_number_t newnameCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t oldnameType;
		char oldname[512];
		mach_msg_type_t newdirectoryType;
		file_t newdirectory;
		mach_msg_type_t newnameType;
		char newname[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 40;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t oldnameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newdirectoryType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newnameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->oldnameType = oldnameType;
#else	UseStaticMsgType
	InP->oldnameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->oldnameType.msgt_size = 8;
	InP->oldnameType.msgt_inline = TRUE;
	InP->oldnameType.msgt_longform = FALSE;
	InP->oldnameType.msgt_deallocate = FALSE;
	InP->oldnameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (oldnameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) oldname, (char *) InP->oldname, 1 * oldnameCnt);

	InP->oldnameType.msgt_number /* oldnameCnt */ = /* oldnameType.msgt_number */ oldnameCnt;

	msgh_size_delta = (1 * oldnameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 512);

#if	UseStaticMsgType
	InP->newdirectoryType = newdirectoryType;
#else	UseStaticMsgType
	InP->newdirectoryType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->newdirectoryType.msgt_size = 32;
	InP->newdirectoryType.msgt_number = 1;
	InP->newdirectoryType.msgt_inline = TRUE;
	InP->newdirectoryType.msgt_longform = FALSE;
	InP->newdirectoryType.msgt_deallocate = FALSE;
	InP->newdirectoryType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->newdirectory /* newdirectory */ = /* newdirectory */ newdirectory;

#if	UseStaticMsgType
	InP->newnameType = newnameType;
#else	UseStaticMsgType
	InP->newnameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->newnameType.msgt_size = 8;
	InP->newnameType.msgt_inline = TRUE;
	InP->newnameType.msgt_longform = FALSE;
	InP->newnameType.msgt_deallocate = FALSE;
	InP->newnameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (newnameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) newname, (char *) InP->newname, 1 * newnameCnt);

	InP->newnameType.msgt_number /* newnameCnt */ = /* newnameType.msgt_number */ newnameCnt;

	msgh_size_delta = (1 * newnameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP = &Mess.In;
	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = olddirectory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20024;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20124)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_set_translator */
mig_external kern_return_t dir_set_translator
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	boolean_t permanent,
	int oldtrans_flags,
	filename_t trans_name,
	mach_msg_type_number_t trans_nameCnt,
	fsys_t existing
)
#else
	(directory, name, nameCnt, permanent, oldtrans_flags, trans_name, trans_nameCnt, existing)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	boolean_t permanent;
	int oldtrans_flags;
	filename_t trans_name;
	mach_msg_type_number_t trans_nameCnt;
	fsys_t existing;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
		mach_msg_type_t permanentType;
		boolean_t permanent;
		mach_msg_type_t oldtrans_flagsType;
		int oldtrans_flags;
		mach_msg_type_t trans_nameType;
		char trans_name[1024];
		mach_msg_type_t existingType;
		fsys_t existing;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 56;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t permanentType = {
		/* msgt_name = */		MACH_MSG_TYPE_BOOLEAN,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t oldtrans_flagsType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t trans_nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t existingType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 512);

#if	UseStaticMsgType
	InP->permanentType = permanentType;
#else	UseStaticMsgType
	InP->permanentType.msgt_name = MACH_MSG_TYPE_BOOLEAN;
	InP->permanentType.msgt_size = 32;
	InP->permanentType.msgt_number = 1;
	InP->permanentType.msgt_inline = TRUE;
	InP->permanentType.msgt_longform = FALSE;
	InP->permanentType.msgt_deallocate = FALSE;
	InP->permanentType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->permanent /* permanent */ = /* permanent */ permanent;

#if	UseStaticMsgType
	InP->oldtrans_flagsType = oldtrans_flagsType;
#else	UseStaticMsgType
	InP->oldtrans_flagsType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->oldtrans_flagsType.msgt_size = 32;
	InP->oldtrans_flagsType.msgt_number = 1;
	InP->oldtrans_flagsType.msgt_inline = TRUE;
	InP->oldtrans_flagsType.msgt_longform = FALSE;
	InP->oldtrans_flagsType.msgt_deallocate = FALSE;
	InP->oldtrans_flagsType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->oldtrans_flags /* oldtrans_flags */ = /* oldtrans_flags */ oldtrans_flags;

#if	UseStaticMsgType
	InP->trans_nameType = trans_nameType;
#else	UseStaticMsgType
	InP->trans_nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->trans_nameType.msgt_size = 8;
	InP->trans_nameType.msgt_inline = TRUE;
	InP->trans_nameType.msgt_longform = FALSE;
	InP->trans_nameType.msgt_deallocate = FALSE;
	InP->trans_nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (trans_nameCnt > 1024)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) trans_name, (char *) InP->trans_name, 1 * trans_nameCnt);

	InP->trans_nameType.msgt_number /* trans_nameCnt */ = /* trans_nameType.msgt_number */ trans_nameCnt;

	msgh_size_delta = (1 * trans_nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 1024);

#if	UseStaticMsgType
	InP->existingType = existingType;
#else	UseStaticMsgType
	InP->existingType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->existingType.msgt_size = 32;
	InP->existingType.msgt_number = 1;
	InP->existingType.msgt_inline = TRUE;
	InP->existingType.msgt_longform = FALSE;
	InP->existingType.msgt_deallocate = FALSE;
	InP->existingType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->existing /* existing */ = /* existing */ existing;

	InP = &Mess.In;
	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20025;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20125)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_use_translator */
mig_external kern_return_t dir_use_translator
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	int useit
)
#else
	(directory, name, nameCnt, useit)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	int useit;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
		mach_msg_type_t useitType;
		int useit;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 36;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t useitType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 512);

#if	UseStaticMsgType
	InP->useitType = useitType;
#else	UseStaticMsgType
	InP->useitType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->useitType.msgt_size = 32;
	InP->useitType.msgt_number = 1;
	InP->useitType.msgt_inline = TRUE;
	InP->useitType.msgt_longform = FALSE;
	InP->useitType.msgt_deallocate = FALSE;
	InP->useitType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->useit /* useit */ = /* useit */ useit;

	InP = &Mess.In;
	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20026;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20126)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 32) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine dir_get_translator */
mig_external kern_return_t dir_get_translator
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	mach_port_t *trans_control
)
#else
	(directory, name, nameCnt, trans_control)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	mach_port_t *trans_control;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t trans_controlType;
		mach_port_t trans_control;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 28;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t trans_controlCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20027;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20127)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 40) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->trans_controlType != * (int *) &trans_controlCheck)
#else	UseStaticMsgType
	if ((OutP->trans_controlType.msgt_inline != TRUE) ||
	    (OutP->trans_controlType.msgt_longform != FALSE) ||
	    (OutP->trans_controlType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->trans_controlType.msgt_number != 1) ||
	    (OutP->trans_controlType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*trans_control /* trans_control */ = /* *trans_control */ OutP->trans_control;

	return OutP->RetCode;
}

/* Routine dir_statfs */
mig_external kern_return_t dir_statfs
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	fsys_statfsbuf_t *info
)
#else
	(directory, name, nameCnt, info)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	fsys_statfsbuf_t *info;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		char name[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t infoType;
		fsys_statfsbuf_t info;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
	unsigned int msgh_size = 28;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_CHAR,
		/* msgt_size = */		8,
		/* msgt_number = */		512,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t infoCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		19,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msgt_name = MACH_MSG_TYPE_CHAR;
	InP->nameType.msgt_size = 8;
	InP->nameType.msgt_inline = TRUE;
	InP->nameType.msgt_longform = FALSE;
	InP->nameType.msgt_deallocate = FALSE;
	InP->nameType.msgt_unused = 0;
#endif	UseStaticMsgType

	if (nameCnt > 512)
		return MIG_ARRAY_TOO_LARGE;
	bcopy((char *) name, (char *) InP->name, 1 * nameCnt);

	InP->nameType.msgt_number /* nameCnt */ = /* nameType.msgt_number */ nameCnt;

	msgh_size_delta = (1 * nameCnt)+3 &~ 3;
	msgh_size += msgh_size_delta;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = directory;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_kind = MACH_MSGH_KIND_NORMAL | MSG_TYPE_RPC;
	InP->Head.msgh_id = 20028;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
#endif	TypeCheck

	if (OutP->Head.msgh_id != 20128)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msgh_size != 112) || !msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->infoType != * (int *) &infoCheck)
#else	UseStaticMsgType
	if ((OutP->infoType.msgt_inline != TRUE) ||
	    (OutP->infoType.msgt_longform != FALSE) ||
	    (OutP->infoType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->infoType.msgt_number != 19) ||
	    (OutP->infoType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*info /* info */ = /* *info */ OutP->info;

	return OutP->RetCode;
}
