/* Functions to set bits on processes
   Copyright (C) 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

error_t
proc_markstop (struct proc *p,
	       int signo)
{
  p->p_stopped = 1;

  if (p->p_parentset 
      && p->p_parent->p_waiting
      && (p->p_traced || (p->p_parent->p_wc.pw_options & WUNTRACED))
      && (p->p_parent->p_wc.pw_pid == p->p_pid
	  || p->p_parent->p_wc.pw_pid == 0
	  || p->p_parent->p_wc.pw_pid == - p->p_pgrp->pg_pgid))
    {
      complete_wait (p, W_STOPCODE (signo));
      p->p_waited = 1;
    }
  else
    {
      p->p_status = W_STOPCODE (signo);
      p->p_waited = 0;
    }
  return 0;
}


error_t
proc_mark_cont (struct proc *p)
{
  p->p_stopped = 0;
  p->p_status = 0;
  return 0;
}

error_t
proc_mark_exit (struct proc *p,
		int status)
{
  if (WIFSTOPPED (status))
    return EINVAL;
  
  p->p_exiting = 1;
  p->p_exit_status = status;
  return 0;
}

error_t
proc_mark_exec (struct proc *p)
{
  p->p_exec = 1;
  return 0;
}

error_t
proc_mark_traced (struct proc *p)
{
  p->p_traced = 1;
  return 0;
}

error_t
proc_mark_nostopchild (struct proc *p,
		       int value)
{
  p->p_nostopcld = !! value;
  return 0;
}

  
  
	  
