/* Machine dependent signal definitions for i386
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

typedef int sig_atomic_t;

/* Signal context.  */
struct __sigcontext
{
  int sc_onstack;		/* sigstack state */
  int sc_mask;			/* signal mask */
  
  /* Segment registers  (not set by Alix) */
  int sc_gs;
  int sc_fs;
  int sc_es;
  int sc_ds;
  
  /* "General" registers */
  int sc_edi;
  int sc_esi;
  int sc_ebp;
  int sc_esp;			/* not used by alix */
  int sc_ebx;
  int sc_edx;
  int sc_ecx;
  int sc_eax;
  
  int sc_trapno;		/* not used by alix */
  int sc_err;			/* not used by alix */
  
  int sc_eip;			/* instruction pointer */
   
  int sc_cs;			/* not used by alix */
  
  int sc_efl;			/* flags */
  int sc_uesp;			/* THIS stack pointer is used */
  int sc_ss;			/* segment reg, not used by alix */
};


/* Codes for SIGFPE */
#define __FPE_INTOVF_TRAP	0x1 /* integer overflow */
#define __FPE_INTDIV_FAULT	0x2 /* integer divide by zero */
#define __FPE_FLTOVF_FAULT	0x3 /* floating overflow */
#define __FPE_FLTDIV_FAULT	0x4 /* floating divide by zero */
#define __FPE_FLTUND_FAULT	0x5 /* floating underflow */
#define __FPE_SUBRNG_FAULT	0x7 /* BOUNDS instruction failed */
#define __FPE_FLTDNR_FAULT	0x8 /* denormalized operand */
#define __FPE_FLTINX_FAULT	0x9 /* floating loss of precision */
#define __FPE_EMERR_FAULT	0xa /* mysterious emulation error 33 */
#define __FPE_EMBND_FAULT	0xb /* emulation BOUNDS instruction failed */

/* Codes for SIGILL */
#define __ILL_INVOPR_FAULT	0x1 /* invalid operation */
#define __ILL_STACK_FAULT	0x2 /* fault on microkernel stack access */
#define __ILL_FPEOPR_FAULT	0x3 /* invalid floating operation */

/* Codes for SIGTRAP */
#define __DBG_SINGLE_TRAP	0x1 /* single step */
#define __DBG_BRKPNT_FAULT	0x2 /* breakpoint instruction */




#ifdef __USE_GNU

#define FPE_INTOVF_TRAP __FPE_INTOVF_TRAP
#define FPE_INTDIV_FAULT __FPE_INTDIV_FAULT
#define FPE_FLTOVF_FAULT __FPE_FLTOVF_FAULT
#define FPE_FLTDIV_FAULT __FPE_FLTDIV_FAULT
#define FPE_FLTUND_FAULT __FPE_FLTUND_FAULT
#define FPE_SUBRNG_FAULT __FPE_SUBRNG_FAULT
#define FPE_FLTDNR_FAULT __FPE_FLTDNR_FAULT
#define FPE_FLTINX_FAULT __FPE_FLTINX_FAULT
#define FPE_EMERR_FAULT __FPE_EMERR_FAULT
#define FPE_EMBND_FAULT __FPE_EMBND_FAULT

#define ILL_INVOPR_FAULT __ILL_INVOPR_FAULT
#define ILL_STACK_FAULT __ILL_STACK_FAULT
#define ILL_FPEOPR_FAULT __ILL_FPEOPR_FAULT

#define DBG_SINGLE_TRAP __DBG_SINGLE_TRAP
#define DBG_BRKPNT_FAULT __DBG_BRKPNT_FAULT

#endif  /* __USE_GNU */


#ifdef __GNU_SYSTEM
#define sigcontext __sigcontext
#define sig_atomic_t __sig_atomic_t
#endif

