/*
   Copyright (C) 1992 Free Software Foundation, Inc.

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Roland McGrath.  */

#include <mach.h>
#include <string.h>

tfs_file_get_translator (mach_port_t file,
			 char **trans, size_t *translen)
{
  char buf[2048], *bufp = buf, *p;
  size_t len = sizeof (buf);
  int err;

  if (err = file_get_translator (tfs_underlying (file),
				 &bufp, &len))
    return err;

  p = memchr (bufp, len, '\0');
  if (p == NULL)
    /* We are the only translator.  */
    *translen = 0;
  else
    {
      ++p;
      if (bufp == buf)
	{
	  if (err = vm_allocate (mach_task_self, trans, bufp + len - p))
	    return err;
	}
      else
	{
	  *trans = bufp;
	  bufp = buf;
	}
      memmove (*trans, p, bufp + len - p);
      *translen = bufp + len - p;
    }

  if (bufp != buf)
    vm_deallocate (mach_task_self (), bufp, len);

  return 0;
}
