#ifndef	_process_server_
#define	_process_server_

/* Module process */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>
#include <lib/libhurd.h>
#include "proc.h"

/* Routine proc_sethostid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_sethostid
#if	defined(LINTLIBRARY)
    (process, hostid)
	pstruct_t process;
	int hostid;
{ return proc_sethostid(process, hostid); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	int hostid
);
#else
    ();
#endif
#endif

/* Routine proc_gethostid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_gethostid
#if	defined(LINTLIBRARY)
    (process, hostid)
	pstruct_t process;
	int *hostid;
{ return proc_gethostid(process, hostid); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	int *hostid
);
#else
    ();
#endif
#endif

/* Routine proc_sethostname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_sethostname
#if	defined(LINTLIBRARY)
    (process, hostname)
	pstruct_t process;
	string_t hostname;
{ return proc_sethostname(process, hostname); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	string_t hostname
);
#else
    ();
#endif
#endif

/* Routine proc_gethostname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_gethostname
#if	defined(LINTLIBRARY)
    (process, hostname)
	pstruct_t process;
	string_t hostname;
{ return proc_gethostname(process, hostname); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	string_t hostname
);
#else
    ();
#endif
#endif

/* Routine proc_getpids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getpids
#if	defined(LINTLIBRARY)
    (process, pid, ppid, orphaned)
	pstruct_t process;
	pid_t *pid;
	pid_t *ppid;
	int *orphaned;
{ return proc_getpids(process, pid, ppid, orphaned); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t *pid,
	pid_t *ppid,
	int *orphaned
);
#else
    ();
#endif
#endif

/* SimpleRoutine proc_reauthenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_reauthenticate
#if	defined(LINTLIBRARY)
    (process)
	pstruct_t process;
{ return proc_reauthenticate(process); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process
);
#else
    ();
#endif
#endif

/* Routine proc_register */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_register
#if	defined(LINTLIBRARY)
    (old_process, proc_task, sigport, new_process)
	pstruct_t old_process;
	mach_port_t proc_task;
	sigthread_t sigport;
	mach_port_t *new_process;
{ return proc_register(old_process, proc_task, sigport, new_process); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t old_process,
	mach_port_t proc_task,
	sigthread_t sigport,
	mach_port_t *new_process
);
#else
    ();
#endif
#endif

/* Routine proc_setports */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setports
#if	defined(LINTLIBRARY)
    (process, pid, newsigport, newtaskport, oldsigport, oldtaskport)
	pstruct_t process;
	pid_t pid;
	sigthread_t newsigport;
	mach_port_t newtaskport;
	mach_port_t *oldsigport;
	mach_port_t *oldtaskport;
{ return proc_setports(process, pid, newsigport, newtaskport, oldsigport, oldtaskport); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t pid,
	sigthread_t newsigport,
	mach_port_t newtaskport,
	mach_port_t *oldsigport,
	mach_port_t *oldtaskport
);
#else
    ();
#endif
#endif

/* Routine proc_kill */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_kill
#if	defined(LINTLIBRARY)
    (process, pid, signal)
	pstruct_t process;
	pid_t pid;
	int signal;
{ return proc_kill(process, pid, signal); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t pid,
	int signal
);
#else
    ();
#endif
#endif

/* Routine proc_ctty_kill */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_ctty_kill
#if	defined(LINTLIBRARY)
    (process, pid, ctty, signal, stoppid, willstop)
	pstruct_t process;
	pid_t pid;
	mach_port_t ctty;
	int signal;
	int stoppid;
	int *willstop;
{ return proc_ctty_kill(process, pid, ctty, signal, stoppid, willstop); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t pid,
	mach_port_t ctty,
	int signal,
	int stoppid,
	int *willstop
);
#else
    ();
#endif
#endif

/* Routine proc_set_ctty */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_set_ctty
#if	defined(LINTLIBRARY)
    (process, ctty)
	pstruct_t process;
	mach_port_t ctty;
{ return proc_set_ctty(process, ctty); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	mach_port_t ctty
);
#else
    ();
#endif
#endif

/* Routine proc_wait */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_wait
#if	defined(LINTLIBRARY)
    (process, reply_port, reply_portPoly, pid, status, options, rusage, pid_status)
	pstruct_t process;
	mach_port_t reply_port;
	mach_msg_type_name_t reply_portPoly;
	pid_t pid;
	int *status;
	int options;
	rusage_t *rusage;
	pid_t *pid_status;
{ return proc_wait(process, reply_port, reply_portPoly, pid, status, options, rusage, pid_status); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	mach_port_t reply_port,
	mach_msg_type_name_t reply_portPoly,
	pid_t pid,
	int *status,
	int options,
	rusage_t *rusage,
	pid_t *pid_status
);
#else
    ();
#endif
#endif

/* Routine proc_waitintr */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_waitintr
#if	defined(LINTLIBRARY)
    (process)
	pstruct_t process;
{ return proc_waitintr(process); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process
);
#else
    ();
#endif
#endif

/* Routine proc_dostop */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_dostop
#if	defined(LINTLIBRARY)
    (process, contthread)
	pstruct_t process;
	mach_port_t contthread;
{ return proc_dostop(process, contthread); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	mach_port_t contthread
);
#else
    ();
#endif
#endif

/* Routine proc_markstop */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_markstop
#if	defined(LINTLIBRARY)
    (process, signo)
	pstruct_t process;
	int signo;
{ return proc_markstop(process, signo); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	int signo
);
#else
    ();
#endif
#endif

/* Routine proc_cont */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_cont
#if	defined(LINTLIBRARY)
    (process)
	pstruct_t process;
{ return proc_cont(process); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process
);
#else
    ();
#endif
#endif

/* Routine proc_exit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_exit
#if	defined(LINTLIBRARY)
    (process, status)
	pstruct_t process;
	int status;
{ return proc_exit(process, status); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	int status
);
#else
    ();
#endif
#endif

/* Routine proc_mark_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_exec
#if	defined(LINTLIBRARY)
    (process)
	pstruct_t process;
{ return proc_mark_exec(process); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process
);
#else
    ();
#endif
#endif

/* Routine proc_mark_traced */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_traced
#if	defined(LINTLIBRARY)
    (process)
	pstruct_t process;
{ return proc_mark_traced(process); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process
);
#else
    ();
#endif
#endif

/* Routine proc_mark_system */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_system
#if	defined(LINTLIBRARY)
    (process)
	pstruct_t process;
{ return proc_mark_system(process); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process
);
#else
    ();
#endif
#endif

/* Routine proc_mark_nostopchild */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_nostopchild
#if	defined(LINTLIBRARY)
    (process, doit)
	pstruct_t process;
	int doit;
{ return proc_mark_nostopchild(process, doit); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	int doit
);
#else
    ();
#endif
#endif

/* Routine proc_setsid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setsid
#if	defined(LINTLIBRARY)
    (process)
	pstruct_t process;
{ return proc_setsid(process); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process
);
#else
    ();
#endif
#endif

/* Routine proc_setpgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setpgrp
#if	defined(LINTLIBRARY)
    (process, pid, pgrp)
	pstruct_t process;
	pid_t pid;
	pid_t pgrp;
{ return proc_setpgrp(process, pid, pgrp); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t pid,
	pid_t pgrp
);
#else
    ();
#endif
#endif

/* Routine proc_getpgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getpgrp
#if	defined(LINTLIBRARY)
    (process, pid, pgrp)
	pstruct_t process;
	pid_t pid;
	pid_t *pgrp;
{ return proc_getpgrp(process, pid, pgrp); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t pid,
	pid_t *pgrp
);
#else
    ();
#endif
#endif

/* Routine proc_version */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_version
#if	defined(LINTLIBRARY)
    (process, which, data)
	pstruct_t process;
	int which;
	string_t data;
{ return proc_version(process, which, data); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	int which,
	string_t data
);
#else
    ();
#endif
#endif

/* Routine proc_getrusage */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getrusage
#if	defined(LINTLIBRARY)
    (process, pid, kind, rusage)
	pstruct_t process;
	pid_t pid;
	int kind;
	rusage_t *rusage;
{ return proc_getrusage(process, pid, kind, rusage); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t pid,
	int kind,
	rusage_t *rusage
);
#else
    ();
#endif
#endif

/* Routine proc_setpriority */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setpriority
#if	defined(LINTLIBRARY)
    (process, which, who, prio)
	pstruct_t process;
	int which;
	int who;
	int prio;
{ return proc_setpriority(process, which, who, prio); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	int which,
	int who,
	int prio
);
#else
    ();
#endif
#endif

/* Routine proc_getpriority */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getpriority
#if	defined(LINTLIBRARY)
    (process, which, who, prio)
	pstruct_t process;
	int which;
	int who;
	int *prio;
{ return proc_getpriority(process, which, who, prio); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	int which,
	int who,
	int *prio
);
#else
    ();
#endif
#endif

/* Routine proc_pid2task */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_pid2task
#if	defined(LINTLIBRARY)
    (process, pid, task)
	pstruct_t process;
	pid_t pid;
	mach_port_t *task;
{ return proc_pid2task(process, pid, task); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t pid,
	mach_port_t *task
);
#else
    ();
#endif
#endif

/* Routine proc_task2pid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_task2pid
#if	defined(LINTLIBRARY)
    (process, task, pid)
	pstruct_t process;
	mach_port_t task;
	pid_t *pid;
{ return proc_task2pid(process, task, pid); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	mach_port_t task,
	pid_t *pid
);
#else
    ();
#endif
#endif

/* Routine proc_task2proc */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_task2proc
#if	defined(LINTLIBRARY)
    (process, task, proc)
	pstruct_t process;
	mach_port_t task;
	mach_port_t *proc;
{ return proc_task2proc(process, task, proc); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	mach_port_t task,
	mach_port_t *proc
);
#else
    ();
#endif
#endif

/* Routine proc_getallprocs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getallprocs
#if	defined(LINTLIBRARY)
    (process, pidarray, pidarrayCnt)
	pstruct_t process;
	pidarray_t pidarray;
	mach_msg_type_number_t *pidarrayCnt;
{ return proc_getallprocs(process, pidarray, pidarrayCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pidarray_t pidarray,
	mach_msg_type_number_t *pidarrayCnt
);
#else
    ();
#endif
#endif

/* Routine proc_getprocinfo */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprocinfo
#if	defined(LINTLIBRARY)
    (process, which, procinfo, procinfoCnt)
	pstruct_t process;
	pid_t which;
	procinfo_t procinfo;
	mach_msg_type_number_t *procinfoCnt;
{ return proc_getprocinfo(process, which, procinfo, procinfoCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t which,
	procinfo_t procinfo,
	mach_msg_type_number_t *procinfoCnt
);
#else
    ();
#endif
#endif

/* Routine proc_getprocargs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprocargs
#if	defined(LINTLIBRARY)
    (process, which, nargs, procargs)
	pstruct_t process;
	pid_t which;
	int *nargs;
	string_t procargs;
{ return proc_getprocargs(process, which, nargs, procargs); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t which,
	int *nargs,
	string_t procargs
);
#else
    ();
#endif
#endif

/* Routine proc_getprocenv */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprocenv
#if	defined(LINTLIBRARY)
    (process, which, nargs, procenv)
	pstruct_t process;
	pid_t which;
	int *nargs;
	string_t procenv;
{ return proc_getprocenv(process, which, nargs, procenv); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	pid_t which,
	int *nargs,
	string_t procenv
);
#else
    ();
#endif
#endif

/* Routine proc_setprocargs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setprocargs
#if	defined(LINTLIBRARY)
    (process, argv, envp)
	pstruct_t process;
	int argv;
	int envp;
{ return proc_setprocargs(process, argv, envp); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	int argv,
	int envp
);
#else
    ();
#endif
#endif

/* Routine proc_setlogin */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setlogin
#if	defined(LINTLIBRARY)
    (process, logname)
	pstruct_t process;
	string_t logname;
{ return proc_setlogin(process, logname); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	string_t logname
);
#else
    ();
#endif
#endif

/* Routine proc_getlogin */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getlogin
#if	defined(LINTLIBRARY)
    (process, logname)
	pstruct_t process;
	string_t logname;
{ return proc_getlogin(process, logname); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	pstruct_t process,
	string_t logname
);
#else
    ();
#endif
#endif

#endif	_process_server_
