/* 
 * Mach Operating System
 * Copyright (c) 1992 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon 
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	db_interface.c,v $
 * Revision 2.6  92/01/03  20:31:01  dbg
 * 	Ignore RB_KDB - always enter DDB.
 * 	[91/11/06            dbg]
 * 
 * Revision 2.5  91/07/31  18:12:50  dbg
 * 	Stack switching support.
 * 	[91/07/12            dbg]
 * 
 * Revision 2.4  91/03/16  14:58:16  rpd
 * 	Replaced db_nofault with db_recover.
 * 	[91/03/14            rpd]
 * 
 * Revision 2.3  90/10/25  14:47:16  rwd
 * 	Added watchpoint support.
 * 	[90/10/16            rwd]
 * 
 * Revision 2.2  90/08/27  22:11:17  dbg
 * 	Reduce lint.
 * 	[90/08/07            dbg]
 * 	Created.
 * 	[90/07/25            dbg]
 * 
 */

/*
 * Interface to new debugger.
 */
#include <sys/reboot.h>

#include <sun3/pmap.h>
#include <sun3/thread.h>
#include <sun3/db_machdep.h>
#include <sun3/machparam.h>
#include <sun3/setjmp.h>

#include <mach/vm_param.h>
#include <mach/exception.h>

#include <kern/thread.h>

int	db_active = 0;

/*
 * Received keyboard interrupt sequence.
 */
kdb_kintr()
{
	if (db_active == 0) {

	    extern void softcall(), enter_kdb();
	    /*
	     * Schedule a software interrupt to get to KDB.
	     */
	    current_thread()->pcb->flag &= ~TRACE_AST;
	    current_thread()->pcb->flag |= TRACE_KDB;
	    softcall(enter_kdb, (char *)0);
	}
}

/*
 *  kdb_trap - field a TRACE or BPT trap
 */

extern jmp_buf_t *db_recover;

kdb_trap(type, regs)
	int	type;
	register struct mc68020_saved_state *regs;
{
    switch (type)
    {
	case T_TRACE:	/* single-step */
	case T_BRKPT:	/* breakpoint */
        case T_WATCHPOINT:
	    break;
	case EXC_BREAKPOINT:
	    type = T_BRKPT;
	    break;

	default:
	{
	    kdbprinttrap(type, 0);
	    if (db_recover != 0) {
		db_printf("Caught exception in ddb.\n");
		db_error("");
		/*NOTREACHED*/
	    }
	}
    }

    /*  Should switch to kdb's own stack here. */

    ddb_regs = *regs;

    db_active++;
    cnpollc(TRUE);
    (void) setvideoenable(1);

    db_trap(type, 0);

    cnpollc(FALSE);
    db_active--;

    *regs = ddb_regs;

    /*
     * Indicate that single_step is for KDB.
     * But lock out interrupts to prevent TRACE_KDB from setting the
     * trace bit in the current SR (and trapping while exiting KDB).
     */
    (void) spl7();
/*
    if (!USERMODE(regs->sr) && (regs->sr & SR_T1) && (current_thread())) {
	current_thread()->pcb->pcb_flag |= TRACE_KDB;
*/
    if ((regs->sr & SR_T1) && (current_thread())) {
	current_thread()->pcb->flag |= TRACE_KDB;
    }

    return(1);
}

extern char *	trap_type[];
extern int	TRAP_TYPES;

/*
 * Print trap reason.
 */
kdbprinttrap(type, code)
	int	type, code;
{
	printf("kernel: ");
	if (type >= TRAP_TYPES || type < 0)
	    printf("type %d", type);
	else
	    printf("%s", trap_type[type]);
	printf(" trap\n");
}

/*
 * Read bytes from kernel address space for debugger.
 */

extern jmp_buf_t	db_jmpbuf;

void
db_read_bytes(addr, size, data)
	vm_offset_t	addr;
	register int	size;
	register char	*data;
{
	register char	*src;

	src = (char *)addr;
	while (--size >= 0)
	    *data++ = *src++;
}

/*
 * Write bytes to kernel address space for debugger.
 */
void
db_write_bytes(addr, size, data)
	vm_offset_t	addr;
	register int	size;
	register char	*data;
{
	register char	*dst;

	int		oldmap0 = 0;
	int		oldmap1 = 0;
	vm_offset_t	addr1;
	extern char	etext;

	if (addr >= VM_MIN_KERNEL_ADDRESS &&
	    addr <= (vm_offset_t)&etext)
	{
	    oldmap0 = getpgmap(addr);
#ifdef	SUN3_260
	    vac_pageflush((char *)addr);
#endif
	    setpgmap(addr, (oldmap0 & ~PG_PROT) | PG_KW);

	    addr1 = sun_trunc_page(addr + size - 1);
	    if (sun_trunc_page(addr) != addr1) {
		/* data crosses a page boundary */

		oldmap1 = getpgmap(addr1);
#ifdef	SUN3_260
		vac_pageflush((char *)addr1);
#endif
		setpgmap(addr1, (oldmap1 & ~PG_PROT) | PG_KW);
	    }
	}

	dst = (char *)addr;

	while (--size >= 0)
	    *dst++ = *data++;

	if (oldmap0) {
#ifdef	SUN3_260
	    vac_pageflush((char *)addr);
#endif
	    setpgmap(addr, oldmap0);
	    if (oldmap1) {
#ifdef	SUN3_260
		vac_pageflush((char *)addr1);
#endif
		setpgmap(addr1, oldmap1);
	    }
	}
}

