/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#include "global.h"


/*
**	Function name : fillFolder
**
**	Description : Einlesen des gerade angewaehlten Directories
**	Input : Zeiger auf den Folder
**	Ouput : -
*/
void fillFolder (Folder_Glyph *folder)
{
	Dir_Glyph	*dir = folder->dir;
	char		s_buf[1024];
	String		dir_path;
	uid_t		uid = getuid();
	gid_t		gid = getgid();
	struct	dirent	*d_ent;
	DIR		*dir_ptr;

	/*
	 * Wenn der Folder bereits Eintraege enthaaelt, diese loeschen
	 */
	if (folder->file_count > 0) {
		int	i;

		for (i = 0; i < folder->file_count; i++)
			if (folder->file[i]) {
				if (folder->file[i]->name)
					free(folder->file[i]->name);
				free(folder->file[i]);
			}
		folder->file_count = 0;
	}
	folder->size = 0;
	/*
	 * Den vollstaendigen Pfadnamen holen
	 */
	dir_path = (String) getPath (dir);

	/*
	 * Das Dir oeffnen und die Eintraege auslesen
	 */
	if (!(dir->flags & DIR_READABLE) || !(dir_ptr = opendir (dir_path))) {
		dir->flags &= (~DIR_READABLE);
		return;		/* Abbruch da nicht geoeffnet */
	}

	/*
	 * Directory auslesen
	 */
	folder->total_count = 0;

	while ((d_ent = readdir(dir_ptr))) {
		struct stat	buf;

		/*
		 * Den vollen Pfadnamen des Direntries erzeugen
		 */
		folder->total_count++;
		sprintf (s_buf,"%s%s%s\0", dir_path,
					   (dir_path[1] == '\0' ? "" : "/"),
					   d_ent->d_name);
		/*
		 * Den Status des Files holen
		 */
		(void) lstat (s_buf, &buf);
		folder->size += buf.st_size;

		/*
		 * Ueberpruefen ob der Eintrag ein Directory und nicht . oder .. ist
		 */
		if (strcmp(d_ent->d_name,".") &&
		    (strcmp(d_ent->d_name,"..") || (dir != &root && !defaults.multi_window)) &&
		     (!folder->filter || ifFilter(folder,d_ent->d_name))) {
			/*
			 * Da dir, Dir_Glyph um einen Eintrag erweitern
			 */
			File_Glyph	*new_file;

			/*
			 * Liste im Glyph um einen Eintrag erweitern
			 */
			(folder->file_count)++;
			if (!folder->file) {
				if (!(folder->file = (File_Glyph **) malloc (sizeof(File_Glyph *))))
					FATAL_ERROR ("fillFolder: allocating Filelist failed\n");
			}
			else {
				if (!(folder->file = (File_Glyph **) realloc ((void *) folder->file,
									sizeof(File_Glyph *)*folder->file_count)))
					FATAL_ERROR ("fillFolder: Reallocating Filelist failed\n");
			}
			if (!(new_file = (File_Glyph *) malloc(sizeof(File_Glyph))))
				FATAL_ERROR ("fillFolder: Allocating new Glyph failed\n");

			/*
			 * Den neuen Glyph als leer initialisieren
			 */
			new_file->uid = buf.st_uid;
			new_file->gid = buf.st_gid;
			new_file->mode = buf.st_mode;
			new_file->size = buf.st_size;

			/*
			 * Den Namen des Glyphs initialisieren
			 */
			if (!(new_file->name = (String) malloc(strlen(d_ent->d_name)+1)))
				FATAL_ERROR ("fillFolder: Allocating Name for new Glyph failed\n");
			strncpy(new_file->name,d_ent->d_name,strlen(d_ent->d_name));
			new_file->name[strlen(d_ent->d_name)] = '\0';

			/*
			 * Den Filetype feststellen
			 */
			if (uid != 0 &&
			    !((uid == buf.st_uid && S_IRUSR&buf.st_mode) |
			      (gid == buf.st_gid && S_IRGRP&buf.st_mode) | 
			       S_IROTH&buf.st_mode))
				new_file->prog_type = FILE_LOCK;
			else if (!(strcmp(d_ent->d_name,"..")))
				new_file->prog_type = FILE_ROOT;
			else if (S_ISLNK(buf.st_mode)) {
				struct stat	lbuf;

				stat (s_buf,&lbuf);
				if (S_ISDIR(lbuf.st_mode))
					new_file->prog_type = FILE_LDIR;
				else
					new_file->prog_type = FILE_LINK;
			}
			else if (S_ISDIR(buf.st_mode))
				new_file->prog_type = FILE_DIR;
 			else if ((uid == buf.st_uid  && S_IXUSR&buf.st_mode) |
				 (gid == buf.st_gid  && S_IXGRP&buf.st_mode) | 
				  S_IXOTH&buf.st_mode)
				new_file->prog_type = FILE_EXEC;
			else if (buf.st_size == 0)
				new_file->prog_type = FILE_GHOST;
 			else if (!tryCommands(new_file))
				new_file->prog_type = FILE_PLAIN;

			folder->file[folder->file_count-1] = new_file;
		}
	}
	closedir (dir_ptr);

	/*
	 * Die Directoryeintraege aplhabetisch sortieren falls moeglich
	 */
	if (folder->file_count > 1) {
		int	i, j;

		for (i = 0; i < folder->file_count - 1; i++) {
			for (j = 1; j < folder->file_count - i; j++) {
				if (compareFGlyph(folder->file[j-1],folder->file[j]) == 1) {
					File_Glyph *dummy = folder->file[j];

					folder->file[j] = folder->file[j-1];
					folder->file[j-1] = dummy;
				}
			}
		}
	}
	free (dir_path);

	/*
	 * Infofeld setzen
	 */
	{	Arg	args[1];
		char	s[100];

		sprintf(s,strings[94],	folder->file_count,
					folder->total_count - folder->file_count,
					folder->size/1024);
		XtSetArg(args[0],XtNlabel,s);
		XtSetValues(folder->info,args,1);
	}
}

/*
**	Function name : compareFGlyph
**
**	Description : Vergleichsfunktion fuer QSort 
**	Input : die zwei obligatorischen Zeiger auf die Elemente
**	Ouput : -1 falls a < b, 0 fall a == b oder 1 fall a > b
*/
int compareFGlyph (File_Glyph *da, File_Glyph *db)
{
	int	i;
	char	*a = da->name,
		*b = db->name;

	if (da->prog_type > 150 || db->prog_type > 150) {
		if (da->prog_type < db->prog_type)
			return(1);
		else if (da->prog_type > db->prog_type)
			return(-1);
	}

	i = (strlen(a) > strlen(b) ? strlen(b) : strlen(a));
	while (i--) {
		if (*a > *b) {
			return(1);
		}
		else if (*a < *b) {
			return(-1);
		}
		a++;
		b++;
	}
	if (strlen(da->name) > strlen(db->name)) {
		return(1);
	}
	if (strlen(da->name) < strlen(db->name)) {
		return(-1);
	}
	return(0);
}

/*
**	Function name : showFolder
**
**	Description : Anzeigen der Files des derzeitigen Dirs
**	Input : Zeiger auf das Fensterwidget und den Dir_glyph
**	Ouput : Liefert den Y-Wert des letzen Dir-Glyphs im Baum zurueck
*/
void showFolder (Widget window, Folder_Glyph *folder,
		   Dimension x, Dimension y,
		   Dimension *lx, Dimension *ly,
		   Dimension hs, Dimension he)
{
	int	i;
	Boolean	b;

	/*
	 * Wenn in dem Folder Files sind, dann auflisten
	 */
	if (folder->file_count > 0) {
		*lx = 10;
		for (i = 0; i < folder->file_count; i++) {
			if (XTextWidth(defaults.icon_font,folder->file[i]->name,
				strlen(folder->file[i]->name)) > *lx)
				*lx = XTextWidth(defaults.icon_font,folder->file[i]->name,
					strlen(folder->file[i]->name));
		}

		/*
		 * Fileicon und Label ausgeben
		 */
		*lx += 3*DIR_X_STEP + 50;
		folder->max_length = *lx;

		for (i = hs; i <= he; i++) {
			b = (i == selc_f && folder == selc_fo ? TRUE : FALSE);
			drawFile (folder, i, b,b);
		}
	}
	*ly = y + folder->file_count*DIR_Y_STEP + 14;
}


/*********************************************************
 * name:	tryCommand
 * description:	versuchen anhand der suffixliste den Filetyp
 *		heraus zu finden
 * input:	Zeiger auf den File_Gyph
 * output:	1 wenn gefunden, sonst 0
 * date:	
 *********************************************************/
int	tryCommands (File_Glyph *file)
{	int	suf;

	suf = 0;
	if (strrstr(file->name,".tar.z\0") || strrstr(file->name,".tar.gz\0")
		 || strrstr(file->name,".tar.Z\0") || strrstr(file->name,",taz\0")
		 || strrstr(file->name,".tpz\0") || strrstr(file->name,".tgz\0")) {
		file->prog_type = FILE_CTAR;
		return(1);
	}
	if (strrstr(file->name,".tar\0")) {
		file->prog_type = FILE_TAR;
		return(1);
	}

	while (filetypes[suf].cmd) {
		char	*a = filetypes[suf].suffix, *b;
		char	buf[30];
		int	i;

		if (!a) {
			file->prog_type = filetypes[suf].type;
			return(1);
		}
		do {
			b = strchr(a,',');
			if (b)
				i = strlen(a) - strlen(b);
			else
				i = strlen(a);
			strncpy(buf,a,i);
			buf[i] = '\0';
			a = b+1;

			i = strlen(file->name) - strlen(buf);
			if (i >= 0) {
				if (!(strncmp(&file->name[i],buf,
						strlen(buf)))) {
					file->prog_type = suf;
					return(1);
				}
			}
		} while (b);
		suf++;
	}
	return(0);
}



/*********************************************************
 * name:	ifFilter
 * description:	Filenamefilteringfunction. Dient zum Bewerten
 *		von Filenamenunter Beruecksichtigung des
 *		Filterstrings im Folder_Glyph
 * input:	Folger_Glyph	*folder	- der Folder
 *		char		*file	- filename
 * output:	Boolean	True, wenn file zum Filter passt,
 *		sonst FALSE
 * author:	Ove Kalkan
 * date:	1.7.1993
 *********************************************************/
Boolean	ifFilter (Folder_Glyph *folder, char *file)
{
	int	i = strlen(folder->filter);

	if (!strcmp(folder->filter,"*") || !strlen(folder->filter) ||
	    !folder->filter) {
		folder->filter = NULL;
		return(TRUE);
	}
	if (!strcmp(file,".."))
		return(TRUE);
	if (folder->filter[0] == '*') {	/* Joker am Anfang */
		if (folder->filter[i-1] == '*') {	/* Joker am Ende */
			if (strlen(file) < i - 2)
				return(FALSE);
		}
		else {
			if (strlen(file) < i - 1)
				return(FALSE);
			if (strncmp(&file[strlen(file) - i + 1],&folder->filter[1],i-1))
				return(FALSE);
		}
	}
	else {
		if (folder->filter[i-1] == '*') {	/* Joker am Ende */
			if (strlen(file) < i - 1)
				return(FALSE);
			if (strncmp(file,folder->filter,i-1))
				return(FALSE);
		}
		else {	/* keine Joker */
			if (strcmp(folder->filter,file))
				return(FALSE);
		}
	}
	return(TRUE);
}
