/* Copyright (C) 2002, 2003 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __PUBLIC_H__
#define __PUBLIC_H__

#include <pwd.h>
#include <grp.h>
#include <shadow.h>
#include <rpc/types.h>

enum service_t {S_NONE, S_LOCAL, S_YP, S_NISPLUS, S_LDAP};
typedef enum service_t service_t;

struct user_t {
  char *pwdbuffer;
  size_t pwdbuflen;
  struct passwd pw;
  char *spwbuffer;
  size_t spwbuflen;
  struct spwd sp;
  int use_shadow;
  enum service_t service;
  char *newpassword;
  char *oldclearpwd;
  char *new_shell;
  char *new_gecos;
  int sp_changed;
  struct spwd spn;
  char *binddn;
};
typedef struct user_t user_t;

extern int npd_upd_pwd (const char *domainname, user_t *data);
extern char *get_value (const char *oldf, const char *prompt);
extern char *getnismaster (void);
extern void free_user_t (user_t *data);
extern user_t *do_getpwnam (const char *user, const char *use_service);
extern int do_setpwnam (user_t *data);
extern const char *nsw2str (service_t service);
extern int nscd_flush_cache (const char *service);
extern int do_authentication (const char *prog, const char *caller,
			      user_t *pw_data, int need_password);

#endif /* __PUBLIC_H__ */
