#include <midi.h>
#include <mpuvar.h>
#include <ctype.h>

#define d define
#d u_char	unsigned char
#d u_short	unsigned short

#d Upper(c) islower(c)? toupper(c) : c

dx7PutVoiceName(midi, channel, name)
	int midi;	/* file descriptor of midi device */
	char channel;	/* midi channel (0 -> ch 1) */
	char *name;	/* voice name */
/*
 * Write the 'name' into the voice in the dx7.
 * Pads it with spaces if nec., to fill out the 10 character name width.
 * See 'dx7PutParameter()', 'dx7PutVoice()'.
 */
{
	int i = 145;
	if (!name) name = "(null)";
	while (i<=155){
		dx7PutParameter(midi,channel,0,i,*name? Upper(*name):' ');
		if (*name) ++name;
		++i;
	}
}
