BEGIN	{
	n[840] = "w.."
	n[720] = "w."
	n[480] = "w"
	n[420] = "h.."
	n[360] = "h."
	n[320] = "wt"
	n[240] = "h"
	n[210] = "q.."
	n[180] = "q."
	n[160] = "ht"
	n[150] = "q+s"
	n[120] = "q"
	n[105] = "e.."
	n[ 90] = "e."
	n[ 80] = "qt"
	n[ 75] = "e+t"
	n[ 60] = "e"
	n[ 53] = "s.."
	n[ 52] = "s.."
	n[ 45] = "s."
	n[ 40] = "et"
	n[ 38] = "s+f"
	n[ 37] = "s+f"
	n[ 30] = "s"
	n[ 26] = "t.."
	n[ 23] = "t."
	n[ 22] = "t."
	n[ 20] = "st"
	n[ 15] = "t"
	n[ 13] = "f.."
	n[ 11] = "f."
	n[ 10] = "tt"
	n[  8] = "f"
	n[  7] = "f"
	n[  5] = "ft"
}
	{
	for (tf = NF; tf > 0 && $tf != ";"; --tf);
	if (tf) {
		tf++
		t = $tf
	}
}
/on/	{
	if (tf < 5 || tf > 6) {
		print "   unrecognized ON format; line" NR
		next
	}
	k = $(NF-2)
	if (ontime[k] > 0) {
		printf "%6.3f  %-4s   multiple key-on\n", t/120., k
		next
	}
	ontime[k] = t+1
	vel[k] = $(NF-3)
	if (t > lastoff) {
		b = lastoff / 120.
		dur = t - lastoff
		printf "%6.3f   R   %3d %-3s\n", b, dur, n[dur]
		lastoff = 99999
	}
	ko[numon++] = k
	next
}
/off/	{
	if (tf < 5 || tf > 6) {
		print "   unrecognized OFF format; line" NR
		next
	}
	k = $(NF-2)
	if (ontime[k] == 0) {
		printf "%6.3f  %-4s   extra key-off\n", t/120., k
		next
	}
	b = (ontime[k] - 1.) / 120.
	dur = t - ontime[k] + 1
	printf "%6.3f  %-4s %3d %-3s %s\n", b, k, dur, n[dur], vel[k]
	ontime[k] = 0
	lastoff = t
	--numon
	next
}
/tcip/ || /tcwme/	{
	if (tf < 3 || tf > 4)
		print "   unrecognized ON format; line" NR
	next
}
	{
	print $0
}

END	{
	if (tf && t > lastoff) {
		b = lastoff / 120.
		dur = t - lastoff
		printf "%6.3f   R   %3d %-3s\n", b, dur, n[dur]
		lastoff = 99999
	}
	if (numon > 0) {
		printf "oops, %d note(s) left on\n", numon
		while (--numon >= 0) {
			k = ko[numon]
			b = (ontime[k] - 1.) / 120.
			printf "%6.3f  %-4s         %s\n", b, k, vel[k]
		}
	}
}
