/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.sql.rowset.serial.SQLInputImpl;
import javax.sql.rowset.serial.SerialDatalink;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockArray;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockBlob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockClob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockRef;
import org.apache.harmony.sql.tests.javax.sql.rowset.serial.SQLInputImplTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SQLInputImplTest
extends TestCase {
    public void test_Constructor() {
        try {
            new SQLInputImpl(null, new HashMap());
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            new SQLInputImpl(null, null);
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            new SQLInputImpl(new Object[0], null);
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testReadArray() throws SQLException {
        MockArray array = new MockArray();
        Object[] attributes = new Object[]{array};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)array, (Object)impl.readArray());
        try {
            impl.readArray();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readArray());
    }

    public void testReadAsciiStream() throws SQLException {
        ByteArrayInputStream stream = new ByteArrayInputStream("abc".getBytes());
        Object[] attributes = new Object[]{stream};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)stream, (Object)impl.readAsciiStream());
        try {
            impl.readAsciiStream();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readAsciiStream());
    }

    public void testReadBigDecimal() throws SQLException {
        BigDecimal bd = new BigDecimal("12.5");
        Object[] attributes = new Object[]{bd};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)bd, (Object)impl.readBigDecimal());
        try {
            impl.readBigDecimal();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readBigDecimal());
    }

    public void testReadBinaryStream() throws SQLException {
        ByteArrayInputStream stream = new ByteArrayInputStream("abc".getBytes());
        Object[] attributes = new Object[]{stream};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)stream, (Object)impl.readBinaryStream());
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readBinaryStream());
    }

    public void testReadBlob() throws SQLException {
        MockBlob blob = new MockBlob();
        Object[] attributes = new Object[]{blob};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)blob, (Object)impl.readBlob());
        try {
            impl.readBlob();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readBlob());
    }

    public void testReadBoolean() throws SQLException {
        Object[] attributes = new Object[]{Boolean.TRUE};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((boolean)true, (boolean)impl.readBoolean());
        try {
            impl.readBoolean();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertFalse((boolean)impl.readBoolean());
    }

    public void testReadByte() throws SQLException {
        Object[] attributes = new Object[]{Byte.valueOf("3")};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((byte)3, (byte)impl.readByte());
        try {
            impl.readByte();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((byte)0, (byte)impl.readByte());
    }

    public void testReadBytes() throws SQLException {
        byte[] bytes = new byte[]{1, 2, 3};
        Object[] attributes = new Object[]{bytes};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)bytes, (Object)impl.readBytes());
        try {
            impl.readBytes();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readBytes());
    }

    public void testReadCharacterStream() throws SQLException {
        StringReader stream = new StringReader("abc");
        Object[] attributes = new Object[]{stream};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)stream, (Object)impl.readCharacterStream());
        try {
            impl.readCharacterStream();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readCharacterStream());
    }

    public void testReadClob() throws SQLException {
        MockClob clob = new MockClob();
        Object[] attributes = new Object[]{clob};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)clob, (Object)impl.readClob());
        try {
            impl.readClob();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readClob());
    }

    public void testReadDate() throws SQLException {
        Date date = new Date(12L);
        Object[] attributes = new Object[]{date};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)date, (Object)impl.readDate());
        try {
            impl.readDate();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readDate());
    }

    public void testReadDouble() throws SQLException {
        Object[] attributes = new Object[]{Double.valueOf("3")};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)new Double(3.0), (Object)new Double(impl.readDouble()));
        try {
            impl.readDouble();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((double)0.0, (double)impl.readDouble(), (double)0.0);
    }

    public void testReadFloat() throws SQLException {
        Object[] attributes = new Object[]{Float.valueOf("3.5")};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)new Float(3.5f), (Object)new Float(impl.readFloat()));
        try {
            impl.readFloat();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((float)0.0f, (float)impl.readFloat(), (float)0.0f);
    }

    public void testReadInt() throws SQLException {
        Object[] attributes = new Object[]{Integer.valueOf("3")};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((int)3, (int)impl.readInt());
        try {
            impl.readInt();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((int)0, (int)impl.readInt());
    }

    public void testReadLong() throws SQLException {
        Object[] attributes = new Object[]{Long.valueOf("3")};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((long)3L, (long)impl.readLong());
        try {
            impl.readLong();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((long)0L, (long)impl.readLong());
    }

    public void testReadObject() throws SQLException {
        Class<?> clazz;
        Object[] structAttributes = new Object[]{"hello", Boolean.TRUE, "abc", 99};
        MockStruct struct = new MockStruct(structAttributes, "harmonytests.MockSQLData");
        MockStruct struct2 = new MockStruct(structAttributes, "not stored name");
        HashMap types = new HashMap();
        try {
            clazz = Class.forName("org.apache.harmony.sql.tests.javax.sql.rowset.serial.SQLInputImplTest$MockSQLData");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        types.put("harmonytests.MockSQLData", clazz);
        Object[] objectArray = new Object[4];
        objectArray[0] = struct;
        objectArray[1] = struct2;
        objectArray[3] = "xyz";
        Object[] attributes = objectArray;
        SQLInputImpl impl = new SQLInputImpl(attributes, types);
        Object obj = impl.readObject();
        SQLInputImplTest.assertTrue((boolean)(obj instanceof MockSQLData));
        MockSQLData sqlData = (MockSQLData)obj;
        SQLInputImplTest.assertEquals((Object)structAttributes[0], (Object)sqlData.firstAttribute);
        SQLInputImplTest.assertEquals((Object)structAttributes[1], (Object)sqlData.secondAttribute);
        SQLInputImplTest.assertEquals((Object)structAttributes[2], (Object)sqlData.thirdAttribute);
        SQLInputImplTest.assertEquals((Object)structAttributes[3], (Object)sqlData.fourthAttribute);
        Object obj2 = impl.readObject();
        SQLInputImplTest.assertEquals((Object)struct2, (Object)obj2);
        Object obj3 = impl.readObject();
        SQLInputImplTest.assertNull((Object)obj3);
        Object obj4 = impl.readObject();
        SQLInputImplTest.assertEquals((Object)attributes[3], (Object)obj4);
    }

    public void testReadRef() throws SQLException {
        MockRef ref = new MockRef();
        Object[] attributes = new Object[]{ref};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)ref, (Object)impl.readRef());
        try {
            impl.readRef();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readRef());
    }

    public void testReadShort() throws SQLException {
        Object[] attributes = new Object[]{Short.valueOf("3")};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((short)3, (short)impl.readShort());
        try {
            impl.readShort();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((short)0, (short)impl.readShort());
    }

    public void testReadString() throws SQLException {
        Object[] attributes = new Object[]{"hello"};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((String)"hello", (String)impl.readString());
        try {
            impl.readString();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readString());
    }

    public void testReadTime() throws SQLException {
        Time time = new Time(345L);
        Object[] attributes = new Object[]{time};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)time, (Object)impl.readTime());
        try {
            impl.readTime();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        attributes = new Object[1];
        impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertNull((Object)impl.readTime());
    }

    public void testReadTimestamp() throws SQLException {
        Timestamp time = new Timestamp(345L);
        Object[] attributes = new Object[]{time};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertEquals((Object)time, (Object)impl.readTimestamp());
        try {
            impl.readTimestamp();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testReadURL() throws SQLException, MalformedURLException {
        URL url = new URL("http://www.apache.org");
        SerialDatalink link = new SerialDatalink(url);
        Object[] attributes = new Object[]{link};
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        try {
            impl.readURL();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            impl.readURL();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testWasNull() throws SQLException {
        Object[] objectArray = new Object[2];
        objectArray[1] = "hello";
        Object[] attributes = objectArray;
        SQLInputImpl impl = new SQLInputImpl(attributes, new HashMap());
        SQLInputImplTest.assertFalse((boolean)impl.wasNull());
        SQLInputImplTest.assertEquals(null, (String)impl.readString());
        SQLInputImplTest.assertTrue((boolean)impl.wasNull());
        SQLInputImplTest.assertEquals((String)"hello", (String)impl.readString());
        SQLInputImplTest.assertFalse((boolean)impl.wasNull());
        try {
            impl.readString();
            SQLInputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        SQLInputImplTest.assertFalse((boolean)impl.wasNull());
        SQLInputImplTest.assertFalse((boolean)impl.wasNull());
    }
}

