/*
 *  linux/include/asm-arm/arch-ep93xx/uncompress.h
 *
 *  Copyright (C) 1999 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <asm/io.h>
#include <asm/hardware.h>

#ifdef CONFIG_MACH_IPD
#define BAUDRATE ((14745600/(16 * 115200)) - 1)
#define UART(reg)	UART2##reg
#define ENABLEBIT SYSCON_DEVCFG_U2EN
#define TICKLE() (* (volatile unsigned char *) 0x20000000)
#endif

#ifndef TICKLE
#define TICKLE()
#endif

#ifndef BAUDRATE
#define BAUDRATE ((14745600/(16 * 57600)) - 1)
#endif

#ifndef UART
#define UART(reg)	UART1##reg
#define ENABLEBIT SYSCON_DEVCFG_U1EN
#endif

static void puts(const char *s)
{
    while (*s)
    {
	    while(*HW_REG(UART(FR)) & UARTFR_BUSY );

        *HW_REG(UART(DR)) = *s;
        
	    if (*s == '\n')
        {
	        while (*HW_REG(UART(FR)) & UARTFR_BUSY);
	    
            *HW_REG(UART(DR)) = '\r';
	    }
	    s++;
    }
    while(*HW_REG(UART(FR)) & UARTFR_BUSY);
	TICKLE();
}

static void EnableUart(void)
{
    //
    // Ensure that the base clock to the UARTS is 14.7456Mhz
    // and that UART is enabled.
    //
    *HW_REG(SYSCON_PWRCNT) = SYSCON_PWRCNT_UARTBAUD;

    *HW_REG(SYSCON_SWLOCK) = 0xaa;
    *HW_REG(SYSCON_DEVCFG) |= SYSCON_DEVCFG_U1EN;

    //
    // Disable the UARTS and clear out the old settings.
    //
#if UART(MCR)
    *HW_REG(UART(MCR)) = 0;
#endif
    *HW_REG(UART(CR)) = 0;
    *HW_REG(UART(RSR)) = 0;
    *HW_REG(UART(CR_L)) = 0;
    *HW_REG(UART(CR_M)) = 0;
    *HW_REG(UART(CR_H)) = 0;

    //
    // Set the baud rate and framing
    //
    *HW_REG(UART(CR_L)) = (BAUDRATE & 0x0FF);
    *HW_REG(UART(CR_M)) = ((BAUDRATE >> 8) & 0x0FF);

    //
    // 8 Data bits, No Parity, 1 Stop bit.
    //
    *HW_REG(UART(CR_H)) = (UARTLCR_H_WLEN_8_DATA | UARTLCR_H_FEN);

    //
    // Enable Uart
    //
    *HW_REG(UART(CR)) = UARTCR_UARTE;
}

//
// Called early before the UART is used for output by the compressed loader.
//
static void arch_decomp_setup()
{
    EnableUart();
}

#define arch_decomp_wdog()
