/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   g_event.h
*   
* Abstract:
*   
*
* Authors:
*   TLR - Theodore L. Ross
*
* Modification History:
*   Date       Name  Description 
*   10-May-95  TLR   Created.
*   16-May-95  DMW   Added OPPO module.
*
* Description:
* 
*/

#ifndef G_EVENT_H
#define G_EVENT_H
/* Module ID Values */

#include <stdio.h>

#include "g_types.h"

#define MOD_CM          101
#define MOD_SIG         102
#define MOD_LEC_DATA    103
#define MOD_LEC_CTRL    104
#define MOD_LEC_ARP     105
#define MOD_UP_DRV      106
#define MOD_LO_DRV      107
#define MOD_INIT        108
#define MOD_ILMI_IO     109
#define MOD_ADDR_REG    110
#define MOD_LINE_UP     111
#define MOD_SNMP        112
#define MOD_MIB_II      113
#define MOD_ILMI_MIB    114
#define MOD_DEC_MIB     115
#define MOD_UTL_OS      116
#define MOD_DIAG        117
#define MOD_FLOW        118
#define MOD_OAM         119
#define MOD_ATMIP       120
#define MOD_ATMARP      121
#define MOD_OPPO        122
#define MOD_CLIP        123
#define MOD_TASK        124

/* Event Type Mask Values */

#define EM_SERR      0x00000001  /* Severe Error               */
#define EM_NERR      0x00000002  /* Normal Error               */
#define EM_WARN      0x00000004  /* Warning                    */
#define EM_ASSERT    0x00000008  /* Assertion Failure          */
#define EM_TRAN      0x00000010  /* State Transition           */
#define EM_EVENT     0x00000020  /* Normal Event               */
#define EM_RCTRL     0x00000040  /* Received Control Frame     */
#define EM_XCTRL     0x00000080  /* Transmitted Control Frame  */
#define EM_RDATA     0x00000100  /* Received Data Frame        */
#define EM_XDATA     0x00000200  /* Transmitted Data Frame     */
#define EM_TRACE     0x00000400  /* Code path trace            */
#define EM_TIMER     0x00000800  /* Timer Events               */
#define EM_MEM       0x00001000  /* Memory Management Events   */
#define EM_MSG       0x00002000  /* Message Events             */
#define EM_DEBUG     0x00004000  /* Debugging messages         */

#define EM_DEFAULT    (EM_SERR | EM_NERR | EM_ASSERT)

#define EVENT(mask, text)                                                \
   if (EMASK & mask)                                                     \
      {                                                                  \
      printf ("%s %s '%s': ", emodtext (EMOD), emasktext (mask), EINST); \
      printf text;                                                       \
      }

/* Each module must do the following:  (CM Example provided)
 *
 *    #define EMOD  MOD_CM
 *    #define EINST p_cm->p_text
 *    #define EMASK p_cm->event_mask
 *
 * example event:
 *
 *    event (type_mask, ("Event Text %d %s", var1, str1))
 */

/* The following are function prototypes for value-to-text conversion
 * routines that are used to display events.
 */
const char *emodtext  (UINT16 mod);
const char *emasktext (UINT32 mask);

#endif /* G_EVENT_H */
