# Mailinglist rules

This is the first file you should be reading before doing any posts on PHP
mailinglists. Following these rules is considered imperative to the success of
the PHP project. Therefore expect your contributions to be of much less positive
impact if you do not follow these rules. More importantly you can actually
assume that not following these rules will hurt the PHP project.

PHP is developed through the efforts of a large number of people.
Collaboration is a Good Thing(tm), and mailinglists lets us do this. Thus,
following some basic rules with regards to mailinglist usage will:

   a. Make everybody happier, especially those responsible for developing PHP
      itself.

   b. Help in making sure we all use our time more efficiently.

   c. Prevent you from making a fool of yourself in public.

   d. Increase the general level of good will on planet Earth.

Having said that, here are the organizational rules:

   1. Respect other people working on the project.

   2. Do not post when you are angry. Any post can wait a few hours. Review
      your post after a good breather or a good nights sleep.

   3. Make sure you pick the right mailinglist for your posting. Please review
      the descriptions on the
      [mailinglist overview page](https://www.php.net/mailing-lists.php). When
      in doubt ask a friend or someone you trust on IRC.

   4. Make sure you know what you are talking about. PHP is a very large project
      that strives to be very open. The flip side is that the core developers
      are faced with a lot of requests. Make sure that you have done your
      research before posting to the entire developer community.

   5. Patches have a much greater chance of acceptance than just asking the
      PHP developers to implement a feature for you. For one it makes the
      discussion more concrete and it shows that the poster put thought and time
      into the request.

   6. If you are posting to an existing thread, make sure that you know what
      previous posters have said. This is even more important the longer the
      thread is already.

   7. Please configure your email client to use a real name and keep message
      signatures to a maximum of 2 lines if at all necessary.

The next few rules are more some general hints:

   1. If you notice that your posting ratio is much higher than that of other
      people, double check the above rules. Try to wait a bit longer before
      sending your replies to give other people more time to digest your answers
      and more importantly give you the opportunity to make sure that you
      aggregate your current position into a single mail instead of multiple
      ones.

   2. Consider taking a step back from a very active thread now and then. Maybe
      talking to some friends and fellow developers will help in understanding
      the other opinions better.

   3. Do not top post. Place your answer underneath anyone you wish to quote
      and remove any previous comment that is not relevant to your post.

   4. Do not high-jack threads, by bringing up entirely new topics. Please
      create an entirely new thread copying anything you wish to quote into the
      new thread.

Finally, additional hints on how to behave inside the virtual community can be
found in [RFC 1855](http://www.faqs.org/rfcs/rfc1855.html).

Happy hacking,

PHP Team
