#ifndef KAB3PART_H
#define KAB3PART_H

#include <kparts/part.h>
#include <kabc/addressbook.h>
#include <kabc/resource.h>

class QWidget;
class QPainter;
class KURL;
class Kab3MainWidget;
class KAboutData;
class KConfig;
class KAction;

/**
   This part is used to display KDE address book files, which are in
   turn vcard files.

   * @short KAB MkIII part
   * @author Mirko Boehm <mirko@kde.org>
   * @version 3.0
   */
class kab3Part : public KParts::ReadWritePart
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
    kab3Part(QWidget *parentWidget, const char *widgetName,
             QObject *parent, const char *name, const QStringList &args);

    /**
     * Destructor
     */
    virtual ~kab3Part();

    virtual void setReadWrite(bool rw);

    virtual void setModified(bool modified);

    static KAboutData *createAboutData();

protected:
    /**
     * This must be implemented by each part
     */
    virtual bool openFile();

    /**
     * This must be implemented by each read-write part
     */
    virtual bool saveFile();
    /** Initialize the session config object at first start. */
    virtual void initConfiguration(KConfig*);
protected slots:
    void fileOpen();
    void fileSaveAs();
    /** Open the standard address book. */
    void openStdAddressbook();
    /** This is used to catch modifications to the database by the
        part itselfes.
    */
    void slotModified();
protected:
    /** The main widget.
        The main widget contains the basic view elements, the overview
        list and the detailled view, and some buttons.
    */
    Kab3MainWidget *m_widget;
    /** The interface to the address book.
     */
    KABC::AddressBook *m_ab;
    /** The address book resource. */
    KABC::Resource *m_resource;
    /** Action to open the standard address book. */
    KAction *actionOpenStdAddressBook;
};

#endif // KAB3PART_H
