/***************************************************************************
                          kcontroldoc.h  -  description
                             -------------------
    begin                : Sat May 26 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONTROLDOC_H
#define KCONTROLDOC_H

#include "fileread.h"

#include <qwidget.h>
#include <kmainwindow.h>

#include <klistbox.h>
#include <kaction.h>
#include <kstdaction.h>

#include <qpushbutton.h>
#include <qtextview.h>
#include <qsplitter.h>

/**Main control documents
  *@author Javier Campos
  */

class kcontroldoc : public KMainWindow  {
   Q_OBJECT
public: 
	kcontroldoc(QWidget* parent=0, const char *name=0, WFlags f = WType_TopLevel | WDestructiveClose);
	~kcontroldoc();
private: // Private methods
  /** Init graphical interface */
  void init();
  /** Init menu bar settings */
  void initMenuBar();
  /** Write settings */
  void configWrite();
  /** Read config data */
  void configRead();
  /** Check if the current document can save */
  bool checkSave();
private: // Private attributes
	/** KEDUCA file */
	FileRead *KEDUCA;
  /** Recent files */
  KRecentFilesAction *recentFiles;
  /** List of answers */
  KListBox *list_answer;
  /** Preview */
  QTextView *preview;
  /** Main splitter */
  QSplitter *split;
  /** I open a file */
  bool isOpenFile;
private slots: // Private slots
  /** Delete current document and start new */
  void slotFileOpenNew();
  /** Open new document. */
  void slotFileOpen();
  /** Open new file */
  void slotFileOpenURL( const KURL &url );
  /** Item select */
  void slotPreview( QListBoxItem *item );
  /** Close the window */
  bool queryClose();
  /** Edit question */
  void slotEdit();
  /** Add question */
  void slotAdd();
  /** Remove question */
  void slotRemove();
  /** Down record */
  void slotDown();
  /** Up record */
  void slotUp();
  /** Save As... */
  void slotFileSaveAs();
  /** Save file */
  void slotFileSave();
  /** Print file */
  void slotFilePrint();
  /** Header info */
  void slotHeader();
  /** Configure toolbar */
  void slotConfigureToolbar();
  /** Configure keys */
  void slotConfigureKeys();
  /** Toggle toolbar */
  void slotToggleToolBar();
};

#endif
