/***************************************************************************
                            FMOut.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef FMOUT_H
#define FMOUT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/MidiOut.h>

/**

 FM device output class . FMOut is used to send MIDI events to 
 FM devices, such as AdLib cards, or OPL3 synthesizers.

 FMOut inherits @ref MidiOut and supports the same simple API.

 The preferred way to use this class is by selecting a FM device
 on the @ref MidiManager and using a @ref MidiManager object directly

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to FM devices.
*/
@interface FMOut : MidiOut 

/** 
 Constructor. See @ref -[MidiOut MidiOut] for more information.
     
*/
- initWithInt: (int)d total: (int)total;
- init;

/** 
 Destructor. 
     
*/
- (void) dealloc;

/** 
 See @ref -[MidiOut openDev]
     
*/
- openDev: (int)sqfd;

/** 
 See @ref -[MidiOut closeDev]
     
*/
- closeDev;

/** 
 See @ref -[MidiOut initDev]
     
*/
- initDev;

/** 
 See @ref -[MidiOut noteOn]
     
*/
- noteOn: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut noteOff]
     
*/
- noteOff: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut keyPressure]
     
*/
- keyPressure: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut chnPatchChange]
     
*/
- chnPatchChange: (unsigned char)chn patch: (unsigned char)patch;

/** 
 See @ref -[MidiOut chnPressure]
     
*/
- chnPressure: (unsigned char)chn vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut chnPitchBender]
     
*/
- chnPitchBender: (unsigned char)chn lsb: (unsigned char)lsb msb: (unsigned char)msb;

/** 
 See @ref -[MidiOut chnController]
     
*/
- chnController: (unsigned char)chn ctl: (unsigned char)ctl v: (unsigned char)v;

/** 
 It's an empty function, as FM devices don't support System Exclusive
 messages
     
*/
- sysex: (unsigned char*)data size: (unsigned long)size;

/** 
 See @ref -[MidiOut setVolumePercentage]
     
*/
- setVolumePercentage: (int)i;

/** 
 Returns @p p if the patch p has been loaded, or another patch (already loaded)
 if @p p hasn't been loaded. 
     
*/
- (int) patch: (int)p;

/** 
 Sets the directory where the FM patches are stored, that is, where the
 std.o3, std.sb, drums.o3 and drums.sb files can be found.

 It will store a copy of the parameter, so you should delete the memory
 used by the parameter you passed.
     
*/
+ setFMPatchesDirectory: (NSString *)dir;
@end

#endif
