/***************************************************************************
                            KDialog.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Dialog with extended modeless support and methods for KDE standard
 compliance.

 If the dialog is modeless and has a parent, the default keybindings 
 (<code>escape</code> = <code>reject</code>(), <code>enter</code> = <code>accept</code>(), etc.) are disabled.

 The {@link #marginHint} and {@link #spacingHint} sizes shall be used
 whenever you layout the interior of a dialog. One special note. If
 you make your own action buttons (OK, Cancel etc), the space
 beteween the buttons shall be {@link #spacingHint}, whereas the space
 above, below, to the right and to the left shall be {@link #marginHint}.
 If you add a separator line above the buttons, there shall be a
 {@link #marginHint} between the buttons and the separator and a
 {@link #marginHint} above the separator as well.

 See {@link KDialogSignals} for signals emitted by KDialog.

 See {@link KDialogEventHandling} for event handlers to override in subclasses of KDialog.

 @author Thomas Tanghus <tanghus@earthling.net>, Espen Sand <espensa@online.no>

 @version 0.1.2

 @short 
 Dialog with extended modeless support and methods for KDE standard
 compliance.
*/
public class KDialog extends QDialog  {
	protected KDialog(Class dummy){super((Class) null);}

	private native void newKDialog( QWidget parent, String name, boolean modal, int f);

/** 
 Constructor. 

 Takes the same arguments as {@link QDialog}.
     
*/
	public KDialog( QWidget parent, String name, boolean modal, int f) {
		super((Class) null);
		newKDialog( parent, name, modal, f);
	}
	private native void newKDialog();
	public KDialog() {
		super((Class) null);
		newKDialog();
	}
	public native void polish();

/** 
 Make a KDE compliant caption.

*/
	public native void setCaption( String caption);

/** 
 Make a plain caption without any modifications.

*/
	public native void setPlainCaption( String caption);

/** 
 Return the number of pixels you shall use between a 
 dialog edge and the outermost widget(s) according to the KDE standard.

*/
	public static native int marginHint();

/** 
 Return the number of pixels you shall use between 
 widgets inside a dialog according to the KDE standard.
     
*/
	public static native int spacingHint();

/** 
 Resize every layout manager used in <code>widget</code> and its nested children.

*/
	public static native void resizeLayout( QWidget widget, int margin, int spacing);

/** 
 Reszie every layout associated with <code>lay</code> and its children. 

*/
	public static native void resizeLayout( QLayoutItemInterface lay, int margin, int spacing);

/** 

     
*/
	protected native void keyPressEvent( QKeyEvent arg1);
}
