/***************************************************************************
                            KDesktopFile.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 KDE Desktop File Management.

 See {@link KDesktopFileSignals} for signals emitted by KDesktopFile.

 See {@link KDesktopFileEventHandling} for event handlers to override in subclasses of KDesktopFile.

 @author Pietro Iglio <iglio@kde.org>

 @version $Id: KDesktopFile.java,v 1.5 2002/01/31 04:48:56 rdale Exp $

 @short KDE Desktop File Management class.
*/
public class KDesktopFile extends KConfig  {
	protected KDesktopFile(Class dummy){super((Class) null);}

	private native void newKDesktopFile( String fileName, boolean readOnly, String resType);

/** 
 Constructs a KDesktopFile object and make it either read-write
 or read-only.

*/
	public KDesktopFile( String fileName, boolean readOnly, String resType) {
		super((Class) null);
		newKDesktopFile( fileName, readOnly, resType);
	}
	private native void newKDesktopFile( String fileName);
	public KDesktopFile( String fileName) {
		super((Class) null);
		newKDesktopFile( fileName);
	}

/** 
 Destructs the KDesktopFile object.

 Writes back any dirty configuration entries.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the value of the "Type=" entry.
   
*/
	public native String readType();

/** 
 Returns the value of the "Icon=" entry.
   
*/
	public native String readIcon();

/** 
 Returns the value of the "Name=" entry.
   
*/
	public native String readName();

/** 
 Returns the value of the "Comment=" entry.
   
*/
	public native String readComment();

/** 
 Returns the value of the "Path=" entry.

   
*/
	public native String readPath();

/** 
 Returns the value of the "Dev=" entry.
   
*/
	public native String readDevice();

/** 
 Returns the value of the "URL=" entry.
   
*/
	public native String readURL();

/** 
 Returns a list of the "Actions=" entries.
   
*/
	public native ArrayList readActions();

/** 
 Sets the desktop action group.
   
*/
	public native void setActionGroup( String group);

/** 
 Returns true if the action group exists, false otherwise
   
*/
	public native boolean hasActionGroup( String group);

/** 
 Checks whether there is a "Type=Link" entry.

 The link points to the "URL=" entry.
   
*/
	public native boolean hasLinkType();

/** 
 Checks whether there is an entry "Type=Application".
   
*/
	public native boolean hasApplicationType();

/** 
 Checks whether there is an entry "Type=MimeType".
   
*/
	public native boolean hasMimeTypeType();

/** 
 Checks whether there is an entry "Type=FSDev".
   
*/
	public native boolean hasDeviceType();

/** 
 Checks whether the TryExec field contains a binary
 which is found on the local system.
   
*/
	public native boolean tryExec();

/** 

*/
	public native String fileName();

/** 

*/
	public native String resource();
	public native ArrayList sortOrder();

/** 
 Checks whether this is really a desktop file.

 The check is performed looking at the file extension (the file is not
 opened).
 Currently, valid extensions are ".kdelnk" and ".desktop".

*/
	public static native boolean isDesktopFile( String path);
}
