/***************************************************************************
                            KColorDialog.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KColorDialog provides a dialog for color selection.

 In most cases, you will want to use the static method {@link KColorDialog#getColor}.
 This pops up the dialog (with an initial selection provided by you), lets the
 user choose a color, and returns.

 Example:

 <pre>
 	QColor myColor;
 	int result = KColorDialog.getColor( myColor );
         if ( result == KColorDialog.Accepted )
            ...
 </pre>

 The color dialog is really a collection of several widgets which can
 you can also use separately: the quadratic plane in the top left of
 the dialog is a {@link KXYSelector}. Right next to it is a {@link KHSSelector}
 for chosing hue/saturation.

 On the right side of the dialog you see a {@link KPaletteTable} showing
 up to 40 colors with a combo box which offers several predefined
 palettes or a palette configured by the user. The small field showing
 the currently selected color is a {@link KColorPatch}.

 See {@link KColorDialogSignals} for signals emitted by KColorDialog.

 See {@link KColorDialogEventHandling} for event handlers to override in subclasses of KColorDialog.

 @short A color selection dialog.

*/
public class KColorDialog extends KDialogBase  {
	protected KColorDialog(Class dummy){super((Class) null);}

	private native void newKColorDialog( QWidget parent, String name, boolean modal);

/** 
 Constructs a color selection dialog.
     
*/
	public KColorDialog( QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKColorDialog( parent, name, modal);
	}
	private native void newKColorDialog();
	public KColorDialog() {
		super((Class) null);
		newKColorDialog();
	}

/** 
 Destroys the color selection dialog.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the currently selected color.

*/
	public native QColor color();

/** 
 Call this to make the dialog show a "Default Color" checkbox.
 If this checkbox is selected, the dialog will return an "invalid" color (QColor()).
 This can be used to mean "the default text color", for instance,
 the one with the KDE text color on screen, but black when printing.
     
*/
	public native void setDefaultColor( QColor defaultCol);

/** 

*/
	public native QColor defaultColor();

/** 
 Preselects a color.
     
*/
	public native void setColor( QColor col);

/** 
 Creates a modal color dialog, let the user choose a
 color, and returns when the dialog is closed.

 The selected color is returned in the argument <code>theColor.</code>

*/
	public static native int getColor( QColor theColor, QWidget parent);
	public static native int getColor( QColor theColor);

/** 
 Creates a modal color dialog, lets the user choose a
 color, and returns when the dialog is closed.

 The selected color is returned in the argument <code>theColor.</code>

 This version takes a <code>defaultColor</code> argument, which sets the color
 selected by the "default color" checkbox. When this checkbox is checked,
 the invalid color (QColor()) is returned into <code>theColor.</code>

*/
	public static native int getColor( QColor theColor, QColor defaultColor, QWidget parent);
	public static native int getColor( QColor theColor, QColor defaultColor);

/** 
 Gets the color from the pixel at point p on the screen.
     
*/
	public static native QColor grabColor( QPoint p);
}
