/***************************************************************************
                            kde_MidiMapper.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_MIDIMAPPER
#define KDE_MIDIMAPPER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A Midi Mapper class which defines the way MIDI events are translated
 (or "mapped") to different ones. This way, when two MIDI devices "talk"
 in a somehow different way, they can still communicate.

 When the user has an external keyboard that is not compatible with the
 General Midi standard, he can use a MIDI mapper file to play files
 as if the synthesizer was GM compatible.

 Please see the KMid documentation 
 ( http://www.arrakis.es/~rlarrosa/kmid.html ) for information on the
 format of a MIDI mapper definition file, and how they work.

 I created this class because I had one of those non-GM keyboards, 
 so it can do everything I needed it to do for my keyboard to work
 exactly as a GM synth, and a few more things. Currently, it's the most
 featured MIDI mapper available.

 The usage of this class is quite simple, just create an object with
 a correct filename in the constructor and then use this object as
 parameter for @ref DeviceManager::setMidiMap().

 @author Antonio Larrosa Jimenez <larrosa@kde.org>  
 
 @version 0.9.5 17/01/2000

 @short Midi Mapper.
*/

/** 
 Constructor. Loads a MIDI Mapper definition from a file.

*/
kde_MidiMapper * kde_new_MidiMapper(char* name);

/** 
 Destructor.
     
*/
void kde_del_MidiMapper( kde_MidiMapper* p );

/** 
 Loads a MIDI Mapper definition file (you don't need to use this if you
 used a correct filename in constructor). 
     
*/
void kde_MidiMapper_loadFile(kde_MidiMapper* instPointer,char* name);

/** 
 Returns the status of the object.
     
*/
int kde_MidiMapper_ok(kde_MidiMapper* instPointer);

/**  
 Returns the channel which chn should be mapped to.
     
*/
unsigned char kde_MidiMapper_channel(kde_MidiMapper* instPointer,unsigned char chn);

/**  
 Returns the patch which pgm used on channel chn should be mapped to.
     
*/
unsigned char kde_MidiMapper_patch(kde_MidiMapper* instPointer,unsigned char chn, unsigned char pgm);

/**  
 Returns the key that key note playing a pgm patch on channel chn should
 be mapped to.
     
*/
unsigned char kde_MidiMapper_key(kde_MidiMapper* instPointer,unsigned char chn, unsigned char pgm, unsigned char note);

/** 
 Returns the value which the pitch bender on channel chn should be
 mapped to.
     
*/
void kde_MidiMapper_pitchBender(kde_MidiMapper* instPointer,unsigned char chn, unsigned char lsb, unsigned char msb);

/** 
 Returns the value which a given controller and its value should
 be mapped to when played on channel chn.
     
*/
void kde_MidiMapper_controller(kde_MidiMapper* instPointer,unsigned char chn, unsigned char ctl, unsigned char v);

/** 
 Returns the path and name of the file which the object loaded the
 mapper from.
     
*/
char* kde_MidiMapper_filename(kde_MidiMapper* instPointer);

#endif
