/***************************************************************************
                            kde_KProgress.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPROGRESS
#define KDE_KPROGRESS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A stylized progress bar.

 KProgress is derived from @ref QProgressBar, so
 you can use all the methods from that class. The only real difference
 is that a signal is emitted on changes to the value and you do not need
 to subclass KProgress just to change the format of the indicator text. 

 @author Aaron Seigo

 @version $Id: kde_KProgress.h,v 1.3 2002/02/21 00:43:13 rdale Exp $
 
 @short A progress indicator widget.

*/

/** 
 Construct a progress bar.
   
*/
kde_KProgress * kde_new_KProgress(qt_QWidget * parent, char* name, int f);

/** 
 Construct a progress bar with minimum, maximum and initial values.
   
*/
kde_KProgress * kde_new_KProgress1(int totalSteps, qt_QWidget * parent, char* name, int f);

/** 
 Destruct the progress bar.
   
*/
void kde_del_KProgress( kde_KProgress* p );

/** 
 If this is set to @p true, the progress text will be displayed.

   
*/
void kde_KProgress_setTextEnabled(kde_KProgress* instPointer,int arg1);

/** 
 @depricated Retrieves the current status, use progress() instead

*/
int kde_KProgress_value(kde_KProgress* instPointer);

/** 
 Returns @p true if progress text will be displayed,
 @p false otherwise.

*/
int kde_KProgress_textEnabled(kde_KProgress* instPointer);

/** 
 Retrieve the current format for printing status text.

*/
qt_QString * kde_KProgress_format(kde_KProgress* instPointer);

/** 
 @depricated but kept for source compatibility with KDE2's KProgress.
 Use @ref setTotalSteps() instead
   
*/
void kde_KProgress_setRange(kde_KProgress* instPointer,int min, int max);

/** 
 @depricated used @ref totalSteps() instead
   
*/
int kde_KProgress_maxValue(kde_KProgress* instPointer);

/** 
 Set the format of the text to use to display status.

 The default format is "%p%" (which looks like "42%".)

*/
void kde_KProgress_setFormat(kde_KProgress* instPointer,qt_QString * format);

/** 
 Set the current total number of steps in the action tat the progress bar
 is representing.
    
*/
void kde_KProgress_setTotalSteps(kde_KProgress* instPointer,int totalSteps);

/** 
 @depricated. Use @ref setProgress(int) instead
    
*/
void kde_KProgress_setValue(kde_KProgress* instPointer,int progress);

/** 
 Advance the progress bar by @p prog.

 This method is
 provided for convenience and is equivalent with
 @ref setValue(value()+prog).
   
*/
void kde_KProgress_advance(kde_KProgress* instPointer,int offset);

#endif
