/***************************************************************************
                            kde_KConfig.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCONFIG
#define KDE_KCONFIG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**


Copyright (c) 2000 Matthias Elter

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

****************************************************************
 @short 

*/

/** 
 Constructs a KConfig object.

*/
kde_KConfig * kde_new_KConfig(qt_QString * fileName, int bReadOnly, int bUseKDEGlobals, char* resType);

/** 
 Destructs the KConfig object.

 Writes back any dirty configuration entries, and destroys
 dynamically created objects.
   
*/
void kde_del_KConfig( kde_KConfig* p );

/** 
 Clears all entries out of the @p dirtyEntryMap, so the
 values will not be written to disk on a later call to
 @ref sync().

*/
void kde_KConfig_rollback(kde_KConfig* instPointer,int bDeep);

/** 
 Returns a list of groups that are known.
   
*/
qt_QStringList* kde_KConfig_groupList(kde_KConfig* instPointer);

/** 
 Clears all internal data structures and then reread
 configuration information from disk.
   
*/
void kde_KConfig_reparseConfiguration(kde_KConfig* instPointer);

/** 
 Returns true if the specified group is known.

*/
int kde_KConfig_internalHasGroup(kde_KConfig* instPointer,qt_QCString* group);

/** 
 Returns a map (tree) of the entries in the specified group.

 Do not use this function, the implementation / return type are
 subject to change.

   
*/
//kde_KEntryMap* kde_KConfig_internalEntryMap(kde_KConfig* instPointer,qt_QString * pGroup);

/** 
 Returns a copy of the internal map used to hold all entries.

 Do not use this function, the implementation / return type are
 subject to change.

   
*/
//kde_KEntryMap* kde_KConfig_internalEntryMap1(kde_KConfig* instPointer);

/** 
 Inserts a (key, value) pair into the internal storage mechanism of
 the configuration object.

*/
void kde_KConfig_putData(kde_KConfig* instPointer,kde_KEntryKey* _key, kde_KEntry* _data, int _checkGroup);

/** 
 Looks up an entry in the config object's internal structure.

*/
kde_KEntry* kde_KConfig_lookupData(kde_KConfig* instPointer,kde_KEntryKey* _key);

#endif
