/* 
 * Copyright (C) 2003-2005 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: drag_drop.c,v 1.8.2.2 2005/04/26 00:00:31 dsalt Exp $
 *
 * drag and drop support for the main window
 */

#include "globals.h"

#include <gtk/gtk.h>
#include <stdio.h>

#include "drag_drop.h"
#include "playlist.h"

/*
#define LOG
*/

static const GtkTargetEntry target_table[] = {
  { "text/uri-list", 0, 0 },
  { "x-gxine/internal", GTK_TARGET_SAME_APP, 1, },
};

int dnd_add_mrls (GtkSelectionData *data, int *current, int ins_pos)
{
  gint i = -1, len = -1, first = -1;
  gchar str[MAX_MRL_LEN];

  while (++i < data->length)
  {
    char c = data->data[i];
    if (len < MAX_MRL_LEN - 2 && c != '\r' && c != '\n')
      str[++len] = c;
    else if ((c == '\r' || c == '\n') && len > 0)
    {
      str[len + 1] = 0;
      if (first < 0)
	first = playlist_add_mrl (str, ins_pos);
      else
	playlist_add_mrl (str, ins_pos);
      if (ins_pos >= 0 && ins_pos++ <= (current ? *current : -1))
        ++(*current);
      len = -1;
    }
  }

  return first;
}


/* drag&drop onto TreeView objects */

drag_mrl_t drag_mrl = { NULL, NULL, -1 };

static void drag_start_cb (GtkTreeView *widget, GdkDragContext *context,
			   gpointer data)
{
  GtkTreeSelection *sel = gtk_tree_view_get_selection (widget);
  GtkTreeIter iter;

  if (gtk_tree_selection_get_selected (sel, NULL, &iter))
  {
    drag_mrl.model = gtk_tree_view_get_model (widget);
    drag_mrl.path = gtk_tree_model_get_path (drag_mrl.model, &iter);
    drag_mrl.index = gtk_tree_path_get_indices (drag_mrl.path)[0];
  }
}

static void drag_end_cb (GtkTreeView *widget, GdkDragContext *context,
			 gpointer data)
{
  if (drag_mrl.model)
  {
    drag_mrl.model = NULL;
    drag_mrl.index = -1;
    gtk_tree_path_free (drag_mrl.path);
  }
}

static void drag_data_get_cb (GtkTreeView *widget, GdkDragContext *context,
			      GtkSelectionData *selection, guint info,
			      guint time, gpointer data)
{
  if (drag_mrl.model)
    gtk_tree_set_row_drag_data (selection, drag_mrl.model, drag_mrl.path);
}

void treeview_drag_drop_setup (GtkTreeView *widget,
			       void (*drop_cb) (GtkTreeView *, GdkDragContext *,
						gint, gint, GtkSelectionData *,
						guint, guint))
{
  GObject *object = G_OBJECT(widget);

  g_signal_connect (object, "drag-begin",
		    G_CALLBACK (drag_start_cb), NULL);
  g_signal_connect (object, "drag-data-get",
		    G_CALLBACK (drag_data_get_cb), NULL);
  g_signal_connect (object, "drag-data-received",
		    G_CALLBACK (drop_cb), NULL);
  g_signal_connect (object, "drag-end",
		    G_CALLBACK (drag_end_cb), NULL);

  gtk_tree_view_enable_model_drag_source (widget, 0, target_table + 1, 1,
					  GDK_ACTION_COPY | GDK_ACTION_MOVE);
  gtk_tree_view_enable_model_drag_dest (widget, target_table, 2,
					GDK_ACTION_COPY | GDK_ACTION_MOVE);
}

int treeview_get_drop_index (GtkTreeView *widget, GdkDragContext *context,
			     gint x, gint y)
{
  GtkTreePath *path;
  gint cx, cy, ins_pos = -1;

  gdk_window_get_geometry (gtk_tree_view_get_bin_window (widget),
			   &cx, &cy, NULL, NULL, NULL);
  if (gtk_tree_view_get_path_at_pos (widget, x -= cx, y -= cy,
				     &path, NULL, &cx, &cy))
  {
    GdkRectangle rect;
    /* in lower 1/3 of row? use next row as target */
    gtk_tree_view_get_background_area (widget, path,
				       gtk_tree_view_get_column (widget, 0),
				       &rect);
    if (cy >= rect.height * 2 / 3.0)
    {
      gtk_tree_path_free (path);
      if (gtk_tree_view_get_path_at_pos (widget, x, y + rect.height,
					 &path, NULL, &cx, &cy))
	ins_pos = gtk_tree_path_get_indices (path)[0];
    }
    else
      ins_pos = gtk_tree_path_get_indices (path)[0];
    gtk_tree_path_free (path);
  }
  return ins_pos;
}


/* drag&drop onto non-TreeView objects */

static void drag_data_received_cb (GtkWidget *widget, GdkDragContext *context,
				   gint x, gint y, GtkSelectionData *data,
				   guint info, guint time)
{
  logprintf ("drag_drop: drag callback, length=%d, format=%d\n",
	     data->length, data->format);

  if (data->format == 8)
  {
    int first = dnd_add_mrls (data, NULL, -1);
    if (first >= 0)
      playlist_play (first);
    gtk_drag_finish (context, TRUE, FALSE, time);
  }
  else
    gtk_drag_finish (context, FALSE, FALSE, time);
}

void drag_drop_setup (GtkWidget *widget)
{
  gtk_drag_dest_set (widget, GTK_DEST_DEFAULT_ALL,
		     target_table, 1, GDK_ACTION_COPY);
  g_signal_connect (GTK_OBJECT (widget), "drag-data-received",
		    G_CALLBACK (drag_data_received_cb), NULL);
}
