// $Id: infodialog.cpp,v 1.17 2003/01/12 05:03:20 nhasan Exp $

#include <qgrid.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kapplication.h>
#include <kdebug.h>
#include <klocale.h>
#include <kseparator.h>

#include "canvas.h"

#include "infodialog.h"

imageInfoDialog::imageInfoDialog(Canvas *c, QWidget* parent, const char* name)
  : KDialogBase(parent, name, true, i18n( "Information" ), Close )
{
  QWidget *w = makeMainWidget();

  QVBoxLayout *mainLayout = new QVBoxLayout( w );

  //
  // Title block
  //
  QLabel *titleLabel = new QLabel( i18n( "Image Information" ), 
    w, "titleLabel" );
  QFont titleFont = titleLabel->font();
  titleFont.setBold( true );
  titleLabel->setFont( titleFont );
  KSeparator *titleSep = new KSeparator( w );
  titleSep->setFrameStyle( QFrame::HLine|QFrame::Plain );
  mainLayout->addWidget( titleLabel );
  mainLayout->addWidget( titleSep );

  //
  // Content
  //
  QGrid *info = new QGrid( 2, w );
  info->setSpacing( spacingHint() );
  mainLayout->addWidget( info );

  //
  // Colour depth
  //
  QLabel *tmpQLabel = new QLabel( info, "Label_3" );
  tmpQLabel->setText( i18n( "Color depth:" ) );

  colourDepth = new QLabel( info, "Label_4" );
  QString depthStr;
  depthStr.setNum( c->pixmap()->depth() );
  colourDepth->setText( depthStr );
  colourDepth->setAlignment( AlignRight );

  //
  // Colours used
  //
  tmpQLabel = new QLabel( info, "Label_5" );
  tmpQLabel->setText( i18n("Colors used:") );

  coloursUsed = new QLabel( info, "Label_6" );
  QString colUseStr;
  colUseStr.setNum( c->pixmap()->convertToImage().numColors() );
  coloursUsed->setText( colUseStr );
  coloursUsed->setAlignment( AlignRight );

  //
  // Image size
  //
  tmpQLabel = new QLabel( info, "Label_9" );
  tmpQLabel->setText( i18n( "Image width:" ) );

  QSize sz = c->pixmap()->size();

  width = new QLabel( info, "Label_10" );
  QString widthStr;
  widthStr.setNum( sz.width() );
  width->setText( widthStr );
  width->setAlignment( AlignRight );

  tmpQLabel = new QLabel( info, "Label_11" );
  tmpQLabel->setText( i18n("Image height:") );

  height = new QLabel( info, "Label_12" );
  QString heightStr;
  heightStr.setNum( sz.height() );
  height->setText( heightStr );
  height->setAlignment( AlignRight );

  mainLayout->addStretch();

  //
  // Buttons
  //
  KSeparator *btnSep = new KSeparator( w );
  btnSep->setFrameStyle( QFrame::HLine|QFrame::Plain );
  mainLayout->addWidget( btnSep );

  resize( 200, 160 );
}

#include "infodialog.moc"

