/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "autobootui.h"
#include <QVBoxLayout>

AutoBootUi::AutoBootUi(QWidget *parent) : QWidget(parent)
{
    initUi();
}

void AutoBootUi::initUi()
{
    QVBoxLayout *vLyt = new QVBoxLayout(this);
    vLyt->setSpacing(8);
    vLyt->setContentsMargins(0, 0, 0, 0);

    TitleLabel *mTitleLabel = new TitleLabel(this);
    //~ contents_path /Autoboot/Autoboot Settings
    mTitleLabel->setText(tr("Autoboot Settings"));

    mAutobootWidget = new SettingGroup(this);

    mAddWidget = new UkccFrame(mAutobootWidget);
    mAddWidget->setLineWidth(0);
    QHBoxLayout *Lyt = new QHBoxLayout(mAddWidget);
    Lyt->setContentsMargins(0, 0, 0, 0);
    mAddBtn = new AddButton(mAddWidget);
    //~ contents_path /autoboot/Add
    Lyt->addWidget(mAddBtn);

    vLyt->addWidget(mTitleLabel);
    vLyt->addWidget(mAutobootWidget);
    vLyt->addStretch();
}

void AutoBootUi::resetUi()
{
    if (this->layout() != NULL) {
        QLayoutItem *item;
        while ((item = this->layout()->takeAt(0)) != NULL)
        {
            if(item->widget()) {
               item->widget()->setParent(NULL);
            }
            delete item;
            item = nullptr;
        }
    }
    delete this->layout();
    initUi();
}
