package datadog

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/datadog/mgmt/2020-02-01-preview/datadog"

// AgreementProperties terms properties.
type AgreementProperties struct {
	// Publisher - Publisher identifier string.
	Publisher *string `json:"publisher,omitempty"`
	// Product - Product identifier string.
	Product *string `json:"product,omitempty"`
	// Plan - Plan identifier string.
	Plan *string `json:"plan,omitempty"`
	// LicenseTextLink - Link to HTML with Microsoft and Publisher terms.
	LicenseTextLink *string `json:"licenseTextLink,omitempty"`
	// PrivacyPolicyLink - Link to the privacy policy of the publisher.
	PrivacyPolicyLink *string `json:"privacyPolicyLink,omitempty"`
	// RetrieveDatetime - Date and time in UTC of when the terms were accepted. This is empty if Accepted is false.
	RetrieveDatetime *date.Time `json:"retrieveDatetime,omitempty"`
	// Signature - Terms signature.
	Signature *string `json:"signature,omitempty"`
	// Accepted - If any version of the terms have been accepted, otherwise false.
	Accepted *bool `json:"accepted,omitempty"`
}

// AgreementResource ...
type AgreementResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; ARM id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the agreement.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Properties - Represents the properties of the resource.
	Properties *AgreementProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AgreementResource.
func (ar AgreementResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Properties != nil {
		objectMap["properties"] = ar.Properties
	}
	return json.Marshal(objectMap)
}

// AgreementResourceListResponse response of a list operation.
type AgreementResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]AgreementResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// AgreementResourceListResponseIterator provides access to a complete listing of AgreementResource values.
type AgreementResourceListResponseIterator struct {
	i    int
	page AgreementResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AgreementResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgreementResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AgreementResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AgreementResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AgreementResourceListResponseIterator) Response() AgreementResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AgreementResourceListResponseIterator) Value() AgreementResource {
	if !iter.page.NotDone() {
		return AgreementResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AgreementResourceListResponseIterator type.
func NewAgreementResourceListResponseIterator(page AgreementResourceListResponsePage) AgreementResourceListResponseIterator {
	return AgreementResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arlr AgreementResourceListResponse) IsEmpty() bool {
	return arlr.Value == nil || len(*arlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arlr AgreementResourceListResponse) hasNextLink() bool {
	return arlr.NextLink != nil && len(*arlr.NextLink) != 0
}

// agreementResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arlr AgreementResourceListResponse) agreementResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !arlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arlr.NextLink)))
}

// AgreementResourceListResponsePage contains a page of AgreementResource values.
type AgreementResourceListResponsePage struct {
	fn   func(context.Context, AgreementResourceListResponse) (AgreementResourceListResponse, error)
	arlr AgreementResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AgreementResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgreementResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arlr)
		if err != nil {
			return err
		}
		page.arlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AgreementResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AgreementResourceListResponsePage) NotDone() bool {
	return !page.arlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AgreementResourceListResponsePage) Response() AgreementResourceListResponse {
	return page.arlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AgreementResourceListResponsePage) Values() []AgreementResource {
	if page.arlr.IsEmpty() {
		return nil
	}
	return *page.arlr.Value
}

// Creates a new instance of the AgreementResourceListResponsePage type.
func NewAgreementResourceListResponsePage(cur AgreementResourceListResponse, getNextPage func(context.Context, AgreementResourceListResponse) (AgreementResourceListResponse, error)) AgreementResourceListResponsePage {
	return AgreementResourceListResponsePage{
		fn:   getNextPage,
		arlr: cur,
	}
}

// APIKey ...
type APIKey struct {
	autorest.Response `json:"-"`
	// CreatedBy - The user that created the API key.
	CreatedBy *string `json:"createdBy,omitempty"`
	// Name - The name of the API key.
	Name *string `json:"name,omitempty"`
	// Key - The value of the API key.
	Key *string `json:"key,omitempty"`
	// Created - The time of creation of the API key.
	Created *string `json:"created,omitempty"`
}

// APIKeyListResponse response of a list operation.
type APIKeyListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]APIKey `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// APIKeyListResponseIterator provides access to a complete listing of APIKey values.
type APIKeyListResponseIterator struct {
	i    int
	page APIKeyListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APIKeyListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIKeyListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *APIKeyListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APIKeyListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APIKeyListResponseIterator) Response() APIKeyListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APIKeyListResponseIterator) Value() APIKey {
	if !iter.page.NotDone() {
		return APIKey{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the APIKeyListResponseIterator type.
func NewAPIKeyListResponseIterator(page APIKeyListResponsePage) APIKeyListResponseIterator {
	return APIKeyListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aklr APIKeyListResponse) IsEmpty() bool {
	return aklr.Value == nil || len(*aklr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aklr APIKeyListResponse) hasNextLink() bool {
	return aklr.NextLink != nil && len(*aklr.NextLink) != 0
}

// aPIKeyListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aklr APIKeyListResponse) aPIKeyListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !aklr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aklr.NextLink)))
}

// APIKeyListResponsePage contains a page of APIKey values.
type APIKeyListResponsePage struct {
	fn   func(context.Context, APIKeyListResponse) (APIKeyListResponse, error)
	aklr APIKeyListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APIKeyListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIKeyListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aklr)
		if err != nil {
			return err
		}
		page.aklr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *APIKeyListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APIKeyListResponsePage) NotDone() bool {
	return !page.aklr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APIKeyListResponsePage) Response() APIKeyListResponse {
	return page.aklr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APIKeyListResponsePage) Values() []APIKey {
	if page.aklr.IsEmpty() {
		return nil
	}
	return *page.aklr.Value
}

// Creates a new instance of the APIKeyListResponsePage type.
func NewAPIKeyListResponsePage(cur APIKeyListResponse, getNextPage func(context.Context, APIKeyListResponse) (APIKeyListResponse, error)) APIKeyListResponsePage {
	return APIKeyListResponsePage{
		fn:   getNextPage,
		aklr: cur,
	}
}

// ErrorResponseBody ...
type ErrorResponseBody struct {
	Code    *string              `json:"code,omitempty"`
	Message *string              `json:"message,omitempty"`
	Target  *string              `json:"target,omitempty"`
	Details *[]ErrorResponseBody `json:"details,omitempty"`
}

// FilteringTag the definition of a filtering tag. Filtering tags are used for capturing resources and
// include/exclude them from being monitored.
type FilteringTag struct {
	// Name - The name (also known as the key) of the tag.
	Name *string `json:"name,omitempty"`
	// Value - The value of the tag.
	Value *string `json:"value,omitempty"`
	// Action - Possible values include: 'Include', 'Exclude'
	Action TagAction `json:"action,omitempty"`
}

// Host ...
type Host struct {
	// Name - The name of the host.
	Name *string `json:"name,omitempty"`
	// Aliases - The aliases for the host.
	Aliases *[]string `json:"aliases,omitempty"`
	// Apps - The Datadog integrations reporting metrics for the host.
	Apps *[]string     `json:"apps,omitempty"`
	Meta *HostMetadata `json:"meta,omitempty"`
}

// HostListResponse response of a list operation.
type HostListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]Host `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// HostListResponseIterator provides access to a complete listing of Host values.
type HostListResponseIterator struct {
	i    int
	page HostListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HostListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HostListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HostListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HostListResponseIterator) Response() HostListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HostListResponseIterator) Value() Host {
	if !iter.page.NotDone() {
		return Host{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HostListResponseIterator type.
func NewHostListResponseIterator(page HostListResponsePage) HostListResponseIterator {
	return HostListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hlr HostListResponse) IsEmpty() bool {
	return hlr.Value == nil || len(*hlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hlr HostListResponse) hasNextLink() bool {
	return hlr.NextLink != nil && len(*hlr.NextLink) != 0
}

// hostListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hlr HostListResponse) hostListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !hlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hlr.NextLink)))
}

// HostListResponsePage contains a page of Host values.
type HostListResponsePage struct {
	fn  func(context.Context, HostListResponse) (HostListResponse, error)
	hlr HostListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HostListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hlr)
		if err != nil {
			return err
		}
		page.hlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HostListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HostListResponsePage) NotDone() bool {
	return !page.hlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HostListResponsePage) Response() HostListResponse {
	return page.hlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HostListResponsePage) Values() []Host {
	if page.hlr.IsEmpty() {
		return nil
	}
	return *page.hlr.Value
}

// Creates a new instance of the HostListResponsePage type.
func NewHostListResponsePage(cur HostListResponse, getNextPage func(context.Context, HostListResponse) (HostListResponse, error)) HostListResponsePage {
	return HostListResponsePage{
		fn:  getNextPage,
		hlr: cur,
	}
}

// HostMetadata ...
type HostMetadata struct {
	// AgentVersion - The agent version.
	AgentVersion  *string        `json:"agentVersion,omitempty"`
	InstallMethod *InstallMethod `json:"installMethod,omitempty"`
	LogsAgent     *LogsAgent     `json:"logsAgent,omitempty"`
}

// IdentityProperties ...
type IdentityProperties struct {
	// PrincipalID - READ-ONLY; The identity ID.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - Possible values include: 'SystemAssigned', 'UserAssigned'
	Type ManagedIdentityTypes `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IdentityProperties.
func (IP IdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.Type != "" {
		objectMap["type"] = IP.Type
	}
	return json.Marshal(objectMap)
}

// InstallMethod ...
type InstallMethod struct {
	// Tool - The tool.
	Tool *string `json:"tool,omitempty"`
	// ToolVersion - The tool version.
	ToolVersion *string `json:"toolVersion,omitempty"`
	// InstallerVersion - The installer version.
	InstallerVersion *string `json:"installerVersion,omitempty"`
}

// LinkedResource the definition of a linked resource.
type LinkedResource struct {
	// ID - The ARM id of the linked resource.
	ID *string `json:"id,omitempty"`
}

// LinkedResourceListResponse response of a list operation.
type LinkedResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]LinkedResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// LinkedResourceListResponseIterator provides access to a complete listing of LinkedResource values.
type LinkedResourceListResponseIterator struct {
	i    int
	page LinkedResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LinkedResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LinkedResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LinkedResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LinkedResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LinkedResourceListResponseIterator) Response() LinkedResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LinkedResourceListResponseIterator) Value() LinkedResource {
	if !iter.page.NotDone() {
		return LinkedResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LinkedResourceListResponseIterator type.
func NewLinkedResourceListResponseIterator(page LinkedResourceListResponsePage) LinkedResourceListResponseIterator {
	return LinkedResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lrlr LinkedResourceListResponse) IsEmpty() bool {
	return lrlr.Value == nil || len(*lrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lrlr LinkedResourceListResponse) hasNextLink() bool {
	return lrlr.NextLink != nil && len(*lrlr.NextLink) != 0
}

// linkedResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lrlr LinkedResourceListResponse) linkedResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !lrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lrlr.NextLink)))
}

// LinkedResourceListResponsePage contains a page of LinkedResource values.
type LinkedResourceListResponsePage struct {
	fn   func(context.Context, LinkedResourceListResponse) (LinkedResourceListResponse, error)
	lrlr LinkedResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LinkedResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LinkedResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lrlr)
		if err != nil {
			return err
		}
		page.lrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LinkedResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LinkedResourceListResponsePage) NotDone() bool {
	return !page.lrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LinkedResourceListResponsePage) Response() LinkedResourceListResponse {
	return page.lrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LinkedResourceListResponsePage) Values() []LinkedResource {
	if page.lrlr.IsEmpty() {
		return nil
	}
	return *page.lrlr.Value
}

// Creates a new instance of the LinkedResourceListResponsePage type.
func NewLinkedResourceListResponsePage(cur LinkedResourceListResponse, getNextPage func(context.Context, LinkedResourceListResponse) (LinkedResourceListResponse, error)) LinkedResourceListResponsePage {
	return LinkedResourceListResponsePage{
		fn:   getNextPage,
		lrlr: cur,
	}
}

// LogRules set of rules for sending logs for the Monitor resource.
type LogRules struct {
	// SendAadLogs - Flag specifying if AAD logs should be sent for the Monitor resource.
	SendAadLogs *bool `json:"sendAadLogs,omitempty"`
	// SendSubscriptionLogs - Flag specifying if Azure subscription logs should be sent for the Monitor resource.
	SendSubscriptionLogs *bool `json:"sendSubscriptionLogs,omitempty"`
	// SendResourceLogs - Flag specifying if Azure resource logs should be sent for the Monitor resource.
	SendResourceLogs *bool `json:"sendResourceLogs,omitempty"`
	// FilteringTags - List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
	FilteringTags *[]FilteringTag `json:"filteringTags,omitempty"`
}

// LogsAgent ...
type LogsAgent struct {
	// Transport - The transport.
	Transport *string `json:"transport,omitempty"`
}

// MetricRules set of rules for sending metrics for the Monitor resource.
type MetricRules struct {
	// FilteringTags - List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
	FilteringTags *[]FilteringTag `json:"filteringTags,omitempty"`
}

// MonitoredResource the properties of a resource currently being monitored by the Datadog monitor
// resource.
type MonitoredResource struct {
	// ID - The ARM id of the resource.
	ID *string `json:"id,omitempty"`
	// SendingMetrics - Flag indicating if resource is sending metrics to Datadog.
	SendingMetrics *bool `json:"sendingMetrics,omitempty"`
	// ReasonForMetricsStatus - Reason for why the resource is sending metrics (or why it is not sending).
	ReasonForMetricsStatus *string `json:"reasonForMetricsStatus,omitempty"`
	// SendingLogs - Flag indicating if resource is sending logs to Datadog.
	SendingLogs *bool `json:"sendingLogs,omitempty"`
	// ReasonForLogsStatus - Reason for why the resource is sending logs (or why it is not sending).
	ReasonForLogsStatus *string `json:"reasonForLogsStatus,omitempty"`
}

// MonitoredResourceListResponse response of a list operation.
type MonitoredResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]MonitoredResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitoredResourceListResponseIterator provides access to a complete listing of MonitoredResource values.
type MonitoredResourceListResponseIterator struct {
	i    int
	page MonitoredResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitoredResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoredResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitoredResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitoredResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitoredResourceListResponseIterator) Response() MonitoredResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitoredResourceListResponseIterator) Value() MonitoredResource {
	if !iter.page.NotDone() {
		return MonitoredResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitoredResourceListResponseIterator type.
func NewMonitoredResourceListResponseIterator(page MonitoredResourceListResponsePage) MonitoredResourceListResponseIterator {
	return MonitoredResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrlr MonitoredResourceListResponse) IsEmpty() bool {
	return mrlr.Value == nil || len(*mrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrlr MonitoredResourceListResponse) hasNextLink() bool {
	return mrlr.NextLink != nil && len(*mrlr.NextLink) != 0
}

// monitoredResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrlr MonitoredResourceListResponse) monitoredResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !mrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrlr.NextLink)))
}

// MonitoredResourceListResponsePage contains a page of MonitoredResource values.
type MonitoredResourceListResponsePage struct {
	fn   func(context.Context, MonitoredResourceListResponse) (MonitoredResourceListResponse, error)
	mrlr MonitoredResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitoredResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoredResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrlr)
		if err != nil {
			return err
		}
		page.mrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitoredResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitoredResourceListResponsePage) NotDone() bool {
	return !page.mrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitoredResourceListResponsePage) Response() MonitoredResourceListResponse {
	return page.mrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitoredResourceListResponsePage) Values() []MonitoredResource {
	if page.mrlr.IsEmpty() {
		return nil
	}
	return *page.mrlr.Value
}

// Creates a new instance of the MonitoredResourceListResponsePage type.
func NewMonitoredResourceListResponsePage(cur MonitoredResourceListResponse, getNextPage func(context.Context, MonitoredResourceListResponse) (MonitoredResourceListResponse, error)) MonitoredResourceListResponsePage {
	return MonitoredResourceListResponsePage{
		fn:   getNextPage,
		mrlr: cur,
	}
}

// MonitoringTagRules capture logs and metrics of Azure resources based on ARM tags.
type MonitoringTagRules struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Name of the rule set.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The id of the rule set.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the rule set.
	Type       *string                       `json:"type,omitempty"`
	Properties *MonitoringTagRulesProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitoringTagRules.
func (mtr MonitoringTagRules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mtr.Properties != nil {
		objectMap["properties"] = mtr.Properties
	}
	return json.Marshal(objectMap)
}

// MonitoringTagRulesListResponse response of a list operation.
type MonitoringTagRulesListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]MonitoringTagRules `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitoringTagRulesListResponseIterator provides access to a complete listing of MonitoringTagRules
// values.
type MonitoringTagRulesListResponseIterator struct {
	i    int
	page MonitoringTagRulesListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitoringTagRulesListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoringTagRulesListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitoringTagRulesListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitoringTagRulesListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitoringTagRulesListResponseIterator) Response() MonitoringTagRulesListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitoringTagRulesListResponseIterator) Value() MonitoringTagRules {
	if !iter.page.NotDone() {
		return MonitoringTagRules{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitoringTagRulesListResponseIterator type.
func NewMonitoringTagRulesListResponseIterator(page MonitoringTagRulesListResponsePage) MonitoringTagRulesListResponseIterator {
	return MonitoringTagRulesListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mtrlr MonitoringTagRulesListResponse) IsEmpty() bool {
	return mtrlr.Value == nil || len(*mtrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mtrlr MonitoringTagRulesListResponse) hasNextLink() bool {
	return mtrlr.NextLink != nil && len(*mtrlr.NextLink) != 0
}

// monitoringTagRulesListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mtrlr MonitoringTagRulesListResponse) monitoringTagRulesListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !mtrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mtrlr.NextLink)))
}

// MonitoringTagRulesListResponsePage contains a page of MonitoringTagRules values.
type MonitoringTagRulesListResponsePage struct {
	fn    func(context.Context, MonitoringTagRulesListResponse) (MonitoringTagRulesListResponse, error)
	mtrlr MonitoringTagRulesListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitoringTagRulesListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoringTagRulesListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mtrlr)
		if err != nil {
			return err
		}
		page.mtrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitoringTagRulesListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitoringTagRulesListResponsePage) NotDone() bool {
	return !page.mtrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitoringTagRulesListResponsePage) Response() MonitoringTagRulesListResponse {
	return page.mtrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitoringTagRulesListResponsePage) Values() []MonitoringTagRules {
	if page.mtrlr.IsEmpty() {
		return nil
	}
	return *page.mtrlr.Value
}

// Creates a new instance of the MonitoringTagRulesListResponsePage type.
func NewMonitoringTagRulesListResponsePage(cur MonitoringTagRulesListResponse, getNextPage func(context.Context, MonitoringTagRulesListResponse) (MonitoringTagRulesListResponse, error)) MonitoringTagRulesListResponsePage {
	return MonitoringTagRulesListResponsePage{
		fn:    getNextPage,
		mtrlr: cur,
	}
}

// MonitoringTagRulesProperties definition of the properties for a TagRules resource.
type MonitoringTagRulesProperties struct {
	// ProvisioningState - Possible values include: 'Accepted', 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled', 'Deleted', 'NotSpecified'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	LogRules          *LogRules         `json:"logRules,omitempty"`
	MetricRules       *MetricRules      `json:"metricRules,omitempty"`
}

// MonitorProperties properties specific to the monitor resource.
type MonitorProperties struct {
	// ProvisioningState - Possible values include: 'Accepted', 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled', 'Deleted', 'NotSpecified'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// MonitoringStatus - Possible values include: 'Enabled', 'Disabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
	// MarketplaceSubscriptionStatus - Possible values include: 'Provisioning', 'Active', 'Suspended', 'Unsubscribed'
	MarketplaceSubscriptionStatus MarketplaceSubscriptionStatus `json:"marketplaceSubscriptionStatus,omitempty"`
	DatadogOrganizationProperties *OrganizationProperties       `json:"datadogOrganizationProperties,omitempty"`
	UserInfo                      *UserInfo                     `json:"userInfo,omitempty"`
	// LiftrResourceCategory - Possible values include: 'Unknown', 'MonitorLogs'
	LiftrResourceCategory LiftrResourceCategories `json:"liftrResourceCategory,omitempty"`
	// LiftrResourcePreference - READ-ONLY; The priority of the resource.
	LiftrResourcePreference *int32 `json:"liftrResourcePreference,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitorProperties.
func (mp MonitorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.ProvisioningState != "" {
		objectMap["provisioningState"] = mp.ProvisioningState
	}
	if mp.MonitoringStatus != "" {
		objectMap["monitoringStatus"] = mp.MonitoringStatus
	}
	if mp.MarketplaceSubscriptionStatus != "" {
		objectMap["marketplaceSubscriptionStatus"] = mp.MarketplaceSubscriptionStatus
	}
	if mp.DatadogOrganizationProperties != nil {
		objectMap["datadogOrganizationProperties"] = mp.DatadogOrganizationProperties
	}
	if mp.UserInfo != nil {
		objectMap["userInfo"] = mp.UserInfo
	}
	if mp.LiftrResourceCategory != "" {
		objectMap["liftrResourceCategory"] = mp.LiftrResourceCategory
	}
	return json.Marshal(objectMap)
}

// MonitorResource ...
type MonitorResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; ARM id of the monitor resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the monitor resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the monitor resource.
	Type       *string             `json:"type,omitempty"`
	Sku        *ResourceSku        `json:"sku,omitempty"`
	Properties *MonitorProperties  `json:"properties,omitempty"`
	Identity   *IdentityProperties `json:"identity,omitempty"`
	Tags       map[string]*string  `json:"tags"`
	Location   *string             `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitorResource.
func (mr MonitorResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mr.Sku != nil {
		objectMap["sku"] = mr.Sku
	}
	if mr.Properties != nil {
		objectMap["properties"] = mr.Properties
	}
	if mr.Identity != nil {
		objectMap["identity"] = mr.Identity
	}
	if mr.Tags != nil {
		objectMap["tags"] = mr.Tags
	}
	if mr.Location != nil {
		objectMap["location"] = mr.Location
	}
	return json.Marshal(objectMap)
}

// MonitorResourceListResponse response of a list operation.
type MonitorResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]MonitorResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitorResourceListResponseIterator provides access to a complete listing of MonitorResource values.
type MonitorResourceListResponseIterator struct {
	i    int
	page MonitorResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitorResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitorResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitorResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitorResourceListResponseIterator) Response() MonitorResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitorResourceListResponseIterator) Value() MonitorResource {
	if !iter.page.NotDone() {
		return MonitorResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitorResourceListResponseIterator type.
func NewMonitorResourceListResponseIterator(page MonitorResourceListResponsePage) MonitorResourceListResponseIterator {
	return MonitorResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrlr MonitorResourceListResponse) IsEmpty() bool {
	return mrlr.Value == nil || len(*mrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrlr MonitorResourceListResponse) hasNextLink() bool {
	return mrlr.NextLink != nil && len(*mrlr.NextLink) != 0
}

// monitorResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrlr MonitorResourceListResponse) monitorResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !mrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrlr.NextLink)))
}

// MonitorResourceListResponsePage contains a page of MonitorResource values.
type MonitorResourceListResponsePage struct {
	fn   func(context.Context, MonitorResourceListResponse) (MonitorResourceListResponse, error)
	mrlr MonitorResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitorResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrlr)
		if err != nil {
			return err
		}
		page.mrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitorResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitorResourceListResponsePage) NotDone() bool {
	return !page.mrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitorResourceListResponsePage) Response() MonitorResourceListResponse {
	return page.mrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitorResourceListResponsePage) Values() []MonitorResource {
	if page.mrlr.IsEmpty() {
		return nil
	}
	return *page.mrlr.Value
}

// Creates a new instance of the MonitorResourceListResponsePage type.
func NewMonitorResourceListResponsePage(cur MonitorResourceListResponse, getNextPage func(context.Context, MonitorResourceListResponse) (MonitorResourceListResponse, error)) MonitorResourceListResponsePage {
	return MonitorResourceListResponsePage{
		fn:   getNextPage,
		mrlr: cur,
	}
}

// MonitorResourceUpdateParameters the parameters for a PATCH request to a monitor resource.
type MonitorResourceUpdateParameters struct {
	Properties *MonitorUpdateProperties `json:"properties,omitempty"`
	// Tags - The new tags of the monitor resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MonitorResourceUpdateParameters.
func (mrup MonitorResourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrup.Properties != nil {
		objectMap["properties"] = mrup.Properties
	}
	if mrup.Tags != nil {
		objectMap["tags"] = mrup.Tags
	}
	return json.Marshal(objectMap)
}

// MonitorsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MonitorsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitorsClient) (MonitorResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitorsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitorsCreateFuture.Result.
func (future *MonitorsCreateFuture) result(client MonitorsClient) (mr MonitorResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datadog.MonitorsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("datadog.MonitorsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mr.Response.Response, err = future.GetResult(sender); err == nil && mr.Response.Response.StatusCode != http.StatusNoContent {
		mr, err = client.CreateResponder(mr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datadog.MonitorsCreateFuture", "Result", mr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MonitorsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MonitorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitorsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitorsDeleteFuture.Result.
func (future *MonitorsDeleteFuture) result(client MonitorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datadog.MonitorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("datadog.MonitorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MonitorUpdateProperties the set of properties that can be update in a PATCH request to a monitor
// resource.
type MonitorUpdateProperties struct {
	// MonitoringStatus - Possible values include: 'Enabled', 'Disabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider, i.e., Microsoft.Datadog.
	Provider *string `json:"provider,omitempty"`
	// Resource - Type on which the operation is performed, e.g., 'monitors'.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type, e.g., read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation, e.g., 'Write monitors'.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of GET request to list the Microsoft.Datadog operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Microsoft.Datadog provider.
	Value *[]OperationResult `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationResult values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationResult {
	if !iter.page.NotDone() {
		return OperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationResult values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationResult {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationResult a Microsoft.Datadog REST API operation.
type OperationResult struct {
	// Name - Operation name, i.e., {provider}/{resource}/{operation}.
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
}

// OrganizationProperties datadog organization properties
type OrganizationProperties struct {
	// Name - READ-ONLY; Name of the Datadog organization.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the Datadog organization.
	ID *string `json:"id,omitempty"`
	// LinkingAuthCode - The auth code used to linking to an existing datadog organization.
	LinkingAuthCode *string `json:"linkingAuthCode,omitempty"`
	// LinkingClientID - The client_id from an existing in exchange for an auth token to link organization.
	LinkingClientID *string `json:"linkingClientId,omitempty"`
	// RedirectURI - The redirect uri for linking.
	RedirectURI *string `json:"redirectUri,omitempty"`
	// APIKey - Api key associated to the Datadog organization.
	APIKey *string `json:"apiKey,omitempty"`
	// ApplicationKey - Application key associated to the Datadog organization.
	ApplicationKey *string `json:"applicationKey,omitempty"`
	// EnterpriseAppID - The Id of the Enterprise App used for Single sign on.
	EnterpriseAppID *string `json:"enterpriseAppId,omitempty"`
}

// MarshalJSON is the custom marshaler for OrganizationProperties.
func (op OrganizationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if op.LinkingAuthCode != nil {
		objectMap["linkingAuthCode"] = op.LinkingAuthCode
	}
	if op.LinkingClientID != nil {
		objectMap["linkingClientId"] = op.LinkingClientID
	}
	if op.RedirectURI != nil {
		objectMap["redirectUri"] = op.RedirectURI
	}
	if op.APIKey != nil {
		objectMap["apiKey"] = op.APIKey
	}
	if op.ApplicationKey != nil {
		objectMap["applicationKey"] = op.ApplicationKey
	}
	if op.EnterpriseAppID != nil {
		objectMap["enterpriseAppId"] = op.EnterpriseAppID
	}
	return json.Marshal(objectMap)
}

// ResourceProviderDefaultErrorResponse ...
type ResourceProviderDefaultErrorResponse struct {
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ResourceSku ...
type ResourceSku struct {
	// Name - Name of the SKU.
	Name *string `json:"name,omitempty"`
}

// SetPasswordLink ...
type SetPasswordLink struct {
	autorest.Response `json:"-"`
	SetPasswordLink   *string `json:"setPasswordLink,omitempty"`
}

// SingleSignOnConfigurationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SingleSignOnConfigurationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SingleSignOnConfigurationsClient) (SingleSignOnResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SingleSignOnConfigurationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SingleSignOnConfigurationsCreateOrUpdateFuture.Result.
func (future *SingleSignOnConfigurationsCreateOrUpdateFuture) result(client SingleSignOnConfigurationsClient) (ssor SingleSignOnResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datadog.SingleSignOnConfigurationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ssor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("datadog.SingleSignOnConfigurationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ssor.Response.Response, err = future.GetResult(sender); err == nil && ssor.Response.Response.StatusCode != http.StatusNoContent {
		ssor, err = client.CreateOrUpdateResponder(ssor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datadog.SingleSignOnConfigurationsCreateOrUpdateFuture", "Result", ssor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SingleSignOnProperties ...
type SingleSignOnProperties struct {
	// ProvisioningState - Possible values include: 'Accepted', 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled', 'Deleted', 'NotSpecified'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// SingleSignOnState - Possible values include: 'Initial', 'Enable', 'Disable', 'Existing'
	SingleSignOnState SingleSignOnStates `json:"singleSignOnState,omitempty"`
	// EnterpriseAppID - The Id of the Enterprise App used for Single sign-on.
	EnterpriseAppID *string `json:"enterpriseAppId,omitempty"`
	// SingleSignOnURL - READ-ONLY; The login URL specific to this Datadog Organization.
	SingleSignOnURL *string `json:"singleSignOnUrl,omitempty"`
}

// MarshalJSON is the custom marshaler for SingleSignOnProperties.
func (ssop SingleSignOnProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssop.ProvisioningState != "" {
		objectMap["provisioningState"] = ssop.ProvisioningState
	}
	if ssop.SingleSignOnState != "" {
		objectMap["singleSignOnState"] = ssop.SingleSignOnState
	}
	if ssop.EnterpriseAppID != nil {
		objectMap["enterpriseAppId"] = ssop.EnterpriseAppID
	}
	return json.Marshal(objectMap)
}

// SingleSignOnResource ...
type SingleSignOnResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; ARM id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the configuration.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string                 `json:"type,omitempty"`
	Properties *SingleSignOnProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SingleSignOnResource.
func (ssor SingleSignOnResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssor.Properties != nil {
		objectMap["properties"] = ssor.Properties
	}
	return json.Marshal(objectMap)
}

// SingleSignOnResourceListResponse response of a list operation.
type SingleSignOnResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]SingleSignOnResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// SingleSignOnResourceListResponseIterator provides access to a complete listing of SingleSignOnResource
// values.
type SingleSignOnResourceListResponseIterator struct {
	i    int
	page SingleSignOnResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SingleSignOnResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SingleSignOnResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SingleSignOnResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SingleSignOnResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SingleSignOnResourceListResponseIterator) Response() SingleSignOnResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SingleSignOnResourceListResponseIterator) Value() SingleSignOnResource {
	if !iter.page.NotDone() {
		return SingleSignOnResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SingleSignOnResourceListResponseIterator type.
func NewSingleSignOnResourceListResponseIterator(page SingleSignOnResourceListResponsePage) SingleSignOnResourceListResponseIterator {
	return SingleSignOnResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssorlr SingleSignOnResourceListResponse) IsEmpty() bool {
	return ssorlr.Value == nil || len(*ssorlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssorlr SingleSignOnResourceListResponse) hasNextLink() bool {
	return ssorlr.NextLink != nil && len(*ssorlr.NextLink) != 0
}

// singleSignOnResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssorlr SingleSignOnResourceListResponse) singleSignOnResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !ssorlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssorlr.NextLink)))
}

// SingleSignOnResourceListResponsePage contains a page of SingleSignOnResource values.
type SingleSignOnResourceListResponsePage struct {
	fn     func(context.Context, SingleSignOnResourceListResponse) (SingleSignOnResourceListResponse, error)
	ssorlr SingleSignOnResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SingleSignOnResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SingleSignOnResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssorlr)
		if err != nil {
			return err
		}
		page.ssorlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SingleSignOnResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SingleSignOnResourceListResponsePage) NotDone() bool {
	return !page.ssorlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SingleSignOnResourceListResponsePage) Response() SingleSignOnResourceListResponse {
	return page.ssorlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SingleSignOnResourceListResponsePage) Values() []SingleSignOnResource {
	if page.ssorlr.IsEmpty() {
		return nil
	}
	return *page.ssorlr.Value
}

// Creates a new instance of the SingleSignOnResourceListResponsePage type.
func NewSingleSignOnResourceListResponsePage(cur SingleSignOnResourceListResponse, getNextPage func(context.Context, SingleSignOnResourceListResponse) (SingleSignOnResourceListResponse, error)) SingleSignOnResourceListResponsePage {
	return SingleSignOnResourceListResponsePage{
		fn:     getNextPage,
		ssorlr: cur,
	}
}

// UserInfo user info
type UserInfo struct {
	// Name - Name of the user
	Name *string `json:"name,omitempty"`
	// EmailAddress - Email of the user used by Datadog for contacting them if needed
	EmailAddress *string `json:"emailAddress,omitempty"`
	// PhoneNumber - Phone number of the user used by Datadog for contacting them if needed
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}
