package recoveryservicessiterecovery

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.1.0.0
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// A2ARpRecoveryPointType enumerates the values for a2a rp recovery point type.
type A2ARpRecoveryPointType string

const (
	// Latest specifies the latest state for a2a rp recovery point type.
	Latest A2ARpRecoveryPointType = "Latest"
	// LatestApplicationConsistent specifies the latest application consistent state for a2a rp recovery point type.
	LatestApplicationConsistent A2ARpRecoveryPointType = "LatestApplicationConsistent"
	// LatestCrashConsistent specifies the latest crash consistent state for a2a rp recovery point type.
	LatestCrashConsistent A2ARpRecoveryPointType = "LatestCrashConsistent"
	// LatestProcessed specifies the latest processed state for a2a rp recovery point type.
	LatestProcessed A2ARpRecoveryPointType = "LatestProcessed"
)

// AlternateLocationRecoveryOption enumerates the values for alternate location recovery option.
type AlternateLocationRecoveryOption string

const (
	// CreateVMIfNotFound specifies the create vm if not found state for alternate location recovery option.
	CreateVMIfNotFound AlternateLocationRecoveryOption = "CreateVmIfNotFound"
	// NoAction specifies the no action state for alternate location recovery option.
	NoAction AlternateLocationRecoveryOption = "NoAction"
)

// DataSyncStatus enumerates the values for data sync status.
type DataSyncStatus string

const (
	// ForDownTime specifies the for down time state for data sync status.
	ForDownTime DataSyncStatus = "ForDownTime"
	// ForSynchronization specifies the for synchronization state for data sync status.
	ForSynchronization DataSyncStatus = "ForSynchronization"
)

// DisableProtectionReason enumerates the values for disable protection reason.
type DisableProtectionReason string

const (
	// MigrationComplete specifies the migration complete state for disable protection reason.
	MigrationComplete DisableProtectionReason = "MigrationComplete"
	// NotSpecified specifies the not specified state for disable protection reason.
	NotSpecified DisableProtectionReason = "NotSpecified"
)

// FailoverDeploymentModel enumerates the values for failover deployment model.
type FailoverDeploymentModel string

const (
	// Classic specifies the classic state for failover deployment model.
	Classic FailoverDeploymentModel = "Classic"
	// NotApplicable specifies the not applicable state for failover deployment model.
	NotApplicable FailoverDeploymentModel = "NotApplicable"
	// ResourceManager specifies the resource manager state for failover deployment model.
	ResourceManager FailoverDeploymentModel = "ResourceManager"
)

// HyperVReplicaAzureRpRecoveryPointType enumerates the values for hyper v replica azure rp recovery point type.
type HyperVReplicaAzureRpRecoveryPointType string

const (
	// HyperVReplicaAzureRpRecoveryPointTypeLatest specifies the hyper v replica azure rp recovery point type latest
	// state for hyper v replica azure rp recovery point type.
	HyperVReplicaAzureRpRecoveryPointTypeLatest HyperVReplicaAzureRpRecoveryPointType = "Latest"
	// HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent specifies the hyper v replica azure rp recovery
	// point type latest application consistent state for hyper v replica azure rp recovery point type.
	HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent HyperVReplicaAzureRpRecoveryPointType = "LatestApplicationConsistent"
	// HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed specifies the hyper v replica azure rp recovery point type
	// latest processed state for hyper v replica azure rp recovery point type.
	HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed HyperVReplicaAzureRpRecoveryPointType = "LatestProcessed"
)

// InMageV2RpRecoveryPointType enumerates the values for in mage v2 rp recovery point type.
type InMageV2RpRecoveryPointType string

const (
	// InMageV2RpRecoveryPointTypeLatest specifies the in mage v2 rp recovery point type latest state for in mage v2 rp
	// recovery point type.
	InMageV2RpRecoveryPointTypeLatest InMageV2RpRecoveryPointType = "Latest"
	// InMageV2RpRecoveryPointTypeLatestApplicationConsistent specifies the in mage v2 rp recovery point type latest
	// application consistent state for in mage v2 rp recovery point type.
	InMageV2RpRecoveryPointTypeLatestApplicationConsistent InMageV2RpRecoveryPointType = "LatestApplicationConsistent"
	// InMageV2RpRecoveryPointTypeLatestCrashConsistent specifies the in mage v2 rp recovery point type latest crash
	// consistent state for in mage v2 rp recovery point type.
	InMageV2RpRecoveryPointTypeLatestCrashConsistent InMageV2RpRecoveryPointType = "LatestCrashConsistent"
	// InMageV2RpRecoveryPointTypeLatestProcessed specifies the in mage v2 rp recovery point type latest processed
	// state for in mage v2 rp recovery point type.
	InMageV2RpRecoveryPointTypeLatestProcessed InMageV2RpRecoveryPointType = "LatestProcessed"
)

// LicenseType enumerates the values for license type.
type LicenseType string

const (
	// LicenseTypeNoLicenseType specifies the license type no license type state for license type.
	LicenseTypeNoLicenseType LicenseType = "NoLicenseType"
	// LicenseTypeNotSpecified specifies the license type not specified state for license type.
	LicenseTypeNotSpecified LicenseType = "NotSpecified"
	// LicenseTypeWindowsServer specifies the license type windows server state for license type.
	LicenseTypeWindowsServer LicenseType = "WindowsServer"
)

// PossibleOperationsDirections enumerates the values for possible operations directions.
type PossibleOperationsDirections string

const (
	// PrimaryToRecovery specifies the primary to recovery state for possible operations directions.
	PrimaryToRecovery PossibleOperationsDirections = "PrimaryToRecovery"
	// RecoveryToPrimary specifies the recovery to primary state for possible operations directions.
	RecoveryToPrimary PossibleOperationsDirections = "RecoveryToPrimary"
)

// RecoveryPlanActionLocation enumerates the values for recovery plan action location.
type RecoveryPlanActionLocation string

const (
	// Primary specifies the primary state for recovery plan action location.
	Primary RecoveryPlanActionLocation = "Primary"
	// Recovery specifies the recovery state for recovery plan action location.
	Recovery RecoveryPlanActionLocation = "Recovery"
)

// RecoveryPlanGroupType enumerates the values for recovery plan group type.
type RecoveryPlanGroupType string

const (
	// Boot specifies the boot state for recovery plan group type.
	Boot RecoveryPlanGroupType = "Boot"
	// Failover specifies the failover state for recovery plan group type.
	Failover RecoveryPlanGroupType = "Failover"
	// Shutdown specifies the shutdown state for recovery plan group type.
	Shutdown RecoveryPlanGroupType = "Shutdown"
)

// ReplicationProtectedItemOperation enumerates the values for replication protected item operation.
type ReplicationProtectedItemOperation string

const (
	// ChangePit specifies the change pit state for replication protected item operation.
	ChangePit ReplicationProtectedItemOperation = "ChangePit"
	// Commit specifies the commit state for replication protected item operation.
	Commit ReplicationProtectedItemOperation = "Commit"
	// CompleteMigration specifies the complete migration state for replication protected item operation.
	CompleteMigration ReplicationProtectedItemOperation = "CompleteMigration"
	// DisableProtection specifies the disable protection state for replication protected item operation.
	DisableProtection ReplicationProtectedItemOperation = "DisableProtection"
	// Failback specifies the failback state for replication protected item operation.
	Failback ReplicationProtectedItemOperation = "Failback"
	// FinalizeFailback specifies the finalize failback state for replication protected item operation.
	FinalizeFailback ReplicationProtectedItemOperation = "FinalizeFailback"
	// PlannedFailover specifies the planned failover state for replication protected item operation.
	PlannedFailover ReplicationProtectedItemOperation = "PlannedFailover"
	// RepairReplication specifies the repair replication state for replication protected item operation.
	RepairReplication ReplicationProtectedItemOperation = "RepairReplication"
	// ReverseReplicate specifies the reverse replicate state for replication protected item operation.
	ReverseReplicate ReplicationProtectedItemOperation = "ReverseReplicate"
	// SwitchProtection specifies the switch protection state for replication protected item operation.
	SwitchProtection ReplicationProtectedItemOperation = "SwitchProtection"
	// TestFailover specifies the test failover state for replication protected item operation.
	TestFailover ReplicationProtectedItemOperation = "TestFailover"
	// TestFailoverCleanup specifies the test failover cleanup state for replication protected item operation.
	TestFailoverCleanup ReplicationProtectedItemOperation = "TestFailoverCleanup"
	// UnplannedFailover specifies the unplanned failover state for replication protected item operation.
	UnplannedFailover ReplicationProtectedItemOperation = "UnplannedFailover"
)

// RpInMageRecoveryPointType enumerates the values for rp in mage recovery point type.
type RpInMageRecoveryPointType string

const (
	// Custom specifies the custom state for rp in mage recovery point type.
	Custom RpInMageRecoveryPointType = "Custom"
	// LatestTag specifies the latest tag state for rp in mage recovery point type.
	LatestTag RpInMageRecoveryPointType = "LatestTag"
	// LatestTime specifies the latest time state for rp in mage recovery point type.
	LatestTime RpInMageRecoveryPointType = "LatestTime"
)

// SetMultiVMSyncStatus enumerates the values for set multi vm sync status.
type SetMultiVMSyncStatus string

const (
	// Disable specifies the disable state for set multi vm sync status.
	Disable SetMultiVMSyncStatus = "Disable"
	// Enable specifies the enable state for set multi vm sync status.
	Enable SetMultiVMSyncStatus = "Enable"
)

// SourceSiteOperations enumerates the values for source site operations.
type SourceSiteOperations string

const (
	// NotRequired specifies the not required state for source site operations.
	NotRequired SourceSiteOperations = "NotRequired"
	// Required specifies the required state for source site operations.
	Required SourceSiteOperations = "Required"
)

// A2AApplyRecoveryPointInput is applyRecoveryPoint input specific to A2A provider.
type A2AApplyRecoveryPointInput struct {
}

// A2AContainerCreationInput is a2A cloud creation input.
type A2AContainerCreationInput struct {
}

// A2AEnableProtectionInput is a2A enable protection input.
type A2AEnableProtectionInput struct {
	FabricObjectID            *string                  `json:"fabricObjectId,omitempty"`
	RecoveryContainerID       *string                  `json:"recoveryContainerId,omitempty"`
	RecoveryResourceGroupID   *string                  `json:"recoveryResourceGroupId,omitempty"`
	RecoveryCloudServiceID    *string                  `json:"recoveryCloudServiceId,omitempty"`
	RecoveryAvailabilitySetID *string                  `json:"recoveryAvailabilitySetId,omitempty"`
	VMDisks                   *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
}

// A2AEventDetails is model class for event details of a A2A event.
type A2AEventDetails struct {
	ProtectedItemName    *string `json:"protectedItemName,omitempty"`
	FabricObjectID       *string `json:"fabricObjectId,omitempty"`
	FabricName           *string `json:"fabricName,omitempty"`
	FabricLocation       *string `json:"fabricLocation,omitempty"`
	RemoteFabricName     *string `json:"remoteFabricName,omitempty"`
	RemoteFabricLocation *string `json:"remoteFabricLocation,omitempty"`
}

// A2AFailoverProviderInput is a2A provider specific input for failover.
type A2AFailoverProviderInput struct {
	RecoveryPointID            *string `json:"recoveryPointId,omitempty"`
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`
}

// A2APolicyCreationInput is a2A Policy creation input.
type A2APolicyCreationInput struct {
	RecoveryPointHistory              *int32               `json:"recoveryPointHistory,omitempty"`
	CrashConsistentFrequencyInMinutes *int32               `json:"crashConsistentFrequencyInMinutes,omitempty"`
	AppConsistentFrequencyInMinutes   *int32               `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus                 SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
}

// A2APolicyDetails is a2A specific policy details.
type A2APolicyDetails struct {
	RecoveryPointThresholdInMinutes   *int32  `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory              *int32  `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes   *int32  `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus                 *string `json:"multiVmSyncStatus,omitempty"`
	CrashConsistentFrequencyInMinutes *int32  `json:"crashConsistentFrequencyInMinutes,omitempty"`
}

// A2AProtectedDiskDetails is a2A protected disk details.
type A2AProtectedDiskDetails struct {
	DiskURI                                *string  `json:"diskUri,omitempty"`
	DiskName                               *string  `json:"diskName,omitempty"`
	DiskCapacityInBytes                    *int64   `json:"diskCapacityInBytes,omitempty"`
	RecoveryAzureStorageAccountID          *string  `json:"recoveryAzureStorageAccountId,omitempty"`
	PrimaryStagingAzureStorageAccountID    *string  `json:"primaryStagingAzureStorageAccountId,omitempty"`
	PrimaryDiskAzureStorageAccountID       *string  `json:"primaryDiskAzureStorageAccountId,omitempty"`
	RecoveryDiskURI                        *string  `json:"recoveryDiskUri,omitempty"`
	DiskType                               *string  `json:"diskType,omitempty"`
	ResyncRequired                         *bool    `json:"resyncRequired,omitempty"`
	MonitoringPercentageCompletion         *int32   `json:"monitoringPercentageCompletion,omitempty"`
	MonitoringJobType                      *string  `json:"monitoringJobType,omitempty"`
	DataPendingInStagingStorageAccountInMB *float64 `json:"dataPendingInStagingStorageAccountInMB,omitempty"`
	DataPendingAtSourceAgentInMB           *float64 `json:"dataPendingAtSourceAgentInMB,omitempty"`
}

// A2AReplicationDetails is a2A provider specific settings.
type A2AReplicationDetails struct {
	FabricObjectID                   *string                            `json:"fabricObjectId,omitempty"`
	MultiVMGroupID                   *string                            `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName                 *string                            `json:"multiVmGroupName,omitempty"`
	ManagementID                     *string                            `json:"managementId,omitempty"`
	ProtectedDisks                   *[]A2AProtectedDiskDetails         `json:"protectedDisks,omitempty"`
	PrimaryFabricLocation            *string                            `json:"primaryFabricLocation,omitempty"`
	RecoveryFabricLocation           *string                            `json:"recoveryFabricLocation,omitempty"`
	OsType                           *string                            `json:"osType,omitempty"`
	RecoveryAzureVMSize              *string                            `json:"recoveryAzureVMSize,omitempty"`
	RecoveryAzureVMName              *string                            `json:"recoveryAzureVMName,omitempty"`
	RecoveryAzureResourceGroupID     *string                            `json:"recoveryAzureResourceGroupId,omitempty"`
	RecoveryCloudService             *string                            `json:"recoveryCloudService,omitempty"`
	RecoveryAvailabilitySet          *string                            `json:"recoveryAvailabilitySet,omitempty"`
	SelectedRecoveryAzureNetworkID   *string                            `json:"selectedRecoveryAzureNetworkId,omitempty"`
	VMNics                           *[]VMNicDetails                    `json:"vmNics,omitempty"`
	VMSyncedConfigDetails            *AzureToAzureVMSyncedConfigDetails `json:"vmSyncedConfigDetails,omitempty"`
	MonitoringPercentageCompletion   *int32                             `json:"monitoringPercentageCompletion,omitempty"`
	MonitoringJobType                *string                            `json:"monitoringJobType,omitempty"`
	LastHeartbeat                    *date.Time                         `json:"lastHeartbeat,omitempty"`
	AgentVersion                     *string                            `json:"agentVersion,omitempty"`
	IsReplicationAgentUpdateRequired *bool                              `json:"isReplicationAgentUpdateRequired,omitempty"`
	RecoveryFabricObjectID           *string                            `json:"recoveryFabricObjectId,omitempty"`
	VMProtectionState                *string                            `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription     *string                            `json:"vmProtectionStateDescription,omitempty"`
	LifecycleID                      *string                            `json:"lifecycleId,omitempty"`
}

// A2AReprotectInput is azure specific reprotect input.
type A2AReprotectInput struct {
	RecoveryContainerID       *string                  `json:"recoveryContainerId,omitempty"`
	VMDisks                   *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
	RecoveryResourceGroupID   *string                  `json:"recoveryResourceGroupId,omitempty"`
	RecoveryCloudServiceID    *string                  `json:"recoveryCloudServiceId,omitempty"`
	RecoveryAvailabilitySetID *string                  `json:"recoveryAvailabilitySetId,omitempty"`
	PolicyID                  *string                  `json:"policyId,omitempty"`
}

// A2ASwitchProtectionInput is a2A specific switch protection input.
type A2ASwitchProtectionInput struct {
	RecoveryContainerID       *string                  `json:"recoveryContainerId,omitempty"`
	VMDisks                   *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
	RecoveryResourceGroupID   *string                  `json:"recoveryResourceGroupId,omitempty"`
	RecoveryCloudServiceID    *string                  `json:"recoveryCloudServiceId,omitempty"`
	RecoveryAvailabilitySetID *string                  `json:"recoveryAvailabilitySetId,omitempty"`
	PolicyID                  *string                  `json:"policyId,omitempty"`
}

// A2AUpdateReplicationProtectedItemInput is inMage Azure V2 input to update replication protected item.
type A2AUpdateReplicationProtectedItemInput struct {
	RecoveryCloudServiceID  *string `json:"recoveryCloudServiceId,omitempty"`
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
}

// A2AVMDiskInputDetails is azure VM disk input details.
type A2AVMDiskInputDetails struct {
	DiskURI                             *string `json:"diskUri,omitempty"`
	RecoveryAzureStorageAccountID       *string `json:"recoveryAzureStorageAccountId,omitempty"`
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
}

// AddVCenterRequest is input required to add vCenter.
type AddVCenterRequest struct {
	Properties *AddVCenterRequestProperties `json:"properties,omitempty"`
}

// AddVCenterRequestProperties is the properties of an add vCenter request.
type AddVCenterRequestProperties struct {
	FriendlyName    *string `json:"friendlyName,omitempty"`
	IPAddress       *string `json:"ipAddress,omitempty"`
	ProcessServerID *string `json:"processServerId,omitempty"`
	Port            *string `json:"port,omitempty"`
	RunAsAccountID  *string `json:"runAsAccountId,omitempty"`
}

// Alert is implements the Alert class.
type Alert struct {
	autorest.Response `json:"-"`
	ID                *string          `json:"id,omitempty"`
	Name              *string          `json:"name,omitempty"`
	Type              *string          `json:"type,omitempty"`
	Location          *string          `json:"location,omitempty"`
	Properties        *AlertProperties `json:"properties,omitempty"`
}

// AlertCollection is collection of alerts.
type AlertCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Alert `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// AlertCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AlertCollection) AlertCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AlertProperties is the proprties of an alert.
type AlertProperties struct {
	SendToOwners         *string   `json:"sendToOwners,omitempty"`
	CustomEmailAddresses *[]string `json:"customEmailAddresses,omitempty"`
	Locale               *string   `json:"locale,omitempty"`
}

// ApplyRecoveryPointInput is input to apply recovery point.
type ApplyRecoveryPointInput struct {
	Properties *ApplyRecoveryPointInputProperties `json:"properties,omitempty"`
}

// ApplyRecoveryPointInputProperties is input properties to apply recovery point.
type ApplyRecoveryPointInputProperties struct {
	RecoveryPointID         *string                                  `json:"recoveryPointId,omitempty"`
	ProviderSpecificDetails *ApplyRecoveryPointProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// ApplyRecoveryPointProviderSpecificInput is provider specific input for apply recovery point.
type ApplyRecoveryPointProviderSpecificInput struct {
}

// ARMException is ARM inner exception class.
type ARMException struct {
	Code       *string                `json:"code,omitempty"`
	Message    *string                `json:"message,omitempty"`
	Target     *string                `json:"target,omitempty"`
	Details    *[]ARMExceptionDetails `json:"details,omitempty"`
	Innererror *ARMInnerError         `json:"innererror,omitempty"`
}

// ARMExceptionDetails is service based exception details.
type ARMExceptionDetails struct {
	Code              *string `json:"code,omitempty"`
	Message           *string `json:"message,omitempty"`
	PossibleCauses    *string `json:"possibleCauses,omitempty"`
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	ClientRequestID   *string `json:"clientRequestId,omitempty"`
	ActivityID        *string `json:"activityId,omitempty"`
	Target            *string `json:"target,omitempty"`
}

// ARMInnerError is ARM internal error class for providing additional debug data.
type ARMInnerError struct {
	Trace                   *string           `json:"trace,omitempty"`
	Source                  *string           `json:"source,omitempty"`
	MethodStatus            *MethodCallStatus `json:"methodStatus,omitempty"`
	CloudID                 *string           `json:"cloudId,omitempty"`
	HVHostID                *string           `json:"hVHostId,omitempty"`
	HVClusterID             *string           `json:"hVClusterId,omitempty"`
	NetworkID               *string           `json:"networkId,omitempty"`
	VMID                    *string           `json:"vmId,omitempty"`
	FabricID                *string           `json:"fabricId,omitempty"`
	LiveID                  *string           `json:"liveId,omitempty"`
	ContainerID             *string           `json:"containerId,omitempty"`
	ResourceID              *string           `json:"resourceId,omitempty"`
	ResourceName            *string           `json:"resourceName,omitempty"`
	SubscriptionID          *string           `json:"subscriptionId,omitempty"`
	SerializedSRSLogContext *string           `json:"serializedSRSLogContext,omitempty"`
}

// AsrJobDetails is this class represents job details based on specific job type.
type AsrJobDetails struct {
	AffectedObjectDetails *map[string]*string `json:"affectedObjectDetails,omitempty"`
}

// ASRTask is task of the Job.
type ASRTask struct {
	TaskID                 *string            `json:"taskId,omitempty"`
	Name                   *string            `json:"name,omitempty"`
	StartTime              *date.Time         `json:"startTime,omitempty"`
	EndTime                *date.Time         `json:"endTime,omitempty"`
	AllowedActions         *[]string          `json:"allowedActions,omitempty"`
	FriendlyName           *string            `json:"friendlyName,omitempty"`
	State                  *string            `json:"state,omitempty"`
	StateDescription       *string            `json:"stateDescription,omitempty"`
	TaskType               *string            `json:"taskType,omitempty"`
	CustomDetails          *TaskTypeDetails   `json:"customDetails,omitempty"`
	GroupTaskCustomDetails *GroupTaskDetails  `json:"groupTaskCustomDetails,omitempty"`
	Errors                 *[]JobErrorDetails `json:"errors,omitempty"`
}

// AutomationRunbookTaskDetails is this class represents the task details for an automation runbook.
type AutomationRunbookTaskDetails struct {
	Name                *string `json:"name,omitempty"`
	CloudServiceName    *string `json:"cloudServiceName,omitempty"`
	SubscriptionID      *string `json:"subscriptionId,omitempty"`
	AccountName         *string `json:"accountName,omitempty"`
	RunbookID           *string `json:"runbookId,omitempty"`
	RunbookName         *string `json:"runbookName,omitempty"`
	JobID               *string `json:"jobId,omitempty"`
	JobOutput           *string `json:"jobOutput,omitempty"`
	IsPrimarySideScript *bool   `json:"isPrimarySideScript,omitempty"`
}

// AzureFabricCreationInput is fabric provider specific settings.
type AzureFabricCreationInput struct {
	Location *string `json:"location,omitempty"`
}

// AzureFabricSpecificDetails is azure Fabric Specific Details.
type AzureFabricSpecificDetails struct {
	Location     *string   `json:"location,omitempty"`
	ContainerIds *[]string `json:"containerIds,omitempty"`
}

// AzureToAzureCreateNetworkMappingInput is create network mappings input properties/behaviour specific to Azure to
// Azure Network mapping.
type AzureToAzureCreateNetworkMappingInput struct {
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
}

// AzureToAzureNetworkMappingSettings is a2A  Network Mapping fabric specific settings.
type AzureToAzureNetworkMappingSettings struct {
	PrimaryFabricLocation  *string `json:"primaryFabricLocation,omitempty"`
	RecoveryFabricLocation *string `json:"recoveryFabricLocation,omitempty"`
}

// AzureToAzureUpdateNetworkMappingInput is updates network mappings input.
type AzureToAzureUpdateNetworkMappingInput struct {
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
}

// AzureToAzureVMSyncedConfigDetails is azure to Azure VM synced configuration details.
type AzureToAzureVMSyncedConfigDetails struct {
	Tags            *map[string]*string `json:"tags,omitempty"`
	RoleAssignments *[]RoleAssignment   `json:"roleAssignments,omitempty"`
	InputEndpoints  *[]InputEndpoint    `json:"inputEndpoints,omitempty"`
}

// AzureVMDiskDetails is disk details for E2A provider.
type AzureVMDiskDetails struct {
	VhdType            *string `json:"vhdType,omitempty"`
	VhdID              *string `json:"vhdId,omitempty"`
	VhdName            *string `json:"vhdName,omitempty"`
	MaxSizeMB          *string `json:"maxSizeMB,omitempty"`
	TargetDiskLocation *string `json:"targetDiskLocation,omitempty"`
	TargetDiskName     *string `json:"targetDiskName,omitempty"`
	LunID              *string `json:"lunId,omitempty"`
}

// ConfigurationSettings is replication provider specific settings.
type ConfigurationSettings struct {
}

// ConfigureAlertRequest is request to configure alerts for the system.
type ConfigureAlertRequest struct {
	Properties *ConfigureAlertRequestProperties `json:"properties,omitempty"`
}

// ConfigureAlertRequestProperties is properties of a configure alert request.
type ConfigureAlertRequestProperties struct {
	SendToOwners         *string   `json:"sendToOwners,omitempty"`
	CustomEmailAddresses *[]string `json:"customEmailAddresses,omitempty"`
	Locale               *string   `json:"locale,omitempty"`
}

// ConsistencyCheckTaskDetails is this class contains monitoring details of all the inconsistent Protected Entites in
// Vmm.
type ConsistencyCheckTaskDetails struct {
	VMDetails *[]InconsistentVMDetails `json:"vmDetails,omitempty"`
}

// CreateNetworkMappingInput is create network mappings input.
type CreateNetworkMappingInput struct {
	Properties *CreateNetworkMappingInputProperties `json:"properties,omitempty"`
}

// CreateNetworkMappingInputProperties is common input details for network mapping operation.
type CreateNetworkMappingInputProperties struct {
	RecoveryFabricName    *string                                  `json:"recoveryFabricName,omitempty"`
	RecoveryNetworkID     *string                                  `json:"recoveryNetworkId,omitempty"`
	FabricSpecificDetails *FabricSpecificCreateNetworkMappingInput `json:"fabricSpecificDetails,omitempty"`
}

// CreatePolicyInput is protection profile input.
type CreatePolicyInput struct {
	Properties *CreatePolicyInputProperties `json:"properties,omitempty"`
}

// CreatePolicyInputProperties is policy creation properties.
type CreatePolicyInputProperties struct {
	ProviderSpecificInput *PolicyProviderSpecificInput `json:"providerSpecificInput,omitempty"`
}

// CreateProtectionContainerInput is create protection container input.
type CreateProtectionContainerInput struct {
	Properties *CreateProtectionContainerInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerInputProperties is create protection container input properties.
type CreateProtectionContainerInputProperties struct {
	ProviderSpecificInput *[]ReplicationProviderSpecificContainerCreationInput `json:"providerSpecificInput,omitempty"`
}

// CreateProtectionContainerMappingInput is configure pairing input.
type CreateProtectionContainerMappingInput struct {
	Properties *CreateProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerMappingInputProperties is configure pairing input properties.
type CreateProtectionContainerMappingInputProperties struct {
	TargetProtectionContainerID *string                                           `json:"targetProtectionContainerId,omitempty"`
	PolicyID                    *string                                           `json:"PolicyId,omitempty"`
	ProviderSpecificInput       *ReplicationProviderSpecificContainerMappingInput `json:"providerSpecificInput,omitempty"`
}

// CreateRecoveryPlanInput is create recovery plan input class.
type CreateRecoveryPlanInput struct {
	Properties *CreateRecoveryPlanInputProperties `json:"properties,omitempty"`
}

// CreateRecoveryPlanInputProperties is recovery plan creation properties.
type CreateRecoveryPlanInputProperties struct {
	PrimaryFabricID         *string                 `json:"primaryFabricId,omitempty"`
	RecoveryFabricID        *string                 `json:"recoveryFabricId,omitempty"`
	FailoverDeploymentModel FailoverDeploymentModel `json:"failoverDeploymentModel,omitempty"`
	Groups                  *[]RecoveryPlanGroup    `json:"groups,omitempty"`
}

// CurrentScenarioDetails is current scenario details of the protected entity.
type CurrentScenarioDetails struct {
	ScenarioName *string    `json:"scenarioName,omitempty"`
	JobID        *string    `json:"jobId,omitempty"`
	StartTime    *date.Time `json:"startTime,omitempty"`
}

// DataStore is the datastore details of the MT.
type DataStore struct {
	SymbolicName *string `json:"symbolicName,omitempty"`
	UUID         *string `json:"uuid,omitempty"`
	Capacity     *string `json:"capacity,omitempty"`
	FreeSpace    *string `json:"freeSpace,omitempty"`
	Type         *string `json:"type,omitempty"`
}

// DisableProtectionInput is disable protection input.
type DisableProtectionInput struct {
	Properties *DisableProtectionInputProperties `json:"properties,omitempty"`
}

// DisableProtectionInputProperties is disable protection input properties.
type DisableProtectionInputProperties struct {
	DisableProtectionReason  DisableProtectionReason                 `json:"disableProtectionReason,omitempty"`
	ReplicationProviderInput *DisableProtectionProviderSpecificInput `json:"replicationProviderInput,omitempty"`
}

// DisableProtectionProviderSpecificInput is disable protection provider specific input.
type DisableProtectionProviderSpecificInput struct {
}

// DiscoverProtectableItemRequest is request to add a physical machine as a protectable item in a container.
type DiscoverProtectableItemRequest struct {
	Properties *DiscoverProtectableItemRequestProperties `json:"properties,omitempty"`
}

// DiscoverProtectableItemRequestProperties is discover protectable item properties.
type DiscoverProtectableItemRequestProperties struct {
	FriendlyName *string `json:"friendlyName,omitempty"`
	IPAddress    *string `json:"ipAddress,omitempty"`
	OsType       *string `json:"osType,omitempty"`
}

// DiskDetails is onprem disk details data.
type DiskDetails struct {
	MaxSizeMB *int64  `json:"maxSizeMB,omitempty"`
	VhdType   *string `json:"vhdType,omitempty"`
	VhdID     *string `json:"vhdId,omitempty"`
	VhdName   *string `json:"vhdName,omitempty"`
}

// DiskVolumeDetails is volume details.
type DiskVolumeDetails struct {
	Label *string `json:"label,omitempty"`
	Name  *string `json:"name,omitempty"`
}

// Display is contains the localized display information for this particular operation / action. These value will be
// used by several clients for (1) custom role definitions for RBAC; (2) complex query filters for the event service;
// and (3) audit history / records for management operations.
type Display struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// EnableProtectionInput is enable protection input.
type EnableProtectionInput struct {
	Properties *EnableProtectionInputProperties `json:"properties,omitempty"`
}

// EnableProtectionInputProperties is enable protection input properties.
type EnableProtectionInputProperties struct {
	PolicyID                *string                                `json:"policyId,omitempty"`
	ProtectableItemID       *string                                `json:"protectableItemId,omitempty"`
	ProviderSpecificDetails *EnableProtectionProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// EnableProtectionProviderSpecificInput is enable protection provider specific input.
type EnableProtectionProviderSpecificInput struct {
}

// EncryptionDetails is encryption details for the fabric.
type EncryptionDetails struct {
	KekState          *string    `json:"kekState,omitempty"`
	KekCertThumbprint *string    `json:"kekCertThumbprint,omitempty"`
	KekCertExpiryDate *date.Time `json:"kekCertExpiryDate,omitempty"`
}

// Event is implements the Event class.
type Event struct {
	autorest.Response `json:"-"`
	ID                *string          `json:"id,omitempty"`
	Name              *string          `json:"name,omitempty"`
	Type              *string          `json:"type,omitempty"`
	Location          *string          `json:"location,omitempty"`
	Properties        *EventProperties `json:"properties,omitempty"`
}

// EventCollection is collection of fabric details.
type EventCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Event `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// EventCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client EventCollection) EventCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// EventProperties is the properties of a monitoring event.
type EventProperties struct {
	EventCode                  *string                       `json:"eventCode,omitempty"`
	Description                *string                       `json:"description,omitempty"`
	EventType                  *string                       `json:"eventType,omitempty"`
	AffectedObjectFriendlyName *string                       `json:"affectedObjectFriendlyName,omitempty"`
	Severity                   *string                       `json:"severity,omitempty"`
	TimeOfOccurrence           *date.Time                    `json:"timeOfOccurrence,omitempty"`
	FabricID                   *string                       `json:"fabricId,omitempty"`
	ProviderSpecificDetails    *EventProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
	EventSpecificDetails       *EventSpecificDetails         `json:"eventSpecificDetails,omitempty"`
	HealthErrors               *[]HealthError                `json:"healthErrors,omitempty"`
}

// EventProviderSpecificDetails is model class for provider specific details for an event.
type EventProviderSpecificDetails struct {
}

// EventSpecificDetails is model class for event specific details for an event.
type EventSpecificDetails struct {
}

// ExportJobDetails is this class represents details for export jobs workflow.
type ExportJobDetails struct {
	AffectedObjectDetails *map[string]*string `json:"affectedObjectDetails,omitempty"`
	BlobURI               *string             `json:"blobUri,omitempty"`
	SasToken              *string             `json:"sasToken,omitempty"`
}

// Fabric is fabric definition.
type Fabric struct {
	autorest.Response `json:"-"`
	ID                *string           `json:"id,omitempty"`
	Name              *string           `json:"name,omitempty"`
	Type              *string           `json:"type,omitempty"`
	Location          *string           `json:"location,omitempty"`
	Properties        *FabricProperties `json:"properties,omitempty"`
}

// FabricCollection is collection of fabric details.
type FabricCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Fabric `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// FabricCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client FabricCollection) FabricCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// FabricCreationInput is site details provided during the time of site creation
type FabricCreationInput struct {
	Properties *FabricCreationInputProperties `json:"properties,omitempty"`
}

// FabricCreationInputProperties is properties of site details provided during the time of site creation
type FabricCreationInputProperties struct {
	CustomDetails *FabricSpecificCreationInput `json:"customDetails,omitempty"`
}

// FabricProperties is fabric properties.
type FabricProperties struct {
	FriendlyName              *string                `json:"friendlyName,omitempty"`
	EncryptionDetails         *EncryptionDetails     `json:"encryptionDetails,omitempty"`
	RolloverEncryptionDetails *EncryptionDetails     `json:"rolloverEncryptionDetails,omitempty"`
	InternalIdentifier        *string                `json:"internalIdentifier,omitempty"`
	BcdrState                 *string                `json:"bcdrState,omitempty"`
	CustomDetails             *FabricSpecificDetails `json:"customDetails,omitempty"`
	HealthErrorDetails        *[]HealthError         `json:"healthErrorDetails,omitempty"`
	Health                    *string                `json:"health,omitempty"`
}

// FabricReplicationGroupTaskDetails is this class represents the fabric replication group task details.
type FabricReplicationGroupTaskDetails struct {
	SkippedReason       *string    `json:"skippedReason,omitempty"`
	SkippedReasonString *string    `json:"skippedReasonString,omitempty"`
	JobTask             *JobEntity `json:"jobTask,omitempty"`
}

// FabricSpecificCreateNetworkMappingInput is input details specific to fabrics during Network Mapping.
type FabricSpecificCreateNetworkMappingInput struct {
}

// FabricSpecificCreationInput is fabric provider specific settings.
type FabricSpecificCreationInput struct {
}

// FabricSpecificDetails is fabric specific details.
type FabricSpecificDetails struct {
}

// FabricSpecificUpdateNetworkMappingInput is input details specific to fabrics during Network Mapping.
type FabricSpecificUpdateNetworkMappingInput struct {
}

// FailoverProcessServerRequest is request to failover a process server.
type FailoverProcessServerRequest struct {
	Properties *FailoverProcessServerRequestProperties `json:"properties,omitempty"`
}

// FailoverProcessServerRequestProperties is the properties of the Failover Process Server request.
type FailoverProcessServerRequestProperties struct {
	ContainerName         *string   `json:"containerName,omitempty"`
	SourceProcessServerID *string   `json:"sourceProcessServerId,omitempty"`
	TargetProcessServerID *string   `json:"targetProcessServerId,omitempty"`
	VmsToMigrate          *[]string `json:"vmsToMigrate,omitempty"`
	UpdateType            *string   `json:"updateType,omitempty"`
}

// GroupTaskDetails is this class represents the group task details when parent child relationship exists in the drill
// down.
type GroupTaskDetails struct {
	ChildTasks *[]ASRTask `json:"childTasks,omitempty"`
}

// HealthError is the health error class.
type HealthError struct {
	ErrorLevel                   *string    `json:"errorLevel,omitempty"`
	ErrorCode                    *string    `json:"errorCode,omitempty"`
	ErrorMessage                 *string    `json:"errorMessage,omitempty"`
	PossibleCauses               *string    `json:"possibleCauses,omitempty"`
	RecommendedAction            *string    `json:"recommendedAction,omitempty"`
	CreationTimeUtc              *date.Time `json:"creationTimeUtc,omitempty"`
	RecoveryProviderErrorMessage *string    `json:"recoveryProviderErrorMessage,omitempty"`
	EntityID                     *string    `json:"entityId,omitempty"`
}

// HyperVReplica2012EventDetails is model class for event details of a HyperVReplica E2E event.
type HyperVReplica2012EventDetails struct {
	ContainerName       *string `json:"containerName,omitempty"`
	FabricName          *string `json:"fabricName,omitempty"`
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	RemoteFabricName    *string `json:"remoteFabricName,omitempty"`
}

// HyperVReplica2012R2EventDetails is model class for event details of a HyperVReplica blue E2E event.
type HyperVReplica2012R2EventDetails struct {
	ContainerName       *string `json:"containerName,omitempty"`
	FabricName          *string `json:"fabricName,omitempty"`
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	RemoteFabricName    *string `json:"remoteFabricName,omitempty"`
}

// HyperVReplicaAzureApplyRecoveryPointInput is applyRecoveryPoint input specific to HyperVReplicaAzure provider.
type HyperVReplicaAzureApplyRecoveryPointInput struct {
	VaultLocation              *string `json:"vaultLocation,omitempty"`
	PrimaryKekCertificatePfx   *string `json:"primaryKekCertificatePfx,omitempty"`
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
}

// HyperVReplicaAzureEnableProtectionInput is azure specific enable protection input.
type HyperVReplicaAzureEnableProtectionInput struct {
	HvHostVMID                   *string   `json:"hvHostVmId,omitempty"`
	VMName                       *string   `json:"vmName,omitempty"`
	OsType                       *string   `json:"osType,omitempty"`
	VhdID                        *string   `json:"vhdId,omitempty"`
	TargetStorageAccountID       *string   `json:"targetStorageAccountId,omitempty"`
	TargetAzureNetworkID         *string   `json:"targetAzureNetworkId,omitempty"`
	TargetAzureSubnetID          *string   `json:"targetAzureSubnetId,omitempty"`
	EnableRDPOnTargetOption      *string   `json:"enableRDPOnTargetOption,omitempty"`
	TargetAzureVMName            *string   `json:"targetAzureVmName,omitempty"`
	LogStorageAccountID          *string   `json:"logStorageAccountId,omitempty"`
	DisksToInclude               *[]string `json:"disksToInclude,omitempty"`
	TargetAzureV1ResourceGroupID *string   `json:"targetAzureV1ResourceGroupId,omitempty"`
	TargetAzureV2ResourceGroupID *string   `json:"targetAzureV2ResourceGroupId,omitempty"`
	UseManagedDisks              *string   `json:"useManagedDisks,omitempty"`
}

// HyperVReplicaAzureEventDetails is model class for event details of a HyperVReplica E2A event.
type HyperVReplicaAzureEventDetails struct {
	ContainerName       *string `json:"containerName,omitempty"`
	FabricName          *string `json:"fabricName,omitempty"`
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
}

// HyperVReplicaAzureFailbackProviderInput is hvrA provider specific input for failback.
type HyperVReplicaAzureFailbackProviderInput struct {
	DataSyncOption                 *string `json:"dataSyncOption,omitempty"`
	RecoveryVMCreationOption       *string `json:"recoveryVmCreationOption,omitempty"`
	ProviderIDForAlternateRecovery *string `json:"providerIdForAlternateRecovery,omitempty"`
}

// HyperVReplicaAzureFailoverProviderInput is hvrA provider specific input for failover.
type HyperVReplicaAzureFailoverProviderInput struct {
	VaultLocation              *string `json:"vaultLocation,omitempty"`
	PrimaryKekCertificatePfx   *string `json:"primaryKekCertificatePfx,omitempty"`
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
	RecoveryPointID            *string `json:"recoveryPointId,omitempty"`
}

// HyperVReplicaAzurePolicyDetails is hyper-V Replica Azure specific protection profile details.
type HyperVReplicaAzurePolicyDetails struct {
	RecoveryPointHistoryDurationInHours           *int32  `json:"recoveryPointHistoryDurationInHours,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32  `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	ReplicationInterval                           *int32  `json:"replicationInterval,omitempty"`
	OnlineReplicationStartTime                    *string `json:"onlineReplicationStartTime,omitempty"`
	Encryption                                    *string `json:"encryption,omitempty"`
	ActiveStorageAccountID                        *string `json:"activeStorageAccountId,omitempty"`
}

// HyperVReplicaAzurePolicyInput is hyper-V Replica Azure specific input for creating a protection profile.
type HyperVReplicaAzurePolicyInput struct {
	RecoveryPointHistoryDuration                  *int32    `json:"recoveryPointHistoryDuration,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32    `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	ReplicationInterval                           *int32    `json:"replicationInterval,omitempty"`
	OnlineReplicationStartTime                    *string   `json:"onlineReplicationStartTime,omitempty"`
	Encryption                                    *string   `json:"encryption,omitempty"`
	StorageAccounts                               *[]string `json:"storageAccounts,omitempty"`
}

// HyperVReplicaAzureReplicationDetails is hyper V Replica Azure provider specific settings.
type HyperVReplicaAzureReplicationDetails struct {
	AzureVMDiskDetails               *[]AzureVMDiskDetails      `json:"azureVMDiskDetails,omitempty"`
	RecoveryAzureVMName              *string                    `json:"recoveryAzureVMName,omitempty"`
	RecoveryAzureVMSize              *string                    `json:"recoveryAzureVMSize,omitempty"`
	RecoveryAzureStorageAccount      *string                    `json:"recoveryAzureStorageAccount,omitempty"`
	RecoveryAzureLogStorageAccountID *string                    `json:"recoveryAzureLogStorageAccountId,omitempty"`
	LastReplicatedTime               *date.Time                 `json:"lastReplicatedTime,omitempty"`
	VMID                             *string                    `json:"vmId,omitempty"`
	VMProtectionState                *string                    `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription     *string                    `json:"vmProtectionStateDescription,omitempty"`
	InitialReplicationDetails        *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	VMNics                           *[]VMNicDetails            `json:"vmNics,omitempty"`
	SelectedRecoveryAzureNetworkID   *string                    `json:"selectedRecoveryAzureNetworkId,omitempty"`
	Encryption                       *string                    `json:"encryption,omitempty"`
	OSDetails                        *OSDetails                 `json:"oSDetails,omitempty"`
	SourceVMRAMSizeInMB              *int32                     `json:"sourceVmRAMSizeInMB,omitempty"`
	SourceVMCPUCount                 *int32                     `json:"sourceVmCPUCount,omitempty"`
	EnableRDPOnTargetOption          *string                    `json:"enableRDPOnTargetOption,omitempty"`
	RecoveryAzureResourceGroupID     *string                    `json:"recoveryAzureResourceGroupId,omitempty"`
	RecoveryAvailabilitySetID        *string                    `json:"recoveryAvailabilitySetId,omitempty"`
	UseManagedDisks                  *string                    `json:"useManagedDisks,omitempty"`
	LicenseType                      *string                    `json:"licenseType,omitempty"`
}

// HyperVReplicaAzureReprotectInput is azure specific reprotect input.
type HyperVReplicaAzureReprotectInput struct {
	HvHostVMID          *string `json:"hvHostVmId,omitempty"`
	VMName              *string `json:"vmName,omitempty"`
	OsType              *string `json:"osType,omitempty"`
	VHDID               *string `json:"vHDId,omitempty"`
	StorageAccountID    *string `json:"storageAccountId,omitempty"`
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
}

// HyperVReplicaAzureUpdateReplicationProtectedItemInput is hyperV replica Azure input to update replication protected
// item.
type HyperVReplicaAzureUpdateReplicationProtectedItemInput struct {
	RecoveryAzureV1ResourceGroupID *string `json:"recoveryAzureV1ResourceGroupId,omitempty"`
	RecoveryAzureV2ResourceGroupID *string `json:"recoveryAzureV2ResourceGroupId,omitempty"`
	UseManagedDisks                *string `json:"useManagedDisks,omitempty"`
}

// HyperVReplicaBaseEventDetails is abstract model class for event details of a HyperVReplica E2E event.
type HyperVReplicaBaseEventDetails struct {
	ContainerName       *string `json:"containerName,omitempty"`
	FabricName          *string `json:"fabricName,omitempty"`
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	RemoteFabricName    *string `json:"remoteFabricName,omitempty"`
}

// HyperVReplicaBasePolicyDetails is base class for HyperVReplica policy details.
type HyperVReplicaBasePolicyDetails struct {
	RecoveryPoints                                *int32  `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32  `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string `json:"compression,omitempty"`
	InitialReplicationMethod                      *string `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32  `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32  `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletionOption                         *string `json:"replicaDeletionOption,omitempty"`
}

// HyperVReplicaBaseReplicationDetails is hyper V replica provider specific settings base class.
type HyperVReplicaBaseReplicationDetails struct {
	LastReplicatedTime           *date.Time                 `json:"lastReplicatedTime,omitempty"`
	VMNics                       *[]VMNicDetails            `json:"vmNics,omitempty"`
	VMID                         *string                    `json:"vmId,omitempty"`
	VMProtectionState            *string                    `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription *string                    `json:"vmProtectionStateDescription,omitempty"`
	InitialReplicationDetails    *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	VMDiskDetails                *[]DiskDetails             `json:"vMDiskDetails,omitempty"`
}

// HyperVReplicaBluePolicyDetails is hyper-V Replica Blue specific protection profile details.
type HyperVReplicaBluePolicyDetails struct {
	ReplicationFrequencyInSeconds                 *int32  `json:"replicationFrequencyInSeconds,omitempty"`
	RecoveryPoints                                *int32  `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32  `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string `json:"compression,omitempty"`
	InitialReplicationMethod                      *string `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32  `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32  `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletionOption                         *string `json:"replicaDeletionOption,omitempty"`
}

// HyperVReplicaBluePolicyInput is hyperV Replica Blue policy input.
type HyperVReplicaBluePolicyInput struct {
	ReplicationFrequencyInSeconds                 *int32  `json:"replicationFrequencyInSeconds,omitempty"`
	RecoveryPoints                                *int32  `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32  `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string `json:"compression,omitempty"`
	InitialReplicationMethod                      *string `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32  `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32  `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletion                               *string `json:"replicaDeletion,omitempty"`
}

// HyperVReplicaBlueReplicationDetails is hyperV replica 2012 R2 (Blue) replication details.
type HyperVReplicaBlueReplicationDetails struct {
	LastReplicatedTime           *date.Time                 `json:"lastReplicatedTime,omitempty"`
	VMNics                       *[]VMNicDetails            `json:"vmNics,omitempty"`
	VMID                         *string                    `json:"vmId,omitempty"`
	VMProtectionState            *string                    `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription *string                    `json:"vmProtectionStateDescription,omitempty"`
	InitialReplicationDetails    *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	VMDiskDetails                *[]DiskDetails             `json:"vMDiskDetails,omitempty"`
}

// HyperVReplicaPolicyDetails is hyper-V Replica Blue specific protection profile details.
type HyperVReplicaPolicyDetails struct {
	RecoveryPoints                                *int32  `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32  `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string `json:"compression,omitempty"`
	InitialReplicationMethod                      *string `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32  `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32  `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletionOption                         *string `json:"replicaDeletionOption,omitempty"`
}

// HyperVReplicaPolicyInput is hyper-V Replica specific protection profile Input.
type HyperVReplicaPolicyInput struct {
	RecoveryPoints                                *int32  `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32  `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string `json:"compression,omitempty"`
	InitialReplicationMethod                      *string `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32  `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32  `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletion                               *string `json:"replicaDeletion,omitempty"`
}

// HyperVReplicaReplicationDetails is hyperV replica 2012 replication details.
type HyperVReplicaReplicationDetails struct {
	LastReplicatedTime           *date.Time                 `json:"lastReplicatedTime,omitempty"`
	VMNics                       *[]VMNicDetails            `json:"vmNics,omitempty"`
	VMID                         *string                    `json:"vmId,omitempty"`
	VMProtectionState            *string                    `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription *string                    `json:"vmProtectionStateDescription,omitempty"`
	InitialReplicationDetails    *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	VMDiskDetails                *[]DiskDetails             `json:"vMDiskDetails,omitempty"`
}

// HyperVSiteDetails is hyperVSite fabric specific details.
type HyperVSiteDetails struct {
}

// HyperVVirtualMachineDetails is hyper V replica provider specific settings
type HyperVVirtualMachineDetails struct {
	SourceItemID *string        `json:"sourceItemId,omitempty"`
	Generation   *string        `json:"generation,omitempty"`
	OsDetails    *OSDetails     `json:"osDetails,omitempty"`
	DiskDetails  *[]DiskDetails `json:"diskDetails,omitempty"`
}

// InconsistentVMDetails is this class stores the monitoring details for consistency check of inconsistent Protected
// Entity.
type InconsistentVMDetails struct {
	VMName    *string   `json:"vmName,omitempty"`
	CloudName *string   `json:"cloudName,omitempty"`
	Details   *[]string `json:"details,omitempty"`
	ErrorIds  *[]string `json:"errorIds,omitempty"`
}

// InitialReplicationDetails is initial replication details.
type InitialReplicationDetails struct {
	InitialReplicationType               *string `json:"initialReplicationType,omitempty"`
	InitialReplicationProgressPercentage *string `json:"initialReplicationProgressPercentage,omitempty"`
}

// InlineWorkflowTaskDetails is this class represents the inline workflow task details.
type InlineWorkflowTaskDetails struct {
	ChildTasks  *[]ASRTask `json:"childTasks,omitempty"`
	WorkflowIds *[]string  `json:"workflowIds,omitempty"`
}

// InMageAgentDetails is the details of the InMage agent.
type InMageAgentDetails struct {
	AgentVersion           *string `json:"agentVersion,omitempty"`
	AgentUpdateStatus      *string `json:"agentUpdateStatus,omitempty"`
	PostUpdateRebootStatus *string `json:"postUpdateRebootStatus,omitempty"`
}

// InMageAzureV2ApplyRecoveryPointInput is applyRecoveryPoint input specific to InMageAzureV2 provider.
type InMageAzureV2ApplyRecoveryPointInput struct {
	VaultLocation *string `json:"vaultLocation,omitempty"`
}

// InMageAzureV2EnableProtectionInput is vMware Azure specific enable protection input.
type InMageAzureV2EnableProtectionInput struct {
	MasterTargetID               *string   `json:"masterTargetId,omitempty"`
	ProcessServerID              *string   `json:"processServerId,omitempty"`
	StorageAccountID             *string   `json:"storageAccountId,omitempty"`
	RunAsAccountID               *string   `json:"runAsAccountId,omitempty"`
	MultiVMGroupID               *string   `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName             *string   `json:"multiVmGroupName,omitempty"`
	DisksToInclude               *[]string `json:"disksToInclude,omitempty"`
	TargetAzureNetworkID         *string   `json:"targetAzureNetworkId,omitempty"`
	TargetAzureSubnetID          *string   `json:"targetAzureSubnetId,omitempty"`
	EnableRDPOnTargetOption      *string   `json:"enableRDPOnTargetOption,omitempty"`
	TargetAzureVMName            *string   `json:"targetAzureVmName,omitempty"`
	LogStorageAccountID          *string   `json:"logStorageAccountId,omitempty"`
	TargetAzureV1ResourceGroupID *string   `json:"targetAzureV1ResourceGroupId,omitempty"`
	TargetAzureV2ResourceGroupID *string   `json:"targetAzureV2ResourceGroupId,omitempty"`
	UseManagedDisks              *string   `json:"useManagedDisks,omitempty"`
}

// InMageAzureV2EventDetails is model class for event details of a VMwareAzureV2 event.
type InMageAzureV2EventDetails struct {
	EventType        *string `json:"eventType,omitempty"`
	Category         *string `json:"category,omitempty"`
	Component        *string `json:"component,omitempty"`
	CorrectiveAction *string `json:"correctiveAction,omitempty"`
	Details          *string `json:"details,omitempty"`
	Summary          *string `json:"summary,omitempty"`
	SiteName         *string `json:"siteName,omitempty"`
}

// InMageAzureV2FailoverProviderInput is inMageAzureV2 provider specific input for failover.
type InMageAzureV2FailoverProviderInput struct {
	VaultLocation   *string `json:"vaultLocation,omitempty"`
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
}

// InMageAzureV2PolicyDetails is inMage Azure v2 specific protection profile details.
type InMageAzureV2PolicyDetails struct {
	CrashConsistentFrequencyInMinutes *int32  `json:"crashConsistentFrequencyInMinutes,omitempty"`
	RecoveryPointThresholdInMinutes   *int32  `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory              *int32  `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes   *int32  `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus                 *string `json:"multiVmSyncStatus,omitempty"`
}

// InMageAzureV2PolicyInput is vMWare Azure specific protection profile Input.
type InMageAzureV2PolicyInput struct {
	RecoveryPointThresholdInMinutes   *int32               `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory              *int32               `json:"recoveryPointHistory,omitempty"`
	CrashConsistentFrequencyInMinutes *int32               `json:"crashConsistentFrequencyInMinutes,omitempty"`
	AppConsistentFrequencyInMinutes   *int32               `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus                 SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
}

// InMageAzureV2ProtectedDiskDetails is inMageAzureV2 protected disk details.
type InMageAzureV2ProtectedDiskDetails struct {
	DiskID                    *string  `json:"diskId,omitempty"`
	DiskName                  *string  `json:"diskName,omitempty"`
	ProtectionStage           *string  `json:"protectionStage,omitempty"`
	HealthErrorCode           *string  `json:"healthErrorCode,omitempty"`
	RpoInSeconds              *int64   `json:"rpoInSeconds,omitempty"`
	ResyncRequired            *string  `json:"resyncRequired,omitempty"`
	ResyncProgressPercentage  *int32   `json:"resyncProgressPercentage,omitempty"`
	ResyncDurationInSeconds   *int64   `json:"resyncDurationInSeconds,omitempty"`
	DiskCapacityInBytes       *int64   `json:"diskCapacityInBytes,omitempty"`
	FileSystemCapacityInBytes *int64   `json:"fileSystemCapacityInBytes,omitempty"`
	SourceDataInMegaBytes     *float64 `json:"sourceDataInMegaBytes,omitempty"`
	PsDataInMegaBytes         *float64 `json:"psDataInMegaBytes,omitempty"`
	TargetDataInMegaBytes     *float64 `json:"targetDataInMegaBytes,omitempty"`
	DiskResized               *string  `json:"diskResized,omitempty"`
}

// InMageAzureV2ReplicationDetails is inMageAzureV2 provider specific settings
type InMageAzureV2ReplicationDetails struct {
	InfrastructureVMID               *string                              `json:"infrastructureVmId,omitempty"`
	VCenterInfrastructureID          *string                              `json:"vCenterInfrastructureId,omitempty"`
	ProtectionStage                  *string                              `json:"protectionStage,omitempty"`
	VMID                             *string                              `json:"vmId,omitempty"`
	VMProtectionState                *string                              `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription     *string                              `json:"vmProtectionStateDescription,omitempty"`
	ResyncProgressPercentage         *int32                               `json:"resyncProgressPercentage,omitempty"`
	RpoInSeconds                     *int64                               `json:"rpoInSeconds,omitempty"`
	CompressedDataRateInMB           *float64                             `json:"compressedDataRateInMB,omitempty"`
	UncompressedDataRateInMB         *float64                             `json:"uncompressedDataRateInMB,omitempty"`
	IPAddress                        *string                              `json:"ipAddress,omitempty"`
	AgentVersion                     *string                              `json:"agentVersion,omitempty"`
	IsAgentUpdateRequired            *string                              `json:"isAgentUpdateRequired,omitempty"`
	IsRebootAfterUpdateRequired      *string                              `json:"isRebootAfterUpdateRequired,omitempty"`
	LastHeartbeat                    *date.Time                           `json:"lastHeartbeat,omitempty"`
	ProcessServerID                  *string                              `json:"processServerId,omitempty"`
	MultiVMGroupID                   *string                              `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName                 *string                              `json:"multiVmGroupName,omitempty"`
	MultiVMSyncStatus                *string                              `json:"multiVmSyncStatus,omitempty"`
	ProtectedDisks                   *[]InMageAzureV2ProtectedDiskDetails `json:"protectedDisks,omitempty"`
	DiskResized                      *string                              `json:"diskResized,omitempty"`
	MasterTargetID                   *string                              `json:"masterTargetId,omitempty"`
	SourceVMCPUCount                 *int32                               `json:"sourceVmCPUCount,omitempty"`
	SourceVMRAMSizeInMB              *int32                               `json:"sourceVmRAMSizeInMB,omitempty"`
	OsType                           *string                              `json:"osType,omitempty"`
	VhdName                          *string                              `json:"vhdName,omitempty"`
	OsDiskID                         *string                              `json:"osDiskId,omitempty"`
	AzureVMDiskDetails               *[]AzureVMDiskDetails                `json:"azureVMDiskDetails,omitempty"`
	RecoveryAzureVMName              *string                              `json:"recoveryAzureVMName,omitempty"`
	RecoveryAzureVMSize              *string                              `json:"recoveryAzureVMSize,omitempty"`
	RecoveryAzureStorageAccount      *string                              `json:"recoveryAzureStorageAccount,omitempty"`
	RecoveryAzureLogStorageAccountID *string                              `json:"recoveryAzureLogStorageAccountId,omitempty"`
	VMNics                           *[]VMNicDetails                      `json:"vmNics,omitempty"`
	SelectedRecoveryAzureNetworkID   *string                              `json:"selectedRecoveryAzureNetworkId,omitempty"`
	DiscoveryType                    *string                              `json:"discoveryType,omitempty"`
	EnableRDPOnTargetOption          *string                              `json:"enableRDPOnTargetOption,omitempty"`
	Datastores                       *[]string                            `json:"datastores,omitempty"`
	TargetVMID                       *string                              `json:"targetVmId,omitempty"`
	RecoveryAzureResourceGroupID     *string                              `json:"recoveryAzureResourceGroupId,omitempty"`
	RecoveryAvailabilitySetID        *string                              `json:"recoveryAvailabilitySetId,omitempty"`
	UseManagedDisks                  *string                              `json:"useManagedDisks,omitempty"`
	LicenseType                      *string                              `json:"licenseType,omitempty"`
	ValidationErrors                 *[]HealthError                       `json:"validationErrors,omitempty"`
}

// InMageAzureV2ReprotectInput is inMageAzureV2 specific provider input.
type InMageAzureV2ReprotectInput struct {
	MasterTargetID      *string   `json:"masterTargetId,omitempty"`
	ProcessServerID     *string   `json:"processServerId,omitempty"`
	StorageAccountID    *string   `json:"storageAccountId,omitempty"`
	RunAsAccountID      *string   `json:"runAsAccountId,omitempty"`
	PolicyID            *string   `json:"policyId,omitempty"`
	LogStorageAccountID *string   `json:"logStorageAccountId,omitempty"`
	DisksToInclude      *[]string `json:"disksToInclude,omitempty"`
}

// InMageAzureV2UpdateReplicationProtectedItemInput is inMage Azure V2 input to update replication protected item.
type InMageAzureV2UpdateReplicationProtectedItemInput struct {
	RecoveryAzureV1ResourceGroupID *string `json:"recoveryAzureV1ResourceGroupId,omitempty"`
	RecoveryAzureV2ResourceGroupID *string `json:"recoveryAzureV2ResourceGroupId,omitempty"`
	UseManagedDisks                *string `json:"useManagedDisks,omitempty"`
}

// InMageBasePolicyDetails is base class for the policies of providers using InMage replication.
type InMageBasePolicyDetails struct {
	RecoveryPointThresholdInMinutes *int32  `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory            *int32  `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes *int32  `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus               *string `json:"multiVmSyncStatus,omitempty"`
}

// InMageDisableProtectionProviderSpecificInput is inMage disable protection provider specific input.
type InMageDisableProtectionProviderSpecificInput struct {
	ReplicaVMDeletionStatus *string `json:"replicaVmDeletionStatus,omitempty"`
}

// InMageDiskDetails is vMware/Physical specific Disk Details
type InMageDiskDetails struct {
	DiskID            *string              `json:"diskId,omitempty"`
	DiskName          *string              `json:"diskName,omitempty"`
	DiskSizeInMB      *string              `json:"diskSizeInMB,omitempty"`
	DiskType          *string              `json:"diskType,omitempty"`
	DiskConfiguration *string              `json:"diskConfiguration,omitempty"`
	VolumeList        *[]DiskVolumeDetails `json:"volumeList,omitempty"`
}

// InMageDiskExclusionInput is diskExclusionInput when doing enable protection of virtual machine in InMage provider.
type InMageDiskExclusionInput struct {
	VolumeOptions        *[]InMageVolumeExclusionOptions        `json:"volumeOptions,omitempty"`
	DiskSignatureOptions *[]InMageDiskSignatureExclusionOptions `json:"diskSignatureOptions,omitempty"`
}

// InMageDiskSignatureExclusionOptions is guest disk signature based disk exclusion option when doing enable protection
// of virtual machine in InMage provider.
type InMageDiskSignatureExclusionOptions struct {
	DiskSignature *string `json:"diskSignature,omitempty"`
}

// InMageEnableProtectionInput is vMware Azure specific enable protection input.
type InMageEnableProtectionInput struct {
	VMFriendlyName     *string                   `json:"vmFriendlyName,omitempty"`
	MasterTargetID     *string                   `json:"masterTargetId,omitempty"`
	ProcessServerID    *string                   `json:"processServerId,omitempty"`
	RetentionDrive     *string                   `json:"retentionDrive,omitempty"`
	RunAsAccountID     *string                   `json:"runAsAccountId,omitempty"`
	MultiVMGroupID     *string                   `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName   *string                   `json:"multiVmGroupName,omitempty"`
	DatastoreName      *string                   `json:"datastoreName,omitempty"`
	DiskExclusionInput *InMageDiskExclusionInput `json:"diskExclusionInput,omitempty"`
	DisksToInclude     *[]string                 `json:"disksToInclude,omitempty"`
}

// InMageFailoverProviderInput is provider specific input for InMage failover.
type InMageFailoverProviderInput struct {
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
	RecoveryPointID   *string `json:"recoveryPointId,omitempty"`
}

// InMagePolicyDetails is inMage specific protection profile details.
type InMagePolicyDetails struct {
	RecoveryPointThresholdInMinutes *int32  `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory            *int32  `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes *int32  `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus               *string `json:"multiVmSyncStatus,omitempty"`
}

// InMagePolicyInput is vMWare Azure specific protection profile Input.
type InMagePolicyInput struct {
	RecoveryPointThresholdInMinutes *int32               `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory            *int32               `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes *int32               `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus               SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
}

// InMageProtectedDiskDetails is inMage protected disk details.
type InMageProtectedDiskDetails struct {
	DiskID                    *string  `json:"diskId,omitempty"`
	DiskName                  *string  `json:"diskName,omitempty"`
	ProtectionStage           *string  `json:"protectionStage,omitempty"`
	HealthErrorCode           *string  `json:"healthErrorCode,omitempty"`
	RpoInSeconds              *int64   `json:"rpoInSeconds,omitempty"`
	ResyncRequired            *string  `json:"resyncRequired,omitempty"`
	ResyncProgressPercentage  *int32   `json:"resyncProgressPercentage,omitempty"`
	ResyncDurationInSeconds   *int64   `json:"resyncDurationInSeconds,omitempty"`
	DiskCapacityInBytes       *int64   `json:"diskCapacityInBytes,omitempty"`
	FileSystemCapacityInBytes *int64   `json:"fileSystemCapacityInBytes,omitempty"`
	SourceDataInMB            *float64 `json:"sourceDataInMB,omitempty"`
	PsDataInMB                *float64 `json:"psDataInMB,omitempty"`
	TargetDataInMB            *float64 `json:"targetDataInMB,omitempty"`
	DiskResized               *string  `json:"diskResized,omitempty"`
}

// InMageReplicationDetails is inMage provider specific settings
type InMageReplicationDetails struct {
	ActiveSiteType               *string                       `json:"activeSiteType,omitempty"`
	SourceVMCPUCount             *int32                        `json:"sourceVmCPUCount,omitempty"`
	SourceVMRAMSizeInMB          *int32                        `json:"sourceVmRAMSizeInMB,omitempty"`
	OsDetails                    *OSDiskDetails                `json:"osDetails,omitempty"`
	ProtectionStage              *string                       `json:"protectionStage,omitempty"`
	VMID                         *string                       `json:"vmId,omitempty"`
	VMProtectionState            *string                       `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription *string                       `json:"vmProtectionStateDescription,omitempty"`
	ResyncDetails                *InitialReplicationDetails    `json:"resyncDetails,omitempty"`
	RetentionWindowStart         *date.Time                    `json:"retentionWindowStart,omitempty"`
	RetentionWindowEnd           *date.Time                    `json:"retentionWindowEnd,omitempty"`
	CompressedDataRateInMB       *float64                      `json:"compressedDataRateInMB,omitempty"`
	UncompressedDataRateInMB     *float64                      `json:"uncompressedDataRateInMB,omitempty"`
	RpoInSeconds                 *int64                        `json:"rpoInSeconds,omitempty"`
	ProtectedDisks               *[]InMageProtectedDiskDetails `json:"protectedDisks,omitempty"`
	IPAddress                    *string                       `json:"ipAddress,omitempty"`
	LastHeartbeat                *date.Time                    `json:"lastHeartbeat,omitempty"`
	ProcessServerID              *string                       `json:"processServerId,omitempty"`
	MasterTargetID               *string                       `json:"masterTargetId,omitempty"`
	ConsistencyPoints            *map[string]*date.Time        `json:"consistencyPoints,omitempty"`
	DiskResized                  *string                       `json:"diskResized,omitempty"`
	RebootAfterUpdateStatus      *string                       `json:"rebootAfterUpdateStatus,omitempty"`
	MultiVMGroupID               *string                       `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName             *string                       `json:"multiVmGroupName,omitempty"`
	MultiVMSyncStatus            *string                       `json:"multiVmSyncStatus,omitempty"`
	AgentDetails                 *InMageAgentDetails           `json:"agentDetails,omitempty"`
	VCenterInfrastructureID      *string                       `json:"vCenterInfrastructureId,omitempty"`
	InfrastructureVMID           *string                       `json:"infrastructureVmId,omitempty"`
	VMNics                       *[]VMNicDetails               `json:"vmNics,omitempty"`
	DiscoveryType                *string                       `json:"discoveryType,omitempty"`
	AzureStorageAccountID        *string                       `json:"azureStorageAccountId,omitempty"`
	Datastores                   *[]string                     `json:"datastores,omitempty"`
	ValidationErrors             *[]HealthError                `json:"validationErrors,omitempty"`
}

// InMageReprotectInput is inMageAzureV2 specific provider input.
type InMageReprotectInput struct {
	MasterTargetID     *string                   `json:"masterTargetId,omitempty"`
	ProcessServerID    *string                   `json:"processServerId,omitempty"`
	RetentionDrive     *string                   `json:"retentionDrive,omitempty"`
	RunAsAccountID     *string                   `json:"runAsAccountId,omitempty"`
	DatastoreName      *string                   `json:"datastoreName,omitempty"`
	DiskExclusionInput *InMageDiskExclusionInput `json:"diskExclusionInput,omitempty"`
	ProfileID          *string                   `json:"profileId,omitempty"`
	DisksToInclude     *[]string                 `json:"disksToInclude,omitempty"`
}

// InMageVolumeExclusionOptions is guest disk signature based disk exclusion option when doing enable protection of
// virtual machine in InMage provider.
type InMageVolumeExclusionOptions struct {
	VolumeLabel               *string `json:"volumeLabel,omitempty"`
	OnlyExcludeIfSingleVolume *string `json:"OnlyExcludeIfSingleVolume,omitempty"`
}

// InputEndpoint is azure VM input endpoint details.
type InputEndpoint struct {
	EndpointName *string `json:"endpointName,omitempty"`
	PrivatePort  *int32  `json:"privatePort,omitempty"`
	PublicPort   *int32  `json:"publicPort,omitempty"`
	Protocol     *string `json:"protocol,omitempty"`
}

// Job is job details.
type Job struct {
	autorest.Response `json:"-"`
	ID                *string        `json:"id,omitempty"`
	Name              *string        `json:"name,omitempty"`
	Type              *string        `json:"type,omitempty"`
	Location          *string        `json:"location,omitempty"`
	Properties        *JobProperties `json:"properties,omitempty"`
	Status            *string        `json:"status,omitempty"`
	Error             *ARMException  `json:"error,omitempty"`
	StartTime         *string        `json:"startTime,omitempty"`
	EndTime           *string        `json:"endTime,omitempty"`
}

// JobCollection is collection of jobs.
type JobCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Job  `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// JobCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobCollection) JobCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// JobDetails is job details based on specific job type.
type JobDetails struct {
	AffectedObjectDetails *map[string]*string `json:"affectedObjectDetails,omitempty"`
}

// JobEntity is this class contains the minimal job details required to navigate to the desired drill down.
type JobEntity struct {
	JobID              *string `json:"jobId,omitempty"`
	JobFriendlyName    *string `json:"jobFriendlyName,omitempty"`
	TargetObjectID     *string `json:"targetObjectId,omitempty"`
	TargetObjectName   *string `json:"targetObjectName,omitempty"`
	TargetInstanceType *string `json:"targetInstanceType,omitempty"`
	JobScenarioName    *string `json:"jobScenarioName,omitempty"`
}

// JobErrorDetails is this class contains the error details per object.
type JobErrorDetails struct {
	ServiceErrorDetails  *ServiceError  `json:"serviceErrorDetails,omitempty"`
	ProviderErrorDetails *ProviderError `json:"providerErrorDetails,omitempty"`
	ErrorLevel           *string        `json:"errorLevel,omitempty"`
	CreationTime         *date.Time     `json:"creationTime,omitempty"`
	TaskID               *string        `json:"taskId,omitempty"`
}

// JobProperties is job custom data details.
type JobProperties struct {
	ActivityID         *string            `json:"activityId,omitempty"`
	ScenarioName       *string            `json:"scenarioName,omitempty"`
	FriendlyName       *string            `json:"friendlyName,omitempty"`
	State              *string            `json:"state,omitempty"`
	StateDescription   *string            `json:"stateDescription,omitempty"`
	Tasks              *[]ASRTask         `json:"tasks,omitempty"`
	Errors             *[]JobErrorDetails `json:"errors,omitempty"`
	StartTime          *date.Time         `json:"startTime,omitempty"`
	EndTime            *date.Time         `json:"endTime,omitempty"`
	AllowedActions     *[]string          `json:"allowedActions,omitempty"`
	TargetObjectID     *string            `json:"targetObjectId,omitempty"`
	TargetObjectName   *string            `json:"targetObjectName,omitempty"`
	TargetInstanceType *string            `json:"targetInstanceType,omitempty"`
	CustomDetails      *JobDetails        `json:"customDetails,omitempty"`
}

// JobQueryParameter is query parameter to enumerate jobs.
type JobQueryParameter struct {
	StartTime           *string   `json:"startTime,omitempty"`
	EndTime             *string   `json:"endTime,omitempty"`
	FabricID            *string   `json:"fabricId,omitempty"`
	AffectedObjectTypes *[]string `json:"affectedObjectTypes,omitempty"`
	JobStatus           *[]string `json:"jobStatus,omitempty"`
}

// JobStatusEventDetails is model class for event details of a job status event.
type JobStatusEventDetails struct {
	JobID              *string `json:"jobId,omitempty"`
	JobFriendlyName    *string `json:"jobFriendlyName,omitempty"`
	JobStatus          *string `json:"jobStatus,omitempty"`
	AffectedObjectType *string `json:"affectedObjectType,omitempty"`
}

// JobTaskDetails is this class represents a task which is actually a workflow so that one can navigate to its
// individual drill down.
type JobTaskDetails struct {
	JobTask *JobEntity `json:"jobTask,omitempty"`
}

// LogicalNetwork is logical network data model.
type LogicalNetwork struct {
	autorest.Response `json:"-"`
	ID                *string                   `json:"id,omitempty"`
	Name              *string                   `json:"name,omitempty"`
	Type              *string                   `json:"type,omitempty"`
	Location          *string                   `json:"location,omitempty"`
	Properties        *LogicalNetworkProperties `json:"properties,omitempty"`
}

// LogicalNetworkCollection is list of logical networks.
type LogicalNetworkCollection struct {
	autorest.Response `json:"-"`
	Value             *[]LogicalNetwork `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// LogicalNetworkCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LogicalNetworkCollection) LogicalNetworkCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LogicalNetworkProperties is logical Network Properties.
type LogicalNetworkProperties struct {
	FriendlyName                    *string `json:"friendlyName,omitempty"`
	NetworkVirtualizationStatus     *string `json:"networkVirtualizationStatus,omitempty"`
	LogicalNetworkUsage             *string `json:"logicalNetworkUsage,omitempty"`
	LogicalNetworkDefinitionsStatus *string `json:"logicalNetworkDefinitionsStatus,omitempty"`
}

// ManualActionTaskDetails is this class represents the manual action task details.
type ManualActionTaskDetails struct {
	Name         *string `json:"name,omitempty"`
	Instructions *string `json:"instructions,omitempty"`
	Observation  *string `json:"observation,omitempty"`
}

// MasterTargetServer is details of a Master Target Server.
type MasterTargetServer struct {
	ID               *string            `json:"id,omitempty"`
	IPAddress        *string            `json:"ipAddress,omitempty"`
	Name             *string            `json:"name,omitempty"`
	OsType           *string            `json:"osType,omitempty"`
	AgentVersion     *string            `json:"agentVersion,omitempty"`
	LastHeartbeat    *date.Time         `json:"lastHeartbeat,omitempty"`
	VersionStatus    *string            `json:"versionStatus,omitempty"`
	RetentionVolumes *[]RetentionVolume `json:"retentionVolumes,omitempty"`
	DataStores       *[]DataStore       `json:"dataStores,omitempty"`
	ValidationErrors *[]HealthError     `json:"validationErrors,omitempty"`
}

// MethodCallStatus is reports method status where exception was raised.
type MethodCallStatus struct {
	IsVirtual                 *string   `json:"isVirtual,omitempty"`
	Parameters                *[]string `json:"parameters,omitempty"`
	ContainsGenericParameters *string   `json:"containsGenericParameters,omitempty"`
}

// MobilityServiceUpdate is the Mobility Service update details.
type MobilityServiceUpdate struct {
	Version      *string `json:"version,omitempty"`
	RebootStatus *string `json:"rebootStatus,omitempty"`
	OsType       *string `json:"osType,omitempty"`
}

// Network is network model.
type Network struct {
	autorest.Response `json:"-"`
	ID                *string            `json:"id,omitempty"`
	Name              *string            `json:"name,omitempty"`
	Type              *string            `json:"type,omitempty"`
	Location          *string            `json:"location,omitempty"`
	Properties        *NetworkProperties `json:"properties,omitempty"`
}

// NetworkCollection is list of networks.
type NetworkCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Network `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// NetworkCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client NetworkCollection) NetworkCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// NetworkMapping is network Mapping model. Ideally it should have been possible to inherit this class from prev
// version in InheritedModels as long as there is no difference in structure or method signature. Since there were no
// base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the
// class has been introduced in its entirety with references to base models to facilitate exensions in subsequent
// versions.
type NetworkMapping struct {
	autorest.Response `json:"-"`
	ID                *string                   `json:"id,omitempty"`
	Name              *string                   `json:"name,omitempty"`
	Type              *string                   `json:"type,omitempty"`
	Location          *string                   `json:"location,omitempty"`
	Properties        *NetworkMappingProperties `json:"properties,omitempty"`
}

// NetworkMappingCollection is list of network mappings. As with NetworkMapping, it should be possible to reuse a prev
// version of this class. It doesn't seem likely this class could be anything more than a slightly bespoke collection
// of NetworkMapping. Hence it makes sense to override Load with Base.NetworkMapping instead of existing
// CurrentVersion.NetworkMapping.
type NetworkMappingCollection struct {
	autorest.Response `json:"-"`
	Value             *[]NetworkMapping `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// NetworkMappingCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client NetworkMappingCollection) NetworkMappingCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// NetworkMappingFabricSpecificSettings is network Mapping fabric specific settings.
type NetworkMappingFabricSpecificSettings struct {
}

// NetworkMappingProperties is network Mapping Properties.
type NetworkMappingProperties struct {
	State                       *string                               `json:"state,omitempty"`
	PrimaryNetworkFriendlyName  *string                               `json:"primaryNetworkFriendlyName,omitempty"`
	PrimaryNetworkID            *string                               `json:"primaryNetworkId,omitempty"`
	PrimaryFabricFriendlyName   *string                               `json:"primaryFabricFriendlyName,omitempty"`
	RecoveryNetworkFriendlyName *string                               `json:"recoveryNetworkFriendlyName,omitempty"`
	RecoveryNetworkID           *string                               `json:"recoveryNetworkId,omitempty"`
	RecoveryFabricArmID         *string                               `json:"recoveryFabricArmId,omitempty"`
	RecoveryFabricFriendlyName  *string                               `json:"recoveryFabricFriendlyName,omitempty"`
	FabricSpecificSettings      *NetworkMappingFabricSpecificSettings `json:"fabricSpecificSettings,omitempty"`
}

// NetworkProperties is network Properties
type NetworkProperties struct {
	FabricType   *string   `json:"fabricType,omitempty"`
	Subnets      *[]Subnet `json:"subnets,omitempty"`
	FriendlyName *string   `json:"friendlyName,omitempty"`
	NetworkType  *string   `json:"networkType,omitempty"`
}

// OperationsDiscovery is operations discovery class.
type OperationsDiscovery struct {
	Name       *string                 `json:"name,omitempty"`
	Display    *Display                `json:"display,omitempty"`
	Origin     *string                 `json:"origin,omitempty"`
	Properties *map[string]interface{} `json:"properties,omitempty"`
}

// OperationsDiscoveryCollection is collection of ClientDiscovery details.
type OperationsDiscoveryCollection struct {
	autorest.Response `json:"-"`
	Value             *[]OperationsDiscovery `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// OperationsDiscoveryCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationsDiscoveryCollection) OperationsDiscoveryCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// OSDetails is disk Details.
type OSDetails struct {
	OsType         *string `json:"osType,omitempty"`
	ProductType    *string `json:"productType,omitempty"`
	OsEdition      *string `json:"osEdition,omitempty"`
	OSVersion      *string `json:"oSVersion,omitempty"`
	OSMajorVersion *string `json:"oSMajorVersion,omitempty"`
	OSMinorVersion *string `json:"oSMinorVersion,omitempty"`
}

// OSDiskDetails is details of the OS Disk.
type OSDiskDetails struct {
	OsVhdID *string `json:"osVhdId,omitempty"`
	OsType  *string `json:"osType,omitempty"`
	VhdName *string `json:"vhdName,omitempty"`
}

// PlannedFailoverInput is input definition for planned failover.
type PlannedFailoverInput struct {
	Properties *PlannedFailoverInputProperties `json:"properties,omitempty"`
}

// PlannedFailoverInputProperties is input definition for planned failover input properties.
type PlannedFailoverInputProperties struct {
	FailoverDirection       *string                        `json:"failoverDirection,omitempty"`
	ProviderSpecificDetails *ProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// Policy is protection profile details.
type Policy struct {
	autorest.Response `json:"-"`
	ID                *string           `json:"id,omitempty"`
	Name              *string           `json:"name,omitempty"`
	Type              *string           `json:"type,omitempty"`
	Location          *string           `json:"location,omitempty"`
	Properties        *PolicyProperties `json:"properties,omitempty"`
}

// PolicyCollection is protection Profile Collection details.
type PolicyCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Policy `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// PolicyCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PolicyCollection) PolicyCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PolicyProperties is protection profile custom data details.
type PolicyProperties struct {
	FriendlyName            *string                        `json:"friendlyName,omitempty"`
	ProviderSpecificDetails *PolicyProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
}

// PolicyProviderSpecificDetails is base class for Provider specific details for policies.
type PolicyProviderSpecificDetails struct {
}

// PolicyProviderSpecificInput is base class for provider specific input
type PolicyProviderSpecificInput struct {
}

// ProcessServer is details of the Process Server.
type ProcessServer struct {
	FriendlyName               *string                  `json:"friendlyName,omitempty"`
	ID                         *string                  `json:"id,omitempty"`
	IPAddress                  *string                  `json:"ipAddress,omitempty"`
	OsType                     *string                  `json:"osType,omitempty"`
	AgentVersion               *string                  `json:"agentVersion,omitempty"`
	LastHeartbeat              *date.Time               `json:"lastHeartbeat,omitempty"`
	VersionStatus              *string                  `json:"versionStatus,omitempty"`
	MobilityServiceUpdates     *[]MobilityServiceUpdate `json:"mobilityServiceUpdates,omitempty"`
	HostID                     *string                  `json:"hostId,omitempty"`
	MachineCount               *string                  `json:"machineCount,omitempty"`
	ReplicationPairCount       *string                  `json:"replicationPairCount,omitempty"`
	SystemLoad                 *string                  `json:"systemLoad,omitempty"`
	SystemLoadStatus           *string                  `json:"systemLoadStatus,omitempty"`
	CPULoad                    *string                  `json:"cpuLoad,omitempty"`
	CPULoadStatus              *string                  `json:"cpuLoadStatus,omitempty"`
	TotalMemoryInBytes         *int64                   `json:"totalMemoryInBytes,omitempty"`
	AvailableMemoryInBytes     *int64                   `json:"availableMemoryInBytes,omitempty"`
	MemoryUsageStatus          *string                  `json:"memoryUsageStatus,omitempty"`
	TotalSpaceInBytes          *int64                   `json:"totalSpaceInBytes,omitempty"`
	AvailableSpaceInBytes      *int64                   `json:"availableSpaceInBytes,omitempty"`
	SpaceUsageStatus           *string                  `json:"spaceUsageStatus,omitempty"`
	PsServiceStatus            *string                  `json:"psServiceStatus,omitempty"`
	SslCertExpiryDate          *date.Time               `json:"sslCertExpiryDate,omitempty"`
	SslCertExpiryRemainingDays *int32                   `json:"sslCertExpiryRemainingDays,omitempty"`
}

// ProtectableItem is replication protected item
type ProtectableItem struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Properties        *ProtectableItemProperties `json:"properties,omitempty"`
}

// ProtectableItemCollection is protectable item collection.
type ProtectableItemCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProtectableItem `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// ProtectableItemCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProtectableItemCollection) ProtectableItemCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProtectableItemProperties is replication protected item custom data details.
type ProtectableItemProperties struct {
	FriendlyName                  *string                `json:"friendlyName,omitempty"`
	ProtectionStatus              *string                `json:"protectionStatus,omitempty"`
	ReplicationProtectedItemID    *string                `json:"replicationProtectedItemId,omitempty"`
	RecoveryServicesProviderID    *string                `json:"recoveryServicesProviderId,omitempty"`
	ProtectionReadinessErrors     *[]string              `json:"protectionReadinessErrors,omitempty"`
	SupportedReplicationProviders *[]string              `json:"supportedReplicationProviders,omitempty"`
	CustomDetails                 *ConfigurationSettings `json:"customDetails,omitempty"`
}

// ProtectedItemsQueryParameter is query parameter to enumerate protected items.
type ProtectedItemsQueryParameter struct {
	SourceFabricName *string `json:"sourceFabricName,omitempty"`
	RecoveryPlanName *string `json:"recoveryPlanName,omitempty"`
}

// ProtectionContainer is protection container details.
type ProtectionContainer struct {
	autorest.Response `json:"-"`
	ID                *string                        `json:"id,omitempty"`
	Name              *string                        `json:"name,omitempty"`
	Type              *string                        `json:"type,omitempty"`
	Location          *string                        `json:"location,omitempty"`
	Properties        *ProtectionContainerProperties `json:"properties,omitempty"`
}

// ProtectionContainerCollection is protection Container collection.
type ProtectionContainerCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProtectionContainer `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// ProtectionContainerCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProtectionContainerCollection) ProtectionContainerCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProtectionContainerFabricSpecificDetails is base class for fabric specific details of container.
type ProtectionContainerFabricSpecificDetails struct {
	InstanceType *string `json:"instanceType,omitempty"`
}

// ProtectionContainerMapping is protection container mapping object.
type ProtectionContainerMapping struct {
	autorest.Response `json:"-"`
	ID                *string                               `json:"id,omitempty"`
	Name              *string                               `json:"name,omitempty"`
	Type              *string                               `json:"type,omitempty"`
	Location          *string                               `json:"location,omitempty"`
	Properties        *ProtectionContainerMappingProperties `json:"properties,omitempty"`
}

// ProtectionContainerMappingCollection is protection container mapping collection class.
type ProtectionContainerMappingCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProtectionContainerMapping `json:"value,omitempty"`
	NextLink          *string                       `json:"nextLink,omitempty"`
}

// ProtectionContainerMappingCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProtectionContainerMappingCollection) ProtectionContainerMappingCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProtectionContainerMappingProperties is protection container mapping properties.
type ProtectionContainerMappingProperties struct {
	TargetProtectionContainerID           *string                                            `json:"targetProtectionContainerId,omitempty"`
	TargetProtectionContainerFriendlyName *string                                            `json:"targetProtectionContainerFriendlyName,omitempty"`
	ProviderSpecificDetails               *ProtectionContainerMappingProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
	Health                                *string                                            `json:"health,omitempty"`
	HealthErrorDetails                    *[]HealthError                                     `json:"healthErrorDetails,omitempty"`
	PolicyID                              *string                                            `json:"policyId,omitempty"`
	State                                 *string                                            `json:"state,omitempty"`
	SourceProtectionContainerFriendlyName *string                                            `json:"sourceProtectionContainerFriendlyName,omitempty"`
	SourceFabricFriendlyName              *string                                            `json:"sourceFabricFriendlyName,omitempty"`
	TargetFabricFriendlyName              *string                                            `json:"targetFabricFriendlyName,omitempty"`
	PolicyFriendlyName                    *string                                            `json:"policyFriendlyName,omitempty"`
}

// ProtectionContainerMappingProviderSpecificDetails is container mapping provider specific details.
type ProtectionContainerMappingProviderSpecificDetails struct {
	InstanceType *string `json:"instanceType,omitempty"`
}

// ProtectionContainerProperties is protection profile custom data details.
type ProtectionContainerProperties struct {
	FabricFriendlyName    *string                                   `json:"fabricFriendlyName,omitempty"`
	FriendlyName          *string                                   `json:"friendlyName,omitempty"`
	FabricType            *string                                   `json:"fabricType,omitempty"`
	ProtectedItemCount    *int32                                    `json:"protectedItemCount,omitempty"`
	PairingStatus         *string                                   `json:"pairingStatus,omitempty"`
	Role                  *string                                   `json:"role,omitempty"`
	FabricSpecificDetails *ProtectionContainerFabricSpecificDetails `json:"fabricSpecificDetails,omitempty"`
}

// ProviderError is this class contains the error details per object.
type ProviderError struct {
	ErrorCode         *int32  `json:"errorCode,omitempty"`
	ErrorMessage      *string `json:"errorMessage,omitempty"`
	ErrorID           *string `json:"errorId,omitempty"`
	PossibleCauses    *string `json:"possibleCauses,omitempty"`
	RecommendedAction *string `json:"recommendedAction,omitempty"`
}

// ProviderSpecificFailoverInput is provider specific failover input.
type ProviderSpecificFailoverInput struct {
}

// RecoveryPlan is recovery plan details.
type RecoveryPlan struct {
	autorest.Response `json:"-"`
	ID                *string                 `json:"id,omitempty"`
	Name              *string                 `json:"name,omitempty"`
	Type              *string                 `json:"type,omitempty"`
	Location          *string                 `json:"location,omitempty"`
	Properties        *RecoveryPlanProperties `json:"properties,omitempty"`
}

// RecoveryPlanA2AFailoverInput is recovery plan A2A failover input.
type RecoveryPlanA2AFailoverInput struct {
	RecoveryPointType          A2ARpRecoveryPointType `json:"recoveryPointType,omitempty"`
	CloudServiceCreationOption *string                `json:"cloudServiceCreationOption,omitempty"`
}

// RecoveryPlanAction is recovery plan action details.
type RecoveryPlanAction struct {
	ActionName         *string                              `json:"actionName,omitempty"`
	FailoverTypes      *[]ReplicationProtectedItemOperation `json:"failoverTypes,omitempty"`
	FailoverDirections *[]PossibleOperationsDirections      `json:"failoverDirections,omitempty"`
	CustomDetails      *RecoveryPlanActionDetails           `json:"customDetails,omitempty"`
}

// RecoveryPlanActionDetails is recovery plan action custom details.
type RecoveryPlanActionDetails struct {
}

// RecoveryPlanAutomationRunbookActionDetails is recovery plan Automation runbook action details.
type RecoveryPlanAutomationRunbookActionDetails struct {
	RunbookID      *string                    `json:"runbookId,omitempty"`
	Timeout        *string                    `json:"timeout,omitempty"`
	FabricLocation RecoveryPlanActionLocation `json:"fabricLocation,omitempty"`
}

// RecoveryPlanCollection is recovery plan collection details.
type RecoveryPlanCollection struct {
	autorest.Response `json:"-"`
	Value             *[]RecoveryPlan `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// RecoveryPlanCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecoveryPlanCollection) RecoveryPlanCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecoveryPlanGroup is recovery plan group details.
type RecoveryPlanGroup struct {
	GroupType                 RecoveryPlanGroupType        `json:"groupType,omitempty"`
	ReplicationProtectedItems *[]RecoveryPlanProtectedItem `json:"replicationProtectedItems,omitempty"`
	StartGroupActions         *[]RecoveryPlanAction        `json:"startGroupActions,omitempty"`
	EndGroupActions           *[]RecoveryPlanAction        `json:"endGroupActions,omitempty"`
}

// RecoveryPlanGroupTaskDetails is this class represents the recovery plan group task.
type RecoveryPlanGroupTaskDetails struct {
	ChildTasks  *[]ASRTask `json:"childTasks,omitempty"`
	Name        *string    `json:"name,omitempty"`
	GroupID     *string    `json:"groupId,omitempty"`
	RpGroupType *string    `json:"rpGroupType,omitempty"`
}

// RecoveryPlanHyperVReplicaAzureFailbackInput is recovery plan HVR Azure failback input.
type RecoveryPlanHyperVReplicaAzureFailbackInput struct {
	DataSyncOption           DataSyncStatus                  `json:"dataSyncOption,omitempty"`
	RecoveryVMCreationOption AlternateLocationRecoveryOption `json:"recoveryVmCreationOption,omitempty"`
}

// RecoveryPlanHyperVReplicaAzureFailoverInput is recovery plan HVR Azure failover input.
type RecoveryPlanHyperVReplicaAzureFailoverInput struct {
	VaultLocation              *string                               `json:"vaultLocation,omitempty"`
	PrimaryKekCertificatePfx   *string                               `json:"primaryKekCertificatePfx,omitempty"`
	SecondaryKekCertificatePfx *string                               `json:"secondaryKekCertificatePfx,omitempty"`
	RecoveryPointType          HyperVReplicaAzureRpRecoveryPointType `json:"recoveryPointType,omitempty"`
}

// RecoveryPlanInMageAzureV2FailoverInput is recovery plan InMageAzureV2 failover input.
type RecoveryPlanInMageAzureV2FailoverInput struct {
	VaultLocation     *string                     `json:"vaultLocation,omitempty"`
	RecoveryPointType InMageV2RpRecoveryPointType `json:"recoveryPointType,omitempty"`
}

// RecoveryPlanInMageFailoverInput is recovery plan InMage failover input.
type RecoveryPlanInMageFailoverInput struct {
	RecoveryPointType RpInMageRecoveryPointType `json:"recoveryPointType,omitempty"`
}

// RecoveryPlanManualActionDetails is recovery plan manual action details.
type RecoveryPlanManualActionDetails struct {
	Description *string `json:"description,omitempty"`
}

// RecoveryPlanPlannedFailoverInput is recovery plan planned failover input.
type RecoveryPlanPlannedFailoverInput struct {
	Properties *RecoveryPlanPlannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanPlannedFailoverInputProperties is recovery plan planned failover input properties.
type RecoveryPlanPlannedFailoverInputProperties struct {
	FailoverDirection       PossibleOperationsDirections                 `json:"failoverDirection,omitempty"`
	ProviderSpecificDetails *[]RecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// RecoveryPlanProperties is recovery plan custom details.
type RecoveryPlanProperties struct {
	FriendlyName                     *string                 `json:"friendlyName,omitempty"`
	PrimaryFabricID                  *string                 `json:"primaryFabricId,omitempty"`
	PrimaryFabricFriendlyName        *string                 `json:"primaryFabricFriendlyName,omitempty"`
	RecoveryFabricID                 *string                 `json:"recoveryFabricId,omitempty"`
	RecoveryFabricFriendlyName       *string                 `json:"recoveryFabricFriendlyName,omitempty"`
	FailoverDeploymentModel          *string                 `json:"failoverDeploymentModel,omitempty"`
	ReplicationProviders             *[]string               `json:"replicationProviders,omitempty"`
	AllowedOperations                *[]string               `json:"allowedOperations,omitempty"`
	LastPlannedFailoverTime          *date.Time              `json:"lastPlannedFailoverTime,omitempty"`
	LastTestFailoverTime             *date.Time              `json:"lastTestFailoverTime,omitempty"`
	CurrentScenario                  *CurrentScenarioDetails `json:"currentScenario,omitempty"`
	CurrentScenarioStatus            *string                 `json:"currentScenarioStatus,omitempty"`
	CurrentScenarioStatusDescription *string                 `json:"currentScenarioStatusDescription,omitempty"`
	Groups                           *[]RecoveryPlanGroup    `json:"groups,omitempty"`
}

// RecoveryPlanProtectedItem is recovery plan protected item.
type RecoveryPlanProtectedItem struct {
	ID               *string `json:"id,omitempty"`
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
}

// RecoveryPlanProviderSpecificFailoverInput is recovery plan provider specific failover input base class.
type RecoveryPlanProviderSpecificFailoverInput struct {
}

// RecoveryPlanScriptActionDetails is recovery plan script action details.
type RecoveryPlanScriptActionDetails struct {
	Path           *string                    `json:"path,omitempty"`
	Timeout        *string                    `json:"timeout,omitempty"`
	FabricLocation RecoveryPlanActionLocation `json:"fabricLocation,omitempty"`
}

// RecoveryPlanShutdownGroupTaskDetails is this class represents the recovery plan shutdown group task details.
type RecoveryPlanShutdownGroupTaskDetails struct {
	ChildTasks  *[]ASRTask `json:"childTasks,omitempty"`
	Name        *string    `json:"name,omitempty"`
	GroupID     *string    `json:"groupId,omitempty"`
	RpGroupType *string    `json:"rpGroupType,omitempty"`
}

// RecoveryPlanTestFailoverCleanupInput is recovery plan test failover cleanup input.
type RecoveryPlanTestFailoverCleanupInput struct {
	Properties *RecoveryPlanTestFailoverCleanupInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverCleanupInputProperties is recovery plan test failover cleanup input properties.
type RecoveryPlanTestFailoverCleanupInputProperties struct {
	Comments *string `json:"comments,omitempty"`
}

// RecoveryPlanTestFailoverInput is recovery plan test failover input.
type RecoveryPlanTestFailoverInput struct {
	Properties *RecoveryPlanTestFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverInputProperties is recovery plan test failover input properties.
type RecoveryPlanTestFailoverInputProperties struct {
	FailoverDirection       PossibleOperationsDirections                 `json:"failoverDirection,omitempty"`
	NetworkType             *string                                      `json:"networkType,omitempty"`
	NetworkID               *string                                      `json:"networkId,omitempty"`
	SkipTestFailoverCleanup *string                                      `json:"skipTestFailoverCleanup,omitempty"`
	ProviderSpecificDetails *[]RecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// RecoveryPlanUnplannedFailoverInput is recovery plan unplanned failover input.
type RecoveryPlanUnplannedFailoverInput struct {
	Properties *RecoveryPlanUnplannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanUnplannedFailoverInputProperties is recovery plan unplanned failover input properties.
type RecoveryPlanUnplannedFailoverInputProperties struct {
	FailoverDirection       PossibleOperationsDirections                 `json:"failoverDirection,omitempty"`
	SourceSiteOperations    SourceSiteOperations                         `json:"sourceSiteOperations,omitempty"`
	ProviderSpecificDetails *[]RecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// RecoveryPoint is base class representing a recovery point.
type RecoveryPoint struct {
	autorest.Response `json:"-"`
	ID                *string                  `json:"id,omitempty"`
	Name              *string                  `json:"name,omitempty"`
	Type              *string                  `json:"type,omitempty"`
	Location          *string                  `json:"location,omitempty"`
	Properties        *RecoveryPointProperties `json:"properties,omitempty"`
}

// RecoveryPointCollection is collection of recovery point details.
type RecoveryPointCollection struct {
	autorest.Response `json:"-"`
	Value             *[]RecoveryPoint `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// RecoveryPointCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecoveryPointCollection) RecoveryPointCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecoveryPointProperties is recovery point properties.
type RecoveryPointProperties struct {
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
	RecoveryPointType *string    `json:"recoveryPointType,omitempty"`
}

// RecoveryServicesProvider is provider details.
type RecoveryServicesProvider struct {
	autorest.Response `json:"-"`
	ID                *string                             `json:"id,omitempty"`
	Name              *string                             `json:"name,omitempty"`
	Type              *string                             `json:"type,omitempty"`
	Location          *string                             `json:"location,omitempty"`
	Properties        *RecoveryServicesProviderProperties `json:"properties,omitempty"`
}

// RecoveryServicesProviderCollection is collection of providers.
type RecoveryServicesProviderCollection struct {
	autorest.Response `json:"-"`
	Value             *[]RecoveryServicesProvider `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// RecoveryServicesProviderCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecoveryServicesProviderCollection) RecoveryServicesProviderCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecoveryServicesProviderProperties is recovery services provider properties.
type RecoveryServicesProviderProperties struct {
	FabricType                *string        `json:"fabricType,omitempty"`
	FriendlyName              *string        `json:"friendlyName,omitempty"`
	ProviderVersion           *string        `json:"providerVersion,omitempty"`
	ServerVersion             *string        `json:"serverVersion,omitempty"`
	ProviderVersionState      *string        `json:"providerVersionState,omitempty"`
	ProviderVersionExpiryDate *date.Time     `json:"providerVersionExpiryDate,omitempty"`
	FabricFriendlyName        *string        `json:"fabricFriendlyName,omitempty"`
	LastHeartBeat             *date.Time     `json:"lastHeartBeat,omitempty"`
	ConnectionStatus          *string        `json:"connectionStatus,omitempty"`
	ProtectedItemCount        *int32         `json:"protectedItemCount,omitempty"`
	AllowedScenarios          *[]string      `json:"allowedScenarios,omitempty"`
	HealthErrorDetails        *[]HealthError `json:"healthErrorDetails,omitempty"`
}

// RemoveProtectionContainerMappingInput is container unpairing input.
type RemoveProtectionContainerMappingInput struct {
	Properties *RemoveProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// RemoveProtectionContainerMappingInputProperties is unpairing input properties.
type RemoveProtectionContainerMappingInputProperties struct {
	ProviderSpecificInput *ReplicationProviderContainerUnmappingInput `json:"providerSpecificInput,omitempty"`
}

// RenewCertificateInput is certificate renewal input.
type RenewCertificateInput struct {
	Properties *RenewCertificateInputProperties `json:"properties,omitempty"`
}

// RenewCertificateInputProperties is renew Certificate input properties.
type RenewCertificateInputProperties struct {
	RenewCertificateType *string `json:"renewCertificateType,omitempty"`
}

// ReplicationGroupDetails is replication group details. This will be used in case of San and Wvr.
type ReplicationGroupDetails struct {
}

// ReplicationProtectedItem is replication protected item.
type ReplicationProtectedItem struct {
	autorest.Response `json:"-"`
	ID                *string                             `json:"id,omitempty"`
	Name              *string                             `json:"name,omitempty"`
	Type              *string                             `json:"type,omitempty"`
	Location          *string                             `json:"location,omitempty"`
	Properties        *ReplicationProtectedItemProperties `json:"properties,omitempty"`
}

// ReplicationProtectedItemCollection is replication protected item collection.
type ReplicationProtectedItemCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ReplicationProtectedItem `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// ReplicationProtectedItemCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ReplicationProtectedItemCollection) ReplicationProtectedItemCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ReplicationProtectedItemProperties is replication protected item custom data details.
type ReplicationProtectedItemProperties struct {
	FriendlyName                            *string                              `json:"friendlyName,omitempty"`
	ProtectedItemType                       *string                              `json:"protectedItemType,omitempty"`
	ProtectableItemID                       *string                              `json:"protectableItemId,omitempty"`
	RecoveryServicesProviderID              *string                              `json:"recoveryServicesProviderId,omitempty"`
	PrimaryFabricFriendlyName               *string                              `json:"primaryFabricFriendlyName,omitempty"`
	RecoveryFabricFriendlyName              *string                              `json:"recoveryFabricFriendlyName,omitempty"`
	RecoveryFabricID                        *string                              `json:"recoveryFabricId,omitempty"`
	PrimaryProtectionContainerFriendlyName  *string                              `json:"primaryProtectionContainerFriendlyName,omitempty"`
	RecoveryProtectionContainerFriendlyName *string                              `json:"recoveryProtectionContainerFriendlyName,omitempty"`
	ProtectionState                         *string                              `json:"protectionState,omitempty"`
	ProtectionStateDescription              *string                              `json:"protectionStateDescription,omitempty"`
	ActiveLocation                          *string                              `json:"activeLocation,omitempty"`
	TestFailoverState                       *string                              `json:"testFailoverState,omitempty"`
	TestFailoverStateDescription            *string                              `json:"testFailoverStateDescription,omitempty"`
	AllowedOperations                       *[]string                            `json:"allowedOperations,omitempty"`
	ReplicationHealth                       *string                              `json:"replicationHealth,omitempty"`
	ReplicationHealthErrors                 *[]HealthError                       `json:"replicationHealthErrors,omitempty"`
	PolicyID                                *string                              `json:"policyId,omitempty"`
	PolicyFriendlyName                      *string                              `json:"policyFriendlyName,omitempty"`
	LastSuccessfulFailoverTime              *date.Time                           `json:"lastSuccessfulFailoverTime,omitempty"`
	LastSuccessfulTestFailoverTime          *date.Time                           `json:"lastSuccessfulTestFailoverTime,omitempty"`
	CurrentScenario                         *CurrentScenarioDetails              `json:"currentScenario,omitempty"`
	FailoverRecoveryPointID                 *string                              `json:"failoverRecoveryPointId,omitempty"`
	ProviderSpecificDetails                 *ReplicationProviderSpecificSettings `json:"providerSpecificDetails,omitempty"`
	RecoveryContainerID                     *string                              `json:"recoveryContainerId,omitempty"`
}

// ReplicationProviderContainerUnmappingInput is provider specific input for unpairing operations.
type ReplicationProviderContainerUnmappingInput struct {
	InstanceType *string `json:"instanceType,omitempty"`
}

// ReplicationProviderSpecificContainerCreationInput is provider specific input for container creation operation.
type ReplicationProviderSpecificContainerCreationInput struct {
}

// ReplicationProviderSpecificContainerMappingInput is provider specific input for pairing operations.
type ReplicationProviderSpecificContainerMappingInput struct {
	InstanceType *string `json:"instanceType,omitempty"`
}

// ReplicationProviderSpecificSettings is replication provider specific settings.
type ReplicationProviderSpecificSettings struct {
}

// Resource is azure resource.
type Resource struct {
	ID       *string `json:"id,omitempty"`
	Name     *string `json:"name,omitempty"`
	Type     *string `json:"type,omitempty"`
	Location *string `json:"location,omitempty"`
}

// ResumeJobParams is resume job params.
type ResumeJobParams struct {
	Properties *ResumeJobParamsProperties `json:"properties,omitempty"`
}

// ResumeJobParamsProperties is resume job properties.
type ResumeJobParamsProperties struct {
	Comments *string `json:"comments,omitempty"`
}

// RetentionVolume is the retention details of the MT.
type RetentionVolume struct {
	VolumeName          *string `json:"volumeName,omitempty"`
	CapacityInBytes     *int64  `json:"capacityInBytes,omitempty"`
	FreeSpaceInBytes    *int64  `json:"freeSpaceInBytes,omitempty"`
	ThresholdPercentage *int32  `json:"thresholdPercentage,omitempty"`
}

// ReverseReplicationInput is reverse replication input.
type ReverseReplicationInput struct {
	Properties *ReverseReplicationInputProperties `json:"properties,omitempty"`
}

// ReverseReplicationInputProperties is reverse replication input properties.
type ReverseReplicationInputProperties struct {
	FailoverDirection       *string                                  `json:"failoverDirection,omitempty"`
	ProviderSpecificDetails *ReverseReplicationProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// ReverseReplicationProviderSpecificInput is provider specific reverse replication input.
type ReverseReplicationProviderSpecificInput struct {
}

// RoleAssignment is azure role assignment details.
type RoleAssignment struct {
	ID               *string `json:"id,omitempty"`
	Name             *string `json:"name,omitempty"`
	Scope            *string `json:"scope,omitempty"`
	PrincipalID      *string `json:"principalId,omitempty"`
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// RunAsAccount is CS Accounts Details.
type RunAsAccount struct {
	AccountID   *string `json:"accountId,omitempty"`
	AccountName *string `json:"accountName,omitempty"`
}

// SanEnableProtectionInput is san enable protection provider specific input.
type SanEnableProtectionInput struct {
}

// ScriptActionTaskDetails is this class represents the script action task details.
type ScriptActionTaskDetails struct {
	Name                *string `json:"name,omitempty"`
	Path                *string `json:"path,omitempty"`
	Output              *string `json:"output,omitempty"`
	IsPrimarySideScript *bool   `json:"isPrimarySideScript,omitempty"`
}

// ServiceError is ASR error model
type ServiceError struct {
	Code              *string `json:"code,omitempty"`
	Message           *string `json:"message,omitempty"`
	PossibleCauses    *string `json:"possibleCauses,omitempty"`
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	ActivityID        *string `json:"activityId,omitempty"`
}

// StorageClassification is storage object definition.
type StorageClassification struct {
	autorest.Response `json:"-"`
	ID                *string                          `json:"id,omitempty"`
	Name              *string                          `json:"name,omitempty"`
	Type              *string                          `json:"type,omitempty"`
	Location          *string                          `json:"location,omitempty"`
	Properties        *StorageClassificationProperties `json:"properties,omitempty"`
}

// StorageClassificationCollection is collection of storage details.
type StorageClassificationCollection struct {
	autorest.Response `json:"-"`
	Value             *[]StorageClassification `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// StorageClassificationCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client StorageClassificationCollection) StorageClassificationCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// StorageClassificationMapping is storage mapping object.
type StorageClassificationMapping struct {
	autorest.Response `json:"-"`
	ID                *string                                 `json:"id,omitempty"`
	Name              *string                                 `json:"name,omitempty"`
	Type              *string                                 `json:"type,omitempty"`
	Location          *string                                 `json:"location,omitempty"`
	Properties        *StorageClassificationMappingProperties `json:"properties,omitempty"`
}

// StorageClassificationMappingCollection is collection of storage mapping details.
type StorageClassificationMappingCollection struct {
	autorest.Response `json:"-"`
	Value             *[]StorageClassificationMapping `json:"value,omitempty"`
	NextLink          *string                         `json:"nextLink,omitempty"`
}

// StorageClassificationMappingCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client StorageClassificationMappingCollection) StorageClassificationMappingCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// StorageClassificationMappingInput is storage mapping input.
type StorageClassificationMappingInput struct {
	Properties *StorageMappingInputProperties `json:"properties,omitempty"`
}

// StorageClassificationMappingProperties is storage mapping properties.
type StorageClassificationMappingProperties struct {
	TargetStorageClassificationID *string `json:"targetStorageClassificationId,omitempty"`
}

// StorageClassificationProperties is storage object properties.
type StorageClassificationProperties struct {
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// StorageMappingInputProperties is storage mapping input properties.
type StorageMappingInputProperties struct {
	TargetStorageClassificationID *string `json:"targetStorageClassificationId,omitempty"`
}

// Subnet is subnets of the network.
type Subnet struct {
	Name         *string   `json:"name,omitempty"`
	FriendlyName *string   `json:"friendlyName,omitempty"`
	AddressList  *[]string `json:"addressList,omitempty"`
}

// SwitchProtectionInput is switch protection input.
type SwitchProtectionInput struct {
	Properties *SwitchProtectionInputProperties `json:"properties,omitempty"`
}

// SwitchProtectionInputProperties is switch protection input properties.
type SwitchProtectionInputProperties struct {
	ReplicationProtectedItemName *string                                `json:"replicationProtectedItemName,omitempty"`
	ProviderSpecificDetails      *SwitchProtectionProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// SwitchProtectionJobDetails is this class represents details for switch protection job.
type SwitchProtectionJobDetails struct {
	AffectedObjectDetails         *map[string]*string `json:"affectedObjectDetails,omitempty"`
	NewReplicationProtectedItemID *string             `json:"newReplicationProtectedItemId,omitempty"`
}

// SwitchProtectionProviderSpecificInput is provider specific switch protection input.
type SwitchProtectionProviderSpecificInput struct {
}

// TaskTypeDetails is task details based on specific task type.
type TaskTypeDetails struct {
}

// TestFailoverCleanupInput is input definition for test failover cleanup.
type TestFailoverCleanupInput struct {
	Properties *TestFailoverCleanupInputProperties `json:"properties,omitempty"`
}

// TestFailoverCleanupInputProperties is input definition for test failover cleanup input properties.
type TestFailoverCleanupInputProperties struct {
	Comments *string `json:"comments,omitempty"`
}

// TestFailoverInput is input definition for planned failover.
type TestFailoverInput struct {
	Properties *TestFailoverInputProperties `json:"properties,omitempty"`
}

// TestFailoverInputProperties is input definition for planned failover input properties.
type TestFailoverInputProperties struct {
	FailoverDirection       *string                        `json:"failoverDirection,omitempty"`
	NetworkType             *string                        `json:"networkType,omitempty"`
	NetworkID               *string                        `json:"networkId,omitempty"`
	SkipTestFailoverCleanup *string                        `json:"skipTestFailoverCleanup,omitempty"`
	ProviderSpecificDetails *ProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// TestFailoverJobDetails is this class represents the details for a test failover job.
type TestFailoverJobDetails struct {
	AffectedObjectDetails *map[string]*string                            `json:"affectedObjectDetails,omitempty"`
	TestFailoverStatus    *string                                        `json:"testFailoverStatus,omitempty"`
	Comments              *string                                        `json:"comments,omitempty"`
	NetworkName           *string                                        `json:"networkName,omitempty"`
	NetworkFriendlyName   *string                                        `json:"networkFriendlyName,omitempty"`
	NetworkType           *string                                        `json:"networkType,omitempty"`
	ProtectedItemDetails  *[]TestFailoverReplicationProtectedItemDetails `json:"protectedItemDetails,omitempty"`
}

// TestFailoverReplicationProtectedItemDetails is test failover details for a replication protected item.
type TestFailoverReplicationProtectedItemDetails struct {
	Name                    *string `json:"name,omitempty"`
	FriendlyName            *string `json:"friendlyName,omitempty"`
	TestVMName              *string `json:"testVmName,omitempty"`
	TestVMFriendlyName      *string `json:"testVmFriendlyName,omitempty"`
	NetworkConnectionStatus *string `json:"networkConnectionStatus,omitempty"`
	NetworkFriendlyName     *string `json:"networkFriendlyName,omitempty"`
	Subnet                  *string `json:"subnet,omitempty"`
}

// UnplannedFailoverInput is input definition for planned failover.
type UnplannedFailoverInput struct {
	Properties *UnplannedFailoverInputProperties `json:"properties,omitempty"`
}

// UnplannedFailoverInputProperties is input definition for planned failover input properties.
type UnplannedFailoverInputProperties struct {
	FailoverDirection       *string                        `json:"failoverDirection,omitempty"`
	SourceSiteOperations    *string                        `json:"sourceSiteOperations,omitempty"`
	ProviderSpecificDetails *ProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UpdateMobilityServiceRequest is request to update the mobility service on a protected item.
type UpdateMobilityServiceRequest struct {
	Properties *UpdateMobilityServiceRequestProperties `json:"properties,omitempty"`
}

// UpdateMobilityServiceRequestProperties is the properties of an update mobility service request.
type UpdateMobilityServiceRequestProperties struct {
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// UpdateNetworkMappingInput is update network mapping input.
type UpdateNetworkMappingInput struct {
	Properties *UpdateNetworkMappingInputProperties `json:"properties,omitempty"`
}

// UpdateNetworkMappingInputProperties is common input details for network mapping operation.
type UpdateNetworkMappingInputProperties struct {
	RecoveryFabricName    *string                                  `json:"recoveryFabricName,omitempty"`
	RecoveryNetworkID     *string                                  `json:"recoveryNetworkId,omitempty"`
	FabricSpecificDetails *FabricSpecificUpdateNetworkMappingInput `json:"fabricSpecificDetails,omitempty"`
}

// UpdatePolicyInput is update protection profile input.
type UpdatePolicyInput struct {
	Properties *UpdatePolicyInputProperties `json:"properties,omitempty"`
}

// UpdatePolicyInputProperties is policy update properties.
type UpdatePolicyInputProperties struct {
	ReplicationProviderSettings *PolicyProviderSpecificInput `json:"replicationProviderSettings,omitempty"`
}

// UpdateRecoveryPlanInput is update recovery plan input class.
type UpdateRecoveryPlanInput struct {
	Properties *UpdateRecoveryPlanInputProperties `json:"properties,omitempty"`
}

// UpdateRecoveryPlanInputProperties is recovery plan updation properties.
type UpdateRecoveryPlanInputProperties struct {
	Groups *[]RecoveryPlanGroup `json:"groups,omitempty"`
}

// UpdateReplicationProtectedItemInput is update replication protected item input.
type UpdateReplicationProtectedItemInput struct {
	Properties *UpdateReplicationProtectedItemInputProperties `json:"properties,omitempty"`
}

// UpdateReplicationProtectedItemInputProperties is update protected item input properties.
type UpdateReplicationProtectedItemInputProperties struct {
	RecoveryAzureVMName            *string                                      `json:"recoveryAzureVMName,omitempty"`
	RecoveryAzureVMSize            *string                                      `json:"recoveryAzureVMSize,omitempty"`
	SelectedRecoveryAzureNetworkID *string                                      `json:"selectedRecoveryAzureNetworkId,omitempty"`
	EnableRDPOnTargetOption        *string                                      `json:"enableRDPOnTargetOption,omitempty"`
	VMNics                         *[]VMNicInputDetails                         `json:"vmNics,omitempty"`
	LicenseType                    LicenseType                                  `json:"licenseType,omitempty"`
	RecoveryAvailabilitySetID      *string                                      `json:"recoveryAvailabilitySetId,omitempty"`
	ProviderSpecificDetails        *UpdateReplicationProtectedItemProviderInput `json:"providerSpecificDetails,omitempty"`
}

// UpdateReplicationProtectedItemProviderInput is update replication protected item provider specific input.
type UpdateReplicationProtectedItemProviderInput struct {
}

// UpdateVCenterRequest is input required to update vCenter.
type UpdateVCenterRequest struct {
	Properties *UpdateVCenterRequestProperties `json:"properties,omitempty"`
}

// UpdateVCenterRequestProperties is the properties of an update vCenter request.
type UpdateVCenterRequestProperties struct {
	FriendlyName    *string `json:"friendlyName,omitempty"`
	IPAddress       *string `json:"ipAddress,omitempty"`
	ProcessServerID *string `json:"processServerId,omitempty"`
	Port            *string `json:"port,omitempty"`
	RunAsAccountID  *string `json:"runAsAccountId,omitempty"`
}

// VCenter is vCenter definition.
type VCenter struct {
	autorest.Response `json:"-"`
	ID                *string            `json:"id,omitempty"`
	Name              *string            `json:"name,omitempty"`
	Type              *string            `json:"type,omitempty"`
	Location          *string            `json:"location,omitempty"`
	Properties        *VCenterProperties `json:"properties,omitempty"`
}

// VCenterCollection is collection of vCenter details.
type VCenterCollection struct {
	autorest.Response `json:"-"`
	Value             *[]VCenter `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// VCenterCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VCenterCollection) VCenterCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VCenterProperties is vCenter properties.
type VCenterProperties struct {
	FriendlyName          *string    `json:"friendlyName,omitempty"`
	InternalID            *string    `json:"internalId,omitempty"`
	LastHeartbeat         *date.Time `json:"lastHeartbeat,omitempty"`
	DiscoveryStatus       *string    `json:"discoveryStatus,omitempty"`
	ProcessServerID       *string    `json:"processServerId,omitempty"`
	IPAddress             *string    `json:"ipAddress,omitempty"`
	InfrastructureID      *string    `json:"infrastructureId,omitempty"`
	Port                  *string    `json:"port,omitempty"`
	RunAsAccountID        *string    `json:"runAsAccountId,omitempty"`
	FabricArmResourceName *string    `json:"fabricArmResourceName,omitempty"`
}

// VirtualMachineTaskDetails is this class represents the virtual machine task details.
type VirtualMachineTaskDetails struct {
	SkippedReason       *string    `json:"skippedReason,omitempty"`
	SkippedReasonString *string    `json:"skippedReasonString,omitempty"`
	JobTask             *JobEntity `json:"jobTask,omitempty"`
}

// VmmDetails is VMM fabric specific details.
type VmmDetails struct {
}

// VmmToAzureCreateNetworkMappingInput is create network mappings input properties/behaviour specific to Vmm to Azure
// Network mapping.
type VmmToAzureCreateNetworkMappingInput struct {
}

// VmmToAzureNetworkMappingSettings is e2A  Network Mapping fabric specific settings.
type VmmToAzureNetworkMappingSettings struct {
}

// VmmToAzureUpdateNetworkMappingInput is update network mappings input properties/behaviour specific to vmm to azure.
type VmmToAzureUpdateNetworkMappingInput struct {
}

// VmmToVmmCreateNetworkMappingInput is create network mappings input properties/behaviour specific to vmm to vmm
// Network mapping.
type VmmToVmmCreateNetworkMappingInput struct {
}

// VmmToVmmNetworkMappingSettings is e2E  Network Mapping fabric specific settings.
type VmmToVmmNetworkMappingSettings struct {
}

// VmmToVmmUpdateNetworkMappingInput is update network mappings input properties/behaviour specific to vmm to vmm.
type VmmToVmmUpdateNetworkMappingInput struct {
}

// VMNicDetails is hyper V VM network details.
type VMNicDetails struct {
	NicID                     *string `json:"nicId,omitempty"`
	ReplicaNicID              *string `json:"replicaNicId,omitempty"`
	SourceNicArmID            *string `json:"sourceNicArmId,omitempty"`
	VMSubnetName              *string `json:"vMSubnetName,omitempty"`
	VMNetworkName             *string `json:"vMNetworkName,omitempty"`
	RecoveryVMNetworkID       *string `json:"recoveryVMNetworkId,omitempty"`
	RecoveryVMSubnetName      *string `json:"recoveryVMSubnetName,omitempty"`
	IPAddressType             *string `json:"ipAddressType,omitempty"`
	PrimaryNicStaticIPAddress *string `json:"primaryNicStaticIPAddress,omitempty"`
	ReplicaNicStaticIPAddress *string `json:"replicaNicStaticIPAddress,omitempty"`
	SelectionType             *string `json:"selectionType,omitempty"`
}

// VMNicInputDetails is hyper V VM network input details.
type VMNicInputDetails struct {
	NicID                     *string `json:"nicId,omitempty"`
	RecoveryVMSubnetName      *string `json:"recoveryVMSubnetName,omitempty"`
	ReplicaNicStaticIPAddress *string `json:"replicaNicStaticIPAddress,omitempty"`
	SelectionType             *string `json:"selectionType,omitempty"`
}

// VMNicUpdatesTaskDetails is this class represents the vm NicUpdates task details.
type VMNicUpdatesTaskDetails struct {
	VMID  *string `json:"vmId,omitempty"`
	NicID *string `json:"nicId,omitempty"`
	Name  *string `json:"name,omitempty"`
}

// VMwareDetails is store the fabric details specific to the VMware fabric.
type VMwareDetails struct {
	ProcessServers             *[]ProcessServer      `json:"processServers,omitempty"`
	MasterTargetServers        *[]MasterTargetServer `json:"masterTargetServers,omitempty"`
	RunAsAccounts              *[]RunAsAccount       `json:"runAsAccounts,omitempty"`
	ReplicationPairCount       *string               `json:"replicationPairCount,omitempty"`
	ProcessServerCount         *string               `json:"processServerCount,omitempty"`
	AgentCount                 *string               `json:"agentCount,omitempty"`
	ProtectedServers           *string               `json:"protectedServers,omitempty"`
	SystemLoad                 *string               `json:"systemLoad,omitempty"`
	SystemLoadStatus           *string               `json:"systemLoadStatus,omitempty"`
	CPULoad                    *string               `json:"cpuLoad,omitempty"`
	CPULoadStatus              *string               `json:"cpuLoadStatus,omitempty"`
	TotalMemoryInBytes         *int64                `json:"totalMemoryInBytes,omitempty"`
	AvailableMemoryInBytes     *int64                `json:"availableMemoryInBytes,omitempty"`
	MemoryUsageStatus          *string               `json:"memoryUsageStatus,omitempty"`
	TotalSpaceInBytes          *int64                `json:"totalSpaceInBytes,omitempty"`
	AvailableSpaceInBytes      *int64                `json:"availableSpaceInBytes,omitempty"`
	SpaceUsageStatus           *string               `json:"spaceUsageStatus,omitempty"`
	WebLoad                    *string               `json:"webLoad,omitempty"`
	WebLoadStatus              *string               `json:"webLoadStatus,omitempty"`
	DatabaseServerLoad         *string               `json:"databaseServerLoad,omitempty"`
	DatabaseServerLoadStatus   *string               `json:"databaseServerLoadStatus,omitempty"`
	CsServiceStatus            *string               `json:"csServiceStatus,omitempty"`
	IPAddress                  *string               `json:"ipAddress,omitempty"`
	AgentVersion               *string               `json:"agentVersion,omitempty"`
	HostName                   *string               `json:"hostName,omitempty"`
	LastHeartbeat              *date.Time            `json:"lastHeartbeat,omitempty"`
	VersionStatus              *string               `json:"versionStatus,omitempty"`
	SslCertExpiryDate          *date.Time            `json:"sslCertExpiryDate,omitempty"`
	SslCertExpiryRemainingDays *int32                `json:"sslCertExpiryRemainingDays,omitempty"`
	PsTemplateVersion          *string               `json:"psTemplateVersion,omitempty"`
}

// VMwareVirtualMachineDetails is vMware provider specific settings
type VMwareVirtualMachineDetails struct {
	AgentGeneratedID        *string              `json:"agentGeneratedId,omitempty"`
	AgentInstalled          *string              `json:"agentInstalled,omitempty"`
	OsType                  *string              `json:"osType,omitempty"`
	AgentVersion            *string              `json:"agentVersion,omitempty"`
	IPAddress               *string              `json:"ipAddress,omitempty"`
	PoweredOn               *string              `json:"poweredOn,omitempty"`
	VCenterInfrastructureID *string              `json:"vCenterInfrastructureId,omitempty"`
	DiscoveryType           *string              `json:"discoveryType,omitempty"`
	DiskDetails             *[]InMageDiskDetails `json:"diskDetails,omitempty"`
	ValidationErrors        *[]HealthError       `json:"validationErrors,omitempty"`
}
